/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.views;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugin.searchrequestview.RequestHeaders;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestView;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestViewModuleDescriptor;
import com.atlassian.jira.plugins.importer.exports.IssuesExporter;
import com.atlassian.jira.plugins.importer.sample.SampleData;
import com.atlassian.jira.plugins.importer.sample.mapper.ObjectMapperFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.http.JiraHttpUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Optional;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchRequestJsonView
implements SearchRequestView {
    private static final Logger log = LoggerFactory.getLogger(SearchRequestJsonView.class);
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final IssuesExporter issuesExporter;
    private final ObjectMapperFactory objectMapperFactory;

    public SearchRequestJsonView(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport PermissionManager permissionManager, IssuesExporter issuesExporter, ObjectMapperFactory objectMapperFactory) {
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
        this.issuesExporter = issuesExporter;
        this.objectMapperFactory = objectMapperFactory;
    }

    public void init(SearchRequestViewModuleDescriptor searchRequestViewModuleDescriptor) {
    }

    public void writeSearchResults(SearchRequest searchRequest, SearchRequestParams searchRequestParams, Writer writer) {
        if (!this.permissionManager.hasPermission(0, this.authenticationContext.getUser())) {
            try {
                writer.append(this.authenticationContext.getI18nHelper().getText("jira-importer-plugin.must.be.admin"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        Optional<SampleData> sampleData = this.issuesExporter.exportIssues(searchRequest);
        if (!sampleData.isPresent()) {
            return;
        }
        try {
            this.objectMapperFactory.createMapper().writer().writeValue(writer, sampleData.get());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeHeaders(SearchRequest searchRequest, RequestHeaders requestHeaders, SearchRequestParams searchRequestParams) {
        JiraHttpUtils.setNoCacheHeaders((RequestHeaders)requestHeaders);
    }
}

