/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.tracking;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class UsageTrackingServiceImpl
implements UsageTrackingService {
    private static final Logger log = Logger.getLogger(UsageTrackingServiceImpl.class);
    static final String GA_RESOURCE = "com.atlassian.jira.plugins.jira-importers-plugin:ga";
    public static final String JIRA_OPTION_BTF_ANALYTICS_ENABLED = "jira.btf.analytics.enabled";
    private final ApplicationProperties applicationProperties;
    private final WebResourceManager webResourceManager;

    @Autowired
    public UsageTrackingServiceImpl(@ComponentImport WebResourceManager webResourceManager, @ComponentImport ApplicationProperties applicationProperties) {
        this.webResourceManager = webResourceManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public void includeTrackingWhenActive() {
        if (this.isActive()) {
            this.webResourceManager.requireResource(GA_RESOURCE);
        }
    }

    @Override
    public synchronized boolean isActive() {
        return this.applicationProperties.getOption(JIRA_OPTION_BTF_ANALYTICS_ENABLED);
    }

    @Override
    @Deprecated
    public boolean isTrackingStatusDefined() {
        return this.applicationProperties.getKeys().contains(JIRA_OPTION_BTF_ANALYTICS_ENABLED);
    }

    @Override
    @Deprecated
    public synchronized void activate() {
        log.warn((Object)"UsageTrackingServiceImpl::activate has been deprecated and does exactly nothing now!");
    }

    @Override
    @Deprecated
    public synchronized void deactivate() {
        log.warn((Object)"UsageTrackingServiceImpl::deactivate has been deprecated and does exactly nothing now!");
    }
}

