/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.sample.mapper.utils;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class FilterUtilities {
    public static <T> T getBeanValue(Object bean, String propertyName) throws Exception {
        Method getter = FilterUtilities.findGetterMethod(bean, propertyName);
        Object attribute = null;
        if (getter != null) {
            attribute = getter.invoke(bean, new Object[0]);
        } else {
            Field field = FilterUtilities.findField(bean, propertyName);
            if (field != null) {
                attribute = field.get(bean);
            }
        }
        return (T)attribute;
    }

    private static Method findGetterMethod(Object bean, String name) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptors;
        for (PropertyDescriptor pd : propertyDescriptors = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors()) {
            if (!pd.getName().equalsIgnoreCase(name)) continue;
            return pd.getReadMethod();
        }
        return null;
    }

    private static Field findField(Object bean, String name) {
        try {
            Field field = bean.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }
}

