/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.sample;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.ImportStats;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporterFactory;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ImporterCallable;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ImporterExecutionContext;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ImporterOptions;
import com.atlassian.jira.plugins.importer.sample.AttachmentsProvider;
import com.atlassian.jira.plugins.importer.sample.AvatarsProvider;
import com.atlassian.jira.plugins.importer.sample.Callbacks;
import com.atlassian.jira.plugins.importer.sample.SampleData;
import com.atlassian.jira.plugins.importer.sample.SampleDataBean;
import com.atlassian.jira.plugins.importer.sample.SampleDataImporter;
import com.atlassian.jira.plugins.importer.sample.SampleDataImporter2;
import com.atlassian.jira.plugins.importer.sample.mapper.ObjectMapperFactory;
import com.atlassian.jira.plugins.importer.sample.mapper.ObjectMapperFactoryImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={SampleDataImporter2.class, SampleDataImporter.class})
public class SampleDataImporterImpl
implements SampleDataImporter2 {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final JiraDataImporterFactory jiraDataImporterFactory;
    private final ConstantsManager constantsManager;
    private final TemplateRenderer templateRenderer;
    private final ObjectMapperFactory objectMapperFactory;

    @Autowired
    public SampleDataImporterImpl(@JiraComponent JiraAuthenticationContext jiraAuthenticationContext, JiraDataImporterFactory jiraDataImporterFactory, @ComponentImport ConstantsManager constantsManager, @ComponentImport TemplateRenderer templateRenderer, ObjectMapperFactory objectMapperFactory) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.jiraDataImporterFactory = jiraDataImporterFactory;
        this.constantsManager = constantsManager;
        this.templateRenderer = templateRenderer;
        this.objectMapperFactory = objectMapperFactory;
    }

    @Deprecated
    public static ObjectMapper getObjectMapper() {
        return new ObjectMapperFactoryImpl().createMapper();
    }

    @Override
    public SampleData parseSampleData(@Nonnull String json) {
        ObjectMapper objectMapper = this.objectMapperFactory.createMapper();
        try {
            return (SampleData)objectMapper.readValue(json, SampleData.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SampleData parseSampleData(@Nonnull String json, @Nonnull Map<String, Object> context) {
        return this.parseSampleData(this.templateRenderer.renderFragment(json, context));
    }

    @Override
    public void createSampleData(@Nonnull String json, Map<String, Object> context, @Nullable Callbacks callbacks, @Nullable AttachmentsProvider attachmentsProvider, @Nullable AvatarsProvider avatarsProvider, @Nonnull ErrorCollection errors) {
        this.createSampleData(json, context, callbacks, attachmentsProvider, avatarsProvider, ImporterOptions.defaults(), errors);
    }

    @Override
    public void createSampleData(@Nonnull SampleData sampleData, @Nullable Callbacks callbacks, @Nullable AttachmentsProvider attachmentsProvider, @Nullable AvatarsProvider avatarsProvider, @Nonnull ErrorCollection errors) {
        this.createSampleData(sampleData, callbacks, attachmentsProvider, avatarsProvider, ImporterOptions.defaults(), errors);
    }

    @Override
    public ImportDataBean createDataBean(@Nonnull SampleData sampleData, @Nullable Callbacks callbacks, @Nullable AttachmentsProvider attachmentsProvider, @Nullable AvatarsProvider avatarsProvider) {
        return new SampleDataBean(this.jiraAuthenticationContext, this.constantsManager, sampleData, attachmentsProvider, avatarsProvider, callbacks);
    }

    @Override
    public void createSampleData(@Nonnull String json, @Nonnull Map<String, Object> context, @Nullable Callbacks callbacks, @Nullable AttachmentsProvider attachmentsProvider, @Nullable AvatarsProvider avatarsProvider, @Nonnull ImporterOptions importerOptions, @Nonnull ErrorCollection errors) {
        SampleData sampleData = this.parseSampleData(json, context);
        this.createSampleData(sampleData, callbacks, attachmentsProvider, avatarsProvider, importerOptions, errors);
    }

    private void createSampleData(@Nonnull SampleData sampleData, @Nullable Callbacks callbacks, @Nullable AttachmentsProvider attachmentsProvider, @Nullable AvatarsProvider avatarsProvider, @Nonnull ImporterOptions options, @Nonnull ErrorCollection errors) {
        block3: {
            JiraDataImporter importer = this.jiraDataImporterFactory.create();
            importer.initializeLog();
            try {
                ImportDataBean dataBean = this.createDataBean(sampleData, callbacks, attachmentsProvider, avatarsProvider);
                importer.setDataBean(dataBean);
                new ImporterCallable(importer, new ImporterExecutionContext("sampleData", this.jiraAuthenticationContext.getUser(), options)).call();
                ImportStats importerStats = importer.getStats();
                if (importerStats != null && !importerStats.getFailures().isEmpty()) {
                    errors.addErrorMessages(importerStats.getFailures());
                }
            }
            catch (Exception e) {
                ImportLogger log = importer.getLog();
                if (log == null) break block3;
                log.fail(e, "Failed to start import", new Object[0]);
            }
        }
    }
}

