/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.rest;

import com.atlassian.jira.plugins.importer.extensions.ExternalSystemImporterModuleDescriptor;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportStats;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;

@Path(value="importer")
public class ImporterResource {
    public static final Logger logger = Logger.getLogger(ImporterResource.class);
    private final JiraAuthenticationContext authenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final PluginAccessor pluginAccessor;

    public ImporterResource(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport PluginAccessor pluginAccessor) {
        this.authenticationContext = authenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.pluginAccessor = pluginAccessor;
    }

    protected boolean canSeeResource(String externalSystem) {
        ApplicationUser currentUser = this.authenticationContext.getUser();
        return currentUser != null && (this.getModuleDescriptor(externalSystem).isNonAdmin() || this.globalPermissionManager.hasPermission(0, currentUser));
    }

    protected ExternalSystemImporterModuleDescriptor getModuleDescriptor(String externalSystem) {
        return (ExternalSystemImporterModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(externalSystem);
    }

    @GET
    @Path(value="/{externalSystem}/log")
    @Produces(value={"text/plain"})
    public Response downloadLog(@Context HttpServletRequest req, @PathParam(value="externalSystem") String externalSystem) {
        if (!this.canSeeResource(externalSystem)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        HttpSession session = req.getSession(false);
        ImporterController controller = this.getController(externalSystem);
        if (session == null || controller == null) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
        CacheControl cc = new CacheControl();
        cc.setNoCache(true);
        JiraDataImporter importer = controller.getImporter();
        if (importer == null || importer.getLog() == null) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
        return Response.ok((Object)importer.getLog().getImportLog()).cacheControl(cc).build();
    }

    @Nullable
    protected ImporterController getController(String externalSystem) {
        try {
            ExternalSystemImporterModuleDescriptor moduleDescriptor = (ExternalSystemImporterModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(externalSystem);
            return moduleDescriptor != null ? (ImporterController)moduleDescriptor.getModule() : null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @GET
    @Path(value="/{importer}/configuration")
    @Produces(value={"text/plain"})
    public Response downloadConfiguration(@Context HttpServletRequest req, @PathParam(value="importer") String importer) {
        if (!this.canSeeResource(importer)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        HttpSession session = req.getSession(false);
        if (session == null) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
        ImporterController controller = this.getController(importer);
        if (controller != null) {
            ImportProcessBean bean = controller.getImportProcessBean(req.getSession());
            String prefix = controller.getId();
            AbstractConfigBean configBean = null;
            if (bean != null) {
                configBean = bean.getConfigBean();
            }
            if (configBean != null) {
                try {
                    return Response.ok((Object)this.getConfigFileText(configBean)).header("Content-Disposition", (Object)String.format("attachment; filename=%s-configuration-%s.txt", prefix, DateTimeFormat.forPattern((String)"yyyyMMddHHmm").print((ReadableInstant)new DateTime()))).build();
                }
                catch (Exception e) {
                    logger.fatal((Object)"Failed to generate configuration", (Throwable)e);
                    return Response.serverError().build();
                }
            }
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    public String getConfigFileText(AbstractConfigBean configBean) throws IOException, ConfigurationException {
        HashMap configCopy = Maps.newHashMap();
        configBean.copyToNewProperties(configCopy);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        mapper.writeValue((OutputStream)out, (Object)configCopy);
        return out.toString("UTF-8");
    }

    @GET
    @Path(value="/{externalSystem}/status")
    @Produces(value={"application/json"})
    public Response status(@Context HttpServletRequest req, @PathParam(value="externalSystem") String externalSystem) {
        if (!this.canSeeResource(externalSystem)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        HttpSession session = req.getSession(false);
        ImporterController controller = this.getController(externalSystem);
        if (session == null || controller == null) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
        JiraDataImporter importer = controller.getImporter();
        ImportStats stats = importer.getStats();
        Response.ResponseBuilder responseBuilder = stats != null ? Response.ok((Object)stats) : Response.status((Response.Status)Response.Status.NOT_FOUND);
        CacheControl cc = new CacheControl();
        cc.setNoCache(true);
        return responseBuilder.cacheControl(cc).build();
    }

    @POST
    @Path(value="/{externalSystem}/abort")
    @RequiresXsrfCheck
    public Response abort(@Context HttpServletRequest req, @PathParam(value="externalSystem") String externalSystem) {
        if (!this.canSeeResource(externalSystem)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        HttpSession session = req.getSession(false);
        ImporterController controller = this.getController(externalSystem);
        if (session == null || controller == null) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
        CacheControl cc = new CacheControl();
        cc.setNoCache(true);
        JiraDataImporter importer = controller.getImporter();
        importer.abort(this.authenticationContext.getUser().getName());
        return Response.noContent().cacheControl(cc).build();
    }
}

