/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.plugins.importer.demo.DemoDataImportService;
import com.atlassian.jira.plugins.importer.exports.IssuesExporter;
import com.atlassian.jira.plugins.importer.exports.transform.ExportTransformerFactory;
import com.atlassian.jira.plugins.importer.rest.DemoDataResponse;
import com.atlassian.jira.plugins.importer.sample.SampleData;
import com.atlassian.jira.plugins.importer.sample.mapper.ObjectMapperFactory;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.atlassian.query.Query;
import com.google.common.base.Optional;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.codehaus.jackson.map.ObjectMapper;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/demo")
@Produces(value={"application/json"})
public class DemoDataResource {
    private static final Logger log = LoggerFactory.getLogger(DemoDataResource.class);
    public static final String DARK_FEATURE_DEMO_DATA = "jim.feature.demo.data.tools";
    private static final CacheControl NO_CACHE = new CacheControl();
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final JqlQueryParser jqlQueryParser;
    private final FeatureManager featureManager;
    private final IssuesExporter issuesExporter;
    private final ObjectMapperFactory objectMapperFactory;
    private final ExportTransformerFactory exportTransformerFactory;
    private final DemoDataImportService demoDataImportService;

    public DemoDataResource(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport PermissionManager permissionManager, @ComponentImport JqlQueryParser jqlQueryParser, @ComponentImport FeatureManager featureManager, IssuesExporter issuesExporter, ObjectMapperFactory objectMapperFactory, @Qualifier(value="demo-factory") ExportTransformerFactory exportTransformerFactory, DemoDataImportService demoDataImportService) {
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
        this.jqlQueryParser = jqlQueryParser;
        this.featureManager = featureManager;
        this.issuesExporter = issuesExporter;
        this.objectMapperFactory = objectMapperFactory;
        this.exportTransformerFactory = exportTransformerFactory;
        this.demoDataImportService = demoDataImportService;
    }

    @GET
    @Path(value="/export")
    public Response exportDemoData(@QueryParam(value="jql") String jql, @QueryParam(value="baseDate") String baseDate) {
        Either<ApplicationUser, Response> validatedUser = this.validatePreconditions(true);
        if (validatedUser.isRight()) {
            return (Response)validatedUser.right().get();
        }
        ApplicationUser user = (ApplicationUser)validatedUser.left().get();
        final Either<Response, SampleData> sampleData = this.exportIssues(jql, user);
        if (sampleData.isLeft()) {
            return (Response)sampleData.left().get();
        }
        Optional<DateTime> date = this.tryParse(baseDate);
        final ObjectMapper mapper = date.isPresent() ? this.objectMapperFactory.createRelativeTimeMapper((DateTime)date.get()) : this.objectMapperFactory.createMapper();
        return Response.ok((Object)new StreamingOutput(){

            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                mapper.writer().writeValue(outputStream, sampleData.right().get());
            }
        }).build();
    }

    @PUT
    @Path(value="/create")
    public Response createDemo(@QueryParam(value="key") String projectKey, @QueryParam(value="name") String projectName, @QueryParam(value="lead") String projectLead, InputStream json) throws IOException {
        Either<ApplicationUser, Response> validateUser = this.validatePreconditions(true);
        if (validateUser.isRight()) {
            return (Response)validateUser.right().get();
        }
        ServiceOutcome<DemoDataResponse> importResult = this.demoDataImportService.createDemoDataProject(projectKey, projectName, projectLead, json);
        if (importResult.isValid()) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)importResult.getErrorCollection().getErrorMessages()).build();
    }

    @POST
    @Path(value="/create")
    @RequiresXsrfCheck
    public Response createDemo(@FormParam(value="key") String projectKey, @FormParam(value="name") String projectName, @FormParam(value="lead") String projectLead, @FormParam(value="projectTemplateWebItemKey") String demoDataKey) {
        Either<ApplicationUser, Response> validateUser = this.validatePreconditions(false);
        if (validateUser.isRight()) {
            return (Response)validateUser.right().get();
        }
        ServiceOutcome<DemoDataResponse> demoDataProject = this.demoDataImportService.createDemoDataProject(projectKey, projectName, projectLead, demoDataKey);
        if (demoDataProject.isValid()) {
            return Response.ok((Object)demoDataProject.get()).cacheControl(NO_CACHE).build();
        }
        ErrorCollection errors = ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)demoDataProject.getErrorCollection());
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(NO_CACHE).entity((Object)errors).build();
    }

    private Optional<DateTime> tryParse(String baseDate) {
        try {
            return Optional.of((Object)DateTime.parse((String)baseDate));
        }
        catch (IllegalArgumentException e) {
            log.debug("Failed while parsing DateTime", (Throwable)e);
            return Optional.absent();
        }
    }

    private Either<Response, SampleData> exportIssues(String jql, ApplicationUser user) {
        try {
            Query query = this.jqlQueryParser.parseQuery(jql);
            SearchRequest searchRequest = new SearchRequest(query, user, "Export Data Query", "Query for extraction of Demo Data");
            Optional<SampleData> sampleData = this.issuesExporter.exportIssues(searchRequest, this.exportTransformerFactory);
            if (sampleData.isPresent()) {
                return Either.right((Object)sampleData.get());
            }
        }
        catch (JqlParseException e) {
            log.warn("Cannot extract demo data", (Throwable)e);
        }
        return Either.left((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
    }

    private Either<ApplicationUser, Response> validatePreconditions(boolean checkDarkFeature) {
        ApplicationUser currentUser = this.authenticationContext.getUser();
        if (!this.permissionManager.hasPermission(0, currentUser) || checkDarkFeature && !this.featureManager.isEnabled(DARK_FEATURE_DEMO_DATA)) {
            return Either.right((Object)Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(NO_CACHE).entity((Object)"").build());
        }
        return Either.left((Object)currentUser);
    }

    static {
        NO_CACHE.setNoStore(true);
        NO_CACHE.setNoCache(true);
    }
}

