/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.rest;

import com.atlassian.core.util.FileSize;
import com.atlassian.jira.issue.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.plugins.importer.AttachmentHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.io.IOUtils;

@Path(value="AttachTemporaryFile")
@Produces(value={"application/json"})
public class AttachTemporaryFile {
    public static final int READ_BUFFER_SIZE = 524288;
    private final TemporaryAttachmentsMonitorLocator locator;
    private final XsrfInvocationChecker xsrfChecker;
    private final JiraAuthenticationContext authContext;
    private final AttachmentHelper attachmentHelper;
    private final XsrfTokenGenerator xsrfGenerator;

    public AttachTemporaryFile(@ComponentImport TemporaryAttachmentsMonitorLocator locator, @ComponentImport XsrfInvocationChecker xsrfChecker, @ComponentImport JiraAuthenticationContext authContext, @ComponentImport XsrfTokenGenerator xsrfGenerator, AttachmentHelper attachmentHelper) {
        this.locator = locator;
        this.xsrfChecker = xsrfChecker;
        this.authContext = authContext;
        this.xsrfGenerator = xsrfGenerator;
        this.attachmentHelper = attachmentHelper;
    }

    @POST
    @Consumes(value={"*/*"})
    public Response addTemporaryAttachment(@QueryParam(value="filename") String filename, @QueryParam(value="size") Long size, @Context HttpServletRequest request) {
        AttachmentHelper.Result validTemporaryAttachmentDirectory = this.attachmentHelper.isValidTemporaryAttachmentDirectory();
        if (validTemporaryAttachmentDirectory != AttachmentHelper.OK) {
            return this.createError(Response.Status.INTERNAL_SERVER_ERROR, validTemporaryAttachmentDirectory == null ? null : validTemporaryAttachmentDirectory.message);
        }
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(request);
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            return this.createErrorWithToken(Response.Status.INTERNAL_SERVER_ERROR, this.authContext.getI18nHelper().getText("attachfile.xsrf.try.again"), this.xsrfGenerator.generateToken(request));
        }
        if (size <= 0L) {
            return this.createError(Response.Status.BAD_REQUEST, this.authContext.getI18nHelper().getText("attachfile.error.io.size", filename));
        }
        if (size > this.attachmentHelper.getMaxAttachmentSize()) {
            return this.createError(Response.Status.BAD_REQUEST, this.authContext.getI18nHelper().getText("upload.too.big", filename, FileSize.format((Long)size), FileSize.format((Long)this.attachmentHelper.getMaxAttachmentSize())));
        }
        AttachmentHelper.UniqueFile uniqueFile = this.attachmentHelper.getTemporaryUniqueFile(filename);
        try {
            this.attachmentHelper.copyFile(size, uniqueFile.getFile(), (InputStream)request.getInputStream());
        }
        catch (IOException e) {
            return this.createError(Response.Status.BAD_REQUEST, e.getMessage());
        }
        TemporaryAttachment temporaryAttachment = new TemporaryAttachment(Long.valueOf(uniqueFile.getId()), Long.valueOf(-1L), uniqueFile.getFile(), filename, request.getContentType());
        this.locator.get(true).add(temporaryAttachment);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)new GoodResult(uniqueFile.getId(), filename)).cacheControl(this.never()).build();
    }

    private Response createErrorWithToken(Response.Status status, String message, String token) {
        return Response.status((int)status.getStatusCode()).cacheControl(this.never()).entity((Object)new BadResult(message, token)).build();
    }

    private Response createError(Response.Status status, String message) {
        return this.createErrorWithToken(status, message, null);
    }

    private CacheControl never() {
        CacheControl cacheNever = new CacheControl();
        cacheNever.setNoStore(true);
        cacheNever.setNoCache(true);
        return cacheNever;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="isAsciiOnly")
    @Consumes(value={"*/*"})
    public Response isFileAsciiOnly(@QueryParam(value="attachmentId") Long attachmentId) {
        if (attachmentId == null) {
            return this.createError(Response.Status.BAD_REQUEST, this.authContext.getI18nHelper().getText("jira-importer-plugin.csv.rest.file.invalid.attachment.id"));
        }
        attachment = this.locator.get(true).getById(attachmentId);
        attachmentFile = attachment.getFile();
        in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(attachmentFile), 524288);
            while ((c = in.read()) != -1) {
                if (c <= 127) continue;
                var6_7 = Response.status((Response.Status)Response.Status.OK).entity((Object)Boolean.FALSE).cacheControl(this.never()).build();
                ** GOTO lbl20
            }
            ** GOTO lbl22
        }
        catch (Exception e) {
            try {
                var6_8 = this.createError(Response.Status.BAD_REQUEST, e.getMessage());
            }
            catch (Throwable var7_9) {
                IOUtils.closeQuietly(in);
                throw var7_9;
            }
lbl20:
            // 1 sources

            IOUtils.closeQuietly((InputStream)in);
            return var6_7;
lbl22:
            // 1 sources

            IOUtils.closeQuietly((InputStream)in);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)Boolean.TRUE).cacheControl(this.never()).build();
            IOUtils.closeQuietly((InputStream)in);
            return var6_8;
        }
    }

    @XmlRootElement
    public static class BadResult {
        @XmlElement
        private String errorMessage;
        @XmlElement
        private String token;

        private BadResult() {
        }

        BadResult(String msg) {
            this(msg, null);
        }

        BadResult(String msg, String token) {
            this.errorMessage = msg;
            this.token = token;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BadResult badResult = (BadResult)o;
            if (this.errorMessage != null ? !this.errorMessage.equals(badResult.errorMessage) : badResult.errorMessage != null) {
                return false;
            }
            return !(this.token != null ? !this.token.equals(badResult.token) : badResult.token != null);
        }

        public String toString() {
            return "BadResult{errorMessage='" + this.errorMessage + '\'' + ", token='" + this.token + '\'' + '}';
        }

        public int hashCode() {
            int result = this.errorMessage != null ? this.errorMessage.hashCode() : 0;
            result = 31 * result + (this.token != null ? this.token.hashCode() : 0);
            return result;
        }
    }

    @XmlRootElement
    public static class GoodResult {
        @XmlElement
        private String name;
        @XmlElement
        private String id;

        private GoodResult() {
        }

        GoodResult(long id, String name) {
            this.id = String.valueOf(id);
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GoodResult that = (GoodResult)o;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "GoodResult{name='" + this.name + '\'' + ", id='" + this.id + '\'' + '}';
        }
    }
}

