/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.managers;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.external.ExternalException;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.managers.CreateProjectManager;
import com.atlassian.jira.plugins.importer.web.TextsUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class CreateProjectManagerImpl
implements CreateProjectManager {
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final ProjectService projectService;
    private final CompatibilityBridgeUtils bridgeUtils;
    private final GlobalPermissionManager permissionManager;

    @Autowired
    public CreateProjectManagerImpl(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport ProjectService projectService, @ComponentImport WorkflowSchemeManager workflowSchemeManager, @ComponentImport GlobalPermissionManager globalPermissionManager, CompatibilityBridgeUtils bridgeUtils) {
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.workflowSchemeManager = workflowSchemeManager;
        this.projectService = projectService;
        this.bridgeUtils = bridgeUtils;
        this.permissionManager = globalPermissionManager;
    }

    @Override
    public Project createProject(ApplicationUser loggedInUser, ExternalProject externalProject, ImportLogger log) throws ExternalException {
        if (!this.canCreateProjects(loggedInUser)) {
            throw new ExternalException(String.format("User %s is not allowed to create projects.", loggedInUser.getName()));
        }
        try {
            ProjectService.CreateProjectValidationResult validationResult;
            if (externalProject.getLead() == null) {
                externalProject.setLead(this.authenticationContext.getUser().getName());
            }
            if (externalProject.getAssigneeType() == null) {
                if (this.isUnassignedIssuesAllowed()) {
                    externalProject.setAssigneeType(3L);
                } else {
                    externalProject.setAssigneeType(2L);
                }
            }
            if (!(validationResult = this.bridgeUtils.validateCreateProject(loggedInUser, externalProject.getName(), externalProject.getKey(), externalProject.getDescription(), externalProject.getLead(), externalProject.getUrl(), externalProject.getAssigneeType(), externalProject.getType(), externalProject.getTemplate())).isValid()) {
                String msg = TextsUtil.buildErrorMessage(validationResult.getErrorCollection());
                throw new CreateException(msg);
            }
            Project project = this.projectService.createProject(validationResult);
            if (externalProject.getWorkflowSchemeName() != null) {
                Scheme scheme = this.workflowSchemeManager.getSchemeObject(externalProject.getWorkflowSchemeName());
                this.workflowSchemeManager.removeSchemesFromProject(project);
                this.workflowSchemeManager.addSchemeToProject(project, scheme);
            }
            return project;
        }
        catch (Exception e) {
            throw new ExternalException("Unable to create project: " + externalProject, e);
        }
    }

    @Override
    public boolean canCreateProjects(ApplicationUser user) {
        return this.permissionManager.hasPermission(0, user);
    }

    private boolean isUnassignedIssuesAllowed() {
        return this.applicationProperties.getOption("jira.option.allowunassigned");
    }
}

