/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.managers;

import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.plugins.importer.external.ExternalException;
import com.atlassian.jira.plugins.importer.managers.CreateConstantsManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Maps;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateConstanstManagerImpl
implements CreateConstantsManager {
    private static final Long NEW_STATUS_START_ID = 10000L;
    private final ConstantsManager constantsManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IssueTypeManager issueTypeManager;
    private final PriorityManager priorityManager;

    @Autowired
    public CreateConstanstManagerImpl(@ComponentImport ConstantsManager constantsManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport IssueTypeManager issueTypeManager, @ComponentImport PriorityManager priorityManager) {
        this.constantsManager = constantsManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.issueTypeManager = issueTypeManager;
        this.priorityManager = priorityManager;
    }

    @Override
    @Nullable
    public IssueConstant getConstant(String constantIdOrName, String constantType) {
        IssueConstant constantById = this.constantsManager.getConstantObject(constantType, constantIdOrName);
        if (constantById != null) {
            return constantById;
        }
        Collection constants = this.constantsManager.getConstantObjects(constantType);
        if (constants != null) {
            for (IssueConstant constant : constants) {
                if (!constant.getName().equalsIgnoreCase(constantIdOrName)) continue;
                return constant;
            }
        }
        return null;
    }

    @Override
    public String addConstant(String constantName, String constantType) throws ExternalException {
        HashMap params = Maps.newHashMap();
        if (ConstantsManager.ISSUE_TYPE_CONSTANT_TYPE.equals(constantType)) {
            return this.addNewIssueType(constantName);
        }
        if (ConstantsManager.PRIORITY_CONSTANT_TYPE.equals(constantType)) {
            params.put("iconurl", "/images/icons/priority_major.gif");
            params.put("statusColor", "#009900");
        } else if (!ConstantsManager.RESOLUTION_CONSTANT_TYPE.equals(constantType)) {
            throw new ExternalException("Unknown contantType:" + constantType);
        }
        return this.addConstant(constantName, constantType, params);
    }

    private String addNewIssueType(String issueTypeName) {
        IssueType issueType = this.issueTypeManager.createIssueType(issueTypeName, "", "/images/icons/issuetypes/genericissue.png");
        return issueType.getId();
    }

    protected String addConstant(String constantName, String constantType, @Nullable Map<String, Object> extraParams) throws ExternalException {
        this.throwExceptionIfInvalid(constantName, constantType);
        if (ConstantsManager.CONSTANT_TYPE.PRIORITY.getType().equals(constantType)) {
            Priority priority = this.priorityManager.createPriority(constantName, "Created by JIM during import process", (String)extraParams.get("iconurl"), (String)extraParams.get("statusColor"));
            return priority.getId();
        }
        try {
            HashMap parameters = Maps.newHashMap(extraParams);
            parameters.put("name", constantName);
            parameters.put("description", constantName);
            if (TextUtils.stringSet((String)constantType)) {
                if (constantType.equals("Status") && Long.valueOf(EntityUtils.getNextStringId((String)constantType)) < NEW_STATUS_START_ID) {
                    parameters.put("id", NEW_STATUS_START_ID.toString());
                } else {
                    parameters.put("id", EntityUtils.getNextStringId((String)constantType));
                }
            } else {
                throw new IllegalArgumentException("Unable to create an entity without a valid name.");
            }
            parameters.put("sequence", this.getMaxSequenceNo(constantType) + 1L);
            GenericValue created = EntityUtils.createValue((String)constantType, (Map)parameters);
            this.clearCaches(constantType);
            return created.getString("id");
        }
        catch (Exception e) {
            throw new ExternalException("Unable to create " + constantType + " " + constantName, e);
        }
    }

    protected void throwExceptionIfInvalid(String name, String constantType) throws ExternalException {
        if (!TextUtils.stringSet((String)name)) {
            throw new ExternalException(this.jiraAuthenticationContext.getI18nHelper().getText("admin.errors.must.specify.a.name.for.the.to.be.added", constantType));
        }
        if (this.getConstant(name, constantType) != null) {
            throw new ExternalException(this.jiraAuthenticationContext.getI18nHelper().getText("admin.errors.constant.already.exists", constantType));
        }
    }

    protected void clearCaches(String constantType) {
        if (ConstantsManager.ISSUE_TYPE_CONSTANT_TYPE.equals(constantType)) {
            this.getConstantsManager().refreshIssueTypes();
        } else if (ConstantsManager.RESOLUTION_CONSTANT_TYPE.equals(constantType)) {
            this.getConstantsManager().refreshResolutions();
        } else if (ConstantsManager.PRIORITY_CONSTANT_TYPE.equals(constantType)) {
            this.getConstantsManager().refreshPriorities();
        } else if (ConstantsManager.STATUS_CONSTANT_TYPE.equals(constantType)) {
            this.getConstantsManager().refreshStatuses();
        }
    }

    public ConstantsManager getConstantsManager() {
        return this.constantsManager;
    }

    private long getMaxSequenceNo(String constantType) {
        Collection constants = this.constantsManager.getConstantObjects(constantType);
        if (constants != null) {
            long maxSequence = 0L;
            for (IssueConstant constant : constants) {
                long thisSequence;
                Long sequence = constant.getSequence();
                if (sequence == null || (thisSequence = sequence.longValue()) <= maxSequence) continue;
                maxSequence = thisSequence;
            }
            return maxSequence;
        }
        return 0L;
    }
}

