/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.trac.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.AbstractResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.trac.TracConfigBean;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;

public class VersionTransformer
extends AbstractResultSetTransformer<ExternalVersion> {
    private final TracConfigBean configBean;

    public VersionTransformer(TracConfigBean configBean, ImportLogger importLogger) {
        super(importLogger);
        this.configBean = configBean;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT name,time,description FROM version WHERE name IS NOT NULL AND name != ''";
    }

    @Override
    @Nullable
    public ExternalVersion transform(ResultSet rs) throws SQLException {
        ExternalVersion version = new ExternalVersion(rs.getString("name"));
        version.setDescription(rs.getString("description"));
        version.setReleaseDate(this.configBean.getTimestamp(rs, "time"));
        return version;
    }
}

