/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.trac.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.trac.TracConfigBean;
import com.atlassian.jira.plugins.importer.imports.trac.TracWikiConverter;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class CommentTransformer
implements ResultSetTransformer<ExternalComment> {
    private final String ixBug;
    private final TracConfigBean configBean;
    private final TracWikiConverter wikiConverter;
    private final ImportLogger log;

    public CommentTransformer(String ixBug, TracConfigBean configBean, TracWikiConverter wikiConverter, ImportLogger log) {
        this.ixBug = ixBug;
        this.configBean = configBean;
        this.wikiConverter = wikiConverter;
        this.log = log;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT time,author,newvalue FROM ticket_change WHERE ticket = " + this.ixBug + " AND field='comment' ORDER BY time ASC";
    }

    @Override
    @Nullable
    public ExternalComment transform(ResultSet rs) throws SQLException {
        String commenter = this.configBean.getUsernameForEmail(rs.getString("author"));
        String comment = rs.getString("newvalue");
        if (StringUtils.isNotBlank((String)comment)) {
            return new ExternalComment(this.wikiConverter.convert(comment, this.log), commenter, this.configBean.getTimestamp(rs, "time"));
        }
        return null;
    }
}

