/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.trac.transformer;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.plugins.importer.FileCopyUtil;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.imports.AbstractAttachmentTransformer;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.trac.TracConfigBean;
import com.atlassian.jira.web.util.FileNameCharacterCheckerUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.BitSet;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class AttachmentTransformer
extends AbstractAttachmentTransformer {
    private final TracConfigBean configBean;
    private final ImportLogger log;
    protected final String ixBug;
    protected static final BitSet mark = new BitSet(256);
    protected static final BitSet allowed;

    public AttachmentTransformer(TracConfigBean configBean, String ixBug, ImportLogger log) {
        this.ixBug = ixBug;
        this.configBean = configBean;
        this.log = log;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT id,filename,time,description,author FROM attachment WHERE id='" + this.ixBug + "' AND type='ticket' ORDER BY time ASC";
    }

    @Override
    public ExternalAttachment transform(ResultSet rs) throws SQLException {
        ExternalAttachment externalAttachment = null;
        String fileName = rs.getString("filename");
        if (StringUtils.isNotBlank((String)fileName)) {
            try {
                File file = this.copyAttachment(rs);
                fileName = new FileNameCharacterCheckerUtil().replaceInvalidChars(fileName, '_');
                externalAttachment = new ExternalAttachment(fileName, file, this.configBean.getTimestamp(rs, "time"));
                externalAttachment.setAttacher(this.configBean.getUsernameForEmail(rs.getString("author")));
                externalAttachment.setDescription(rs.getString("description"));
            }
            catch (DataAccessException e) {
                this.log.fail(e, "Failed to get attachment", new Object[0]);
                return null;
            }
        }
        return externalAttachment;
    }

    @VisibleForTesting
    ZipArchiveEntry getZipEntry(ZipFile zip, String id, String filename) throws URIException {
        ZipArchiveEntry result = null;
        String entryName = String.format("attachments/ticket/%s/%s", id, this.encodeFilename(filename));
        result = zip.getEntry(entryName);
        if (result == null) {
            String fileExtension = FilenameUtils.getExtension((String)filename);
            String fileExtensionWithDot = Strings.isNullOrEmpty((String)fileExtension) ? fileExtension : '.' + fileExtension;
            String idHash = DigestUtils.shaHex((String)id);
            String filenameHash = DigestUtils.shaHex((String)filename);
            String newVersionEntryName = String.format("files/attachments/ticket/%s/%s/%s%s", idHash.substring(0, 3), idHash, filenameHash, fileExtensionWithDot);
            result = zip.getEntry(newVersionEntryName);
            if (result == null) {
                throw new DataAccessException("Attachment doesn't exist either: '" + entryName + "' or '" + newVersionEntryName + "'");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File copyAttachment(ResultSet rs) throws SQLException {
        File file;
        ZipFile zip = new ZipFile(this.configBean.getEnvironmentZip());
        try {
            String id = rs.getString("id");
            String filename = rs.getString("filename");
            ZipArchiveEntry zipEntry = this.getZipEntry(zip, id, filename);
            File file2 = this.getTempFile();
            InputStream contentStream = zip.getInputStream(zipEntry);
            FileCopyUtil.copy(contentStream, file2);
            file = file2;
        }
        catch (Throwable throwable) {
            try {
                zip.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new DataAccessException("Exception occurred dealing with attachment.", (Throwable)e);
            }
        }
        zip.close();
        return file;
    }

    protected String encodeFilename(String filename) throws URIException {
        return URIUtil.encode((String)filename, (BitSet)allowed, (String)"UTF-8");
    }

    static {
        mark.set(33);
        mark.set(126);
        mark.set(42);
        mark.set(39);
        mark.set(40);
        mark.set(41);
        mark.set(37);
        mark.set(43);
        mark.set(44);
        mark.set(36);
        allowed = new BitSet(256);
        allowed.or(URI.allowed_within_path);
        allowed.andNot(mark);
    }
}

