/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.trac;

import com.atlassian.jira.plugins.importer.FileCopyUtil;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.trac.ConverterEngine;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.uwc.ui.UWCUserSettings;
import com.atlassian.uwc.ui.listeners.FeedbackHandler;
import com.atlassian.uwc.util.PropertyFileManager;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.springframework.stereotype.Component;

@Component
public class TracWikiConverter {
    private LazyReference<List<String>> converterStrings = new LazyReference<List<String>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> create() throws Exception {
            File config = File.createTempFile("uwc-", ".properties");
            try {
                FileCopyUtil.copy(((Object)((Object)this)).getClass().getResourceAsStream("/converter.trac.properties"), config);
                TreeMap converters = PropertyFileManager.loadPropertiesFile((String)config.toString());
                if (converters == null) {
                    throw new IllegalArgumentException();
                }
                ArrayList result = Lists.newArrayListWithCapacity((int)converters.keySet().size());
                for (Map.Entry converter : converters.entrySet()) {
                    result.add((String)converter.getKey() + "=" + (String)converter.getValue());
                }
                ArrayList arrayList = result;
                return arrayList;
            }
            finally {
                FileUtils.deleteQuietly((File)config);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public String convert(String wiki, ImportLogger log) {
        try {
            File inputDir = TracWikiConverter.createTempDirectory();
            try {
                File tempComment;
                File outputDir;
                block10: {
                    String string;
                    outputDir = TracWikiConverter.createTempDirectory();
                    try {
                        UWCUserSettings settings = new UWCUserSettings();
                        settings.setWikitype("trac");
                        ConverterEngine engine = new ConverterEngine();
                        engine.getState(settings);
                        tempComment = File.createTempFile("comment-", ".txt", inputDir);
                        FileUtils.writeStringToFile((File)tempComment, (String)wiki);
                        engine.convert(outputDir, Lists.newArrayList((Object[])new File[]{tempComment}), (List)this.converterStrings.get(), settings);
                        if (engine.getConverterFeedback() == FeedbackHandler.Feedback.OK) break block10;
                        log.fail(null, "Failed to convert Wiki markup: %s", engine.getErrors().getAllErrorMessages());
                        string = wiki;
                    }
                    catch (Throwable throwable) {
                        FileUtils.deleteDirectory((File)outputDir);
                        throw throwable;
                    }
                    FileUtils.deleteDirectory((File)outputDir);
                    return string;
                }
                String string = FileUtils.readFileToString((File)new File(outputDir, tempComment.getName()));
                FileUtils.deleteDirectory((File)outputDir);
                return string;
            }
            finally {
                FileUtils.deleteDirectory((File)inputDir);
            }
        }
        catch (Exception e) {
            log.fail(e, "Failed to convert Wiki markup", new Object[0]);
            return wiki;
        }
    }

    public static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }
}

