/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.trac;

import com.atlassian.jira.plugins.importer.FileCopyUtil;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDatabaseConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.imports.trac.TracConfigBean;
import com.atlassian.jira.plugins.importer.imports.trac.TracDataBean;
import com.atlassian.jira.plugins.importer.imports.trac.TracWikiConverter;
import com.atlassian.jira.plugins.importer.imports.trac.web.TracSetupPage;
import com.atlassian.jira.plugins.importer.web.AbstractImporterController;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ConfigFileHandler;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TracImporterController
extends AbstractImporterController {
    private static final Logger log = Logger.getLogger(TracImporterController.class);
    private final TracWikiConverter wikiConverter;
    private final ConfigFileHandler configFileHandler;

    public TracImporterController(JiraDataImporter importer, TracWikiConverter wikiConverter, ConfigFileHandler configFileHandler) {
        super(importer, "issue.importer.jira.trac.import.bean", "Trac");
        this.wikiConverter = wikiConverter;
        this.configFileHandler = configFileHandler;
    }

    @Override
    public boolean createImportProcessBean(AbstractSetupPage setupPage) {
        ImportProcessBean bean = new ImportProcessBean();
        try {
            TracSetupPage tracSetupPage = (TracSetupPage)setupPage;
            File environmentZip = tracSetupPage.getTempAttachment().getFile();
            JdbcConnection jdbcConnection = this.createDatabaseConnectionBean(environmentZip);
            AbstractDatabaseConfigBean configBean = this.createConfigBean(environmentZip, jdbcConnection);
            if (!this.configFileHandler.populateFromConfigFile(setupPage, configBean)) {
                return false;
            }
            bean.setJdbcConnection(jdbcConnection);
            bean.setConfigBean(configBean);
        }
        catch (Exception e) {
            log.error((Object)"Unable to setup Trac importer", (Throwable)e);
            setupPage.addErrorMessage(e.getMessage());
            return false;
        }
        this.storeImportProcessBeanInSession(bean);
        return true;
    }

    @Override
    public ImportDataBean createDataBean() throws Exception {
        ImportProcessBean importProcessBean = this.getImportProcessBeanFromSession();
        return new TracDataBean((TracConfigBean)importProcessBean.getConfigBean(), this.wikiConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getEnvironmentConfiguration(ZipFile zip) throws IOException, ConfigurationException {
        ZipArchiveEntry ze = zip.getEntry("conf/trac.ini");
        InputStream is = zip.getInputStream(ze);
        if (is == null) {
            throw new FileNotFoundException("No conf/trac.ini found in ZIP file");
        }
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(){

                protected List split(String token) {
                    return Collections.singletonList(token);
                }
            };
            config.load(is);
            PropertiesConfiguration propertiesConfiguration = config;
            return propertiesConfiguration;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    protected JdbcConnection createConnectionBean(String driver, String url) throws URISyntaxException, URIException {
        URI uri = new URI(url, true);
        String dbUrl = uri.getScheme() + "://" + uri.getHost() + (uri.getPort() != -1 ? ":" + uri.getPort() : "") + uri.getPathQuery();
        String userInfo = uri.getUserinfo();
        String username = StringUtils.substringBefore((String)userInfo, (String)":");
        String password = StringUtils.substringAfter((String)userInfo, (String)":");
        return new JdbcConnection(driver, "jdbc:" + dbUrl, username, password);
    }

    public JdbcConnection createDatabaseConnectionBean(File environmentZip) throws IOException, ConfigurationException, URISyntaxException {
        try (ZipFile zip = new ZipFile(environmentZip);){
            Configuration config = TracImporterController.getEnvironmentConfiguration(zip);
            String database = StringUtils.defaultString((String)config.getString("database"), (String)"");
            if (database.startsWith("sqlite:")) {
                InputStream sqliteStream;
                String sqlitePath = StringUtils.removeStart((String)database, (String)"sqlite:");
                ZipArchiveEntry sqliteZipEntry = zip.getEntry(sqlitePath);
                if (sqliteZipEntry == null || (sqliteStream = zip.getInputStream(sqliteZipEntry)) == null) {
                    throw new UnsupportedOperationException(String.format("Cannot read your SQLite database from %s, file doesn't exist in ZIP.", sqlitePath));
                }
                File tempDb = File.createTempFile("trac-importer-controller-", ".sqlite");
                FileCopyUtil.copy(sqliteStream, tempDb);
                JdbcConnection jdbcConnection = new JdbcConnection("org.sqlite.JDBC", "jdbc:sqlite:" + tempDb.getPath(), null, null);
                return jdbcConnection;
            }
            if (database.startsWith("postgres:")) {
                if (database.contains("@/")) {
                    throw new UnsupportedOperationException("It's not possible to import Trac configured to use PostgreSQL via socket. Please change your trac.ini to use PostgreSQL TCP/IP connection.");
                }
                JdbcConnection jdbcConnection = this.createConnectionBean("org.postgresql.Driver", database.replace("postgres://", "postgresql://"));
                return jdbcConnection;
            }
            if (database.startsWith("mysql:")) {
                JdbcConnection jdbcConnection = this.createConnectionBean("com.mysql.jdbc.Driver", database);
                return jdbcConnection;
            }
            if (StringUtils.isEmpty((String)database)) {
                throw new UnsupportedOperationException("You database configuration stored in trac.ini is empty.");
            }
            throw new UnsupportedOperationException("You database configuration stored in trac.ini is not supported. Contact JIM developers for support.");
        }
    }

    public AbstractDatabaseConfigBean createConfigBean(File environmentZip, JdbcConnection jdbcConnection) throws IOException, ConfigurationException {
        return new TracConfigBean(jdbcConnection, environmentZip);
    }

    @Override
    public List<String> getSteps() {
        return Lists.newArrayList((Object[])new String[]{"TracSetupPage", "ImporterProjectMappingsPage", "ImporterCustomFieldsPage", "ImporterFieldMappingsPage", "ImporterValueMappingsPage"});
    }

    @Override
    public List<String> getStepNameKeys() {
        return Lists.newArrayList((Object[])new String[]{"jira-importer-plugin.wizard.step.TracSetupPage", "jira-importer-plugin.wizard.step.ImporterProjectMappingsPage", "jira-importer-plugin.wizard.step.ImporterCustomFieldsPage", "jira-importer-plugin.wizard.step.ImporterFieldMappingsPage", "jira-importer-plugin.wizard.step.ImporterValueMappingsPage"});
    }
}

