/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.trac;

import com.atlassian.uwc.converters.Converter;
import com.atlassian.uwc.converters.JavaRegexConverter;
import com.atlassian.uwc.converters.PerlConverter;
import com.atlassian.uwc.converters.twiki.JavaRegexAndTokenizerConverter;
import com.atlassian.uwc.converters.twiki.TWikiRegexConverterCleanerWrapper;
import com.atlassian.uwc.converters.xml.DefaultXmlEvents;
import com.atlassian.uwc.converters.xml.XmlEvents;
import com.atlassian.uwc.filters.FilterChain;
import com.atlassian.uwc.hierarchies.HierarchyBuilder;
import com.atlassian.uwc.splitters.PageSplitter;
import com.atlassian.uwc.ui.ConfluenceSettingsForm;
import com.atlassian.uwc.ui.ConverterErrors;
import com.atlassian.uwc.ui.FileUtils;
import com.atlassian.uwc.ui.Page;
import com.atlassian.uwc.ui.State;
import com.atlassian.uwc.ui.UWCForm2;
import com.atlassian.uwc.ui.UWCUserSettings;
import com.atlassian.uwc.ui.listeners.FeedbackHandler;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class ConverterEngine
implements FeedbackHandler {
    private static final int NUM_REQ_CONVERTERS = 2;
    private static final String NONCONVERTERTYPE_PAGEHISTORYPRESERVATION = "page-history-preservation";
    private static final String NONCONVERTERTYPE_HIERARCHYBUILDER = ".hierarchy-builder";
    private static final String NONCONVERTERTYPE_ILLEGALHANDLING = "illegal-handling";
    private static final String NONCONVERTERTYPE_AUTODETECTSPACEKEYS = "autodetect-spacekeys";
    private static final String NONCONVERTERTYPE_MISCPROPERTIES = ".property";
    private static final String NONCONVERTERTYPE_FILTERS = ".filter";
    private static final String NONCONVERTERTYPE_XMLEVENT = ".xmlevent";
    private static final String CONVERTERTYPE_TWIKICLEANER = ".twiki-cleaner";
    private static final String CONVERTERTYPE_JAVAREGEX = ".java-regex";
    private static final String CONVERTERTYPE_JAVAREGEXTOKEN = ".java-regex-tokenize";
    private static final String CONVERTERTYPE_PERL = ".perl";
    private static final String CONVERTERTYPE_CLASS = ".class";
    private static final String XMLEVENT_PROP_ERROR = "Xmlevent Property must follow this format convention: {tag}xmltag{class}com.something.Class";
    private static final int DEFAULT_NUM_STEPS = 1000;
    public boolean running = false;
    private boolean illegalHandlingEnabled = true;
    Logger log = Logger.getLogger(this.getClass());
    public static final String CONFLUENCE_SEPARATOR = " -- ";
    private HierarchyHandler hierarchyHandler = HierarchyHandler.DEFAULT;
    private HierarchyBuilder hierarchyBuilder = null;
    private UWCUserSettings settings;
    private State state;
    private Properties miscProperties = new Properties();
    private Set<String> filterValues;
    private FeedbackHandler.Feedback feedback;
    HashMap<String, Converter> converterCacheMap = new HashMap();
    private long startTotalConvertTime;
    private ConverterErrors errors = new ConverterErrors();
    private boolean hadConverterErrors;
    Pattern switchPattern = Pattern.compile("switch");
    Pattern suffixPattern = Pattern.compile("suffix");
    private boolean handlingPageHistories = false;
    private String pageHistorySuffix = null;
    Pattern miscPropsPattern = Pattern.compile("\\w+\\.\\d+\\.([^.]+)\\.property");
    Pattern xmleventClassPattern = Pattern.compile("\\{class\\}(.*)");
    Pattern xmleventTagPattern = Pattern.compile("\\{tag\\}([^}]+)\\{class\\}");
    Pattern hashPattern = Pattern.compile("#+");

    public void convert(File outputDir, List<File> inputPages, List<String> converterStrings, UWCUserSettings settings) {
        this.running = true;
        this.resetFeedback();
        this.resetErrorHandlers();
        this.resetHierarchy();
        this.settings = settings;
        if (!this.running) {
            this.feedback = FeedbackHandler.Feedback.CANCELLED;
            return;
        }
        this.convert(outputDir, inputPages, converterStrings);
        if (this.feedback == FeedbackHandler.Feedback.NONE) {
            this.feedback = FeedbackHandler.Feedback.OK;
        }
        this.running = false;
    }

    public State getState(UWCUserSettings settings) {
        int steps = 1000;
        String initialMessage = "Converting Wiki\nWikitype = " + settings.getWikitype() + "\n";
        this.state = new State(initialMessage, 0, steps);
        return this.state;
    }

    private int getNumberOfSteps(int files, int pages, int properties, int converters) {
        int numReqConverters = this.isIllegalHandlingEnabled() ? 2 : 0;
        int steps = properties + files + converters * pages + numReqConverters + numReqConverters * pages + pages;
        return steps;
    }

    public void convert(File outputDir, List<File> pages, List<String> converterStrings) {
        this.log.info((Object)"Starting conversion.");
        this.initConversion();
        List<Converter> converters = this.createConverters(converterStrings);
        List<Page> allPages = this.createPages(pages);
        int steps = this.getNumberOfSteps(pages.size(), allPages.size(), converterStrings.size(), converters.size());
        this.state.updateMax(steps);
        if (this.convertPages(allPages, converters)) {
            if (allPages.size() < 1) {
                String message = "All pages submitted were disqualified for various reasons. Could not complete conversion.";
                this.log.warn((Object)message);
                this.errors.addError(FeedbackHandler.Feedback.CONVERTER_ERROR, message, true);
                this.state.updateMax(this.state.getStep());
                return;
            }
            steps = this.getNumberOfSteps(pages.size(), allPages.size(), converterStrings.size(), converters.size());
            if (steps != this.state.getMax()) {
                this.state.updateMax(steps);
            }
            this.savePages(outputDir, allPages);
        }
        this.log.info((Object)"Conversion Complete");
    }

    protected void initConversion() {
        this.miscProperties.clear();
    }

    public List<Converter> createConverters(List<String> converterStrings) {
        return this.createConverters(converterStrings, true);
    }

    public List<Converter> createConverters(List<String> converterStrings, boolean runningState) {
        String message = "Initializing Converters...";
        if (runningState) {
            this.state.updateNote(message);
        }
        this.log.info((Object)message);
        new DefaultXmlEvents().clearAll();
        ArrayList<Converter> converters = new ArrayList<Converter>();
        for (String converterStr : converterStrings) {
            if (runningState) {
                this.state.updateProgress();
            }
            if (runningState && !this.running) {
                this.feedback = FeedbackHandler.Feedback.CANCELLED;
                return Collections.emptyList();
            }
            if (this.isNonConverterProperty(converterStr)) {
                this.handleNonConverterProperty(converterStr);
                continue;
            }
            Converter converter = this.getConverterFromString(converterStr);
            if (converter == null) continue;
            converters.add(converter);
        }
        if (runningState) {
            this.addDefaultMiscProperties();
        }
        return converters;
    }

    @Nullable
    public Converter getConverterFromString(String converterStr) {
        Converter converter;
        int equalLoc = converterStr.indexOf("=");
        String key = converterStr.substring(0, equalLoc);
        String value = converterStr.substring(equalLoc + 1);
        try {
            if (key.indexOf(CONVERTERTYPE_CLASS) >= 0) {
                converter = this.getConverterClassFromCache(value);
            } else if (key.indexOf(CONVERTERTYPE_PERL) >= 0) {
                converter = PerlConverter.getPerlConverter((String)value);
                converter.setValue(value);
            } else if (key.indexOf(CONVERTERTYPE_JAVAREGEXTOKEN) >= 0) {
                converter = JavaRegexAndTokenizerConverter.getConverter((String)value);
                converter.setValue(value);
            } else if (key.indexOf(CONVERTERTYPE_JAVAREGEX) >= 0) {
                converter = JavaRegexConverter.getConverter((String)value);
                converter.setValue(value);
            } else if (key.indexOf(CONVERTERTYPE_TWIKICLEANER) >= 0) {
                converter = TWikiRegexConverterCleanerWrapper.getTWikiRegexConverterCleanerWrapper((String)value);
                converter.setValue(value);
            } else {
                String note = "Converter ignored -- name pattern not recognized: " + key;
                this.errors.addError(FeedbackHandler.Feedback.BAD_PROPERTY, note, true);
                this.log.error((Object)note);
                return null;
            }
            converter.setProperties(this.miscProperties);
        }
        catch (ClassNotFoundException e) {
            this.errors.addError(FeedbackHandler.Feedback.BAD_CONVERTER_CLASS, "Converter ignored -- the Java class " + value + " was not found", true);
            return null;
        }
        catch (IllegalAccessException e) {
            this.errors.addError(FeedbackHandler.Feedback.BAD_CONVERTER_CLASS, "Converter ignored -- there was a problem creating a converter object", true);
            return null;
        }
        catch (InstantiationException e) {
            this.errors.addError(FeedbackHandler.Feedback.BAD_CONVERTER_CLASS, "Converter ignored -- there was a problem creating the Java class " + value, true);
            return null;
        }
        catch (ClassCastException e) {
            this.errors.addError(FeedbackHandler.Feedback.BAD_CONVERTER_CLASS, "Converter ignored -- the Java class " + value + " must implement the " + Converter.class.getName() + " interface!", true);
            return null;
        }
        converter.setKey(key);
        return converter;
    }

    protected void handleNonConverterProperty(String converterStr) {
        int equalLoc = converterStr.indexOf("=");
        String key = converterStr.substring(0, equalLoc);
        String value = converterStr.substring(equalLoc + 1);
        String parent = "";
        try {
            if (key.indexOf(NONCONVERTERTYPE_HIERARCHYBUILDER) >= 0) {
                if (this.isHierarchySwitch(key)) {
                    this.setHierarchyHandler(value);
                } else {
                    HierarchyBuilder hierarchy;
                    parent = HierarchyBuilder.class.getName();
                    Class<?> c = Class.forName(value);
                    this.hierarchyBuilder = hierarchy = (HierarchyBuilder)c.newInstance();
                    this.hierarchyBuilder.setProperties(this.miscProperties);
                }
            } else if (key.endsWith(NONCONVERTERTYPE_PAGEHISTORYPRESERVATION)) {
                this.handlePageHistoryProperty(key, value);
            } else if (key.endsWith(NONCONVERTERTYPE_ILLEGALHANDLING)) {
                this.handleIllegalHandling(key, value);
            } else if (key.endsWith(NONCONVERTERTYPE_AUTODETECTSPACEKEYS)) {
                this.handleAutoDetectSpacekeys(key, value);
            } else if (key.endsWith(NONCONVERTERTYPE_MISCPROPERTIES)) {
                this.handleMiscellaneousProperties(key, value);
            } else if (key.endsWith(NONCONVERTERTYPE_FILTERS)) {
                parent = FileFilter.class.getName();
                this.handleFilters(key, value);
            } else if (key.endsWith(NONCONVERTERTYPE_XMLEVENT)) {
                this.handleXmlEvents(key, value);
            }
        }
        catch (ClassNotFoundException e) {
            String message = "Property ignored -- the Java class " + value + " was not found";
            this.log.error((Object)message);
            this.errors.addError(FeedbackHandler.Feedback.BAD_PROPERTY, message, true);
        }
        catch (IllegalAccessException e) {
            String message = "Property ignored -- there was a problem creating the Java class: " + value + ".\nNote: A necessary method's permissions were too restrictive. Check the constructor. ";
            this.log.error((Object)message);
            this.errors.addError(FeedbackHandler.Feedback.BAD_PROPERTY, message, true);
        }
        catch (InstantiationException e) {
            String message = "Property ignored -- there was a problem creating the Java class " + value + ".\nNote: The class cannot be instantiated as it is abstract or is an interface.";
            this.log.error((Object)message);
            this.errors.addError(FeedbackHandler.Feedback.BAD_PROPERTY, message, true);
        }
        catch (ClassCastException e) {
            String message = "Property ignored -- the Java class " + value + " must implement the " + parent + " interface!";
            this.log.error((Object)message);
            this.errors.addError(FeedbackHandler.Feedback.BAD_PROPERTY, message, true);
        }
        catch (IllegalArgumentException e) {
            String message = "Property ignored -- property value was not in expected format.";
            this.log.error((Object)message);
            this.errors.addError(FeedbackHandler.Feedback.BAD_PROPERTY, message, true);
        }
    }

    private Converter getConverterClassFromCache(String key) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Converter converter = this.converterCacheMap.get(key);
        if (converter == null) {
            Class<?> c = Class.forName(key);
            converter = (Converter)c.newInstance();
            this.converterCacheMap.put(key, converter);
        }
        return converter;
    }

    @Nullable
    protected FileFilter createFilter(String pattern) {
        Set<String> values = this.getFilterValues();
        if (pattern != null && !"".equals(pattern)) {
            values.add(pattern);
        }
        if (values.isEmpty()) {
            return null;
        }
        FilterChain chain = new FilterChain(values, this.miscProperties);
        return chain.getFilter();
    }

    protected List<Page> createPages(List<File> inputPages) {
        String message = "Initializing Pages...";
        this.state.updateNote(message);
        this.log.info((Object)message);
        LinkedList<Page> allPages = new LinkedList<Page>();
        for (File fileOrDir : inputPages) {
            this.state.updateProgress();
            List<Page> pages = this.recurse(fileOrDir);
            this.setupPages(fileOrDir, pages);
            allPages.addAll(pages);
        }
        return allPages;
    }

    private List<Page> recurse(File fileOrDir) {
        assert (fileOrDir != null);
        LinkedList<Page> result = new LinkedList<Page>();
        if (fileOrDir.isFile()) {
            PageSplitter splitter = this.getPageSplitter();
            if (splitter == null) {
                result.add(new Page(fileOrDir));
            } else {
                result.addAll(splitter.split(fileOrDir));
            }
        } else if (fileOrDir.isDirectory()) {
            File[] files;
            for (File file : files = fileOrDir.listFiles()) {
                result.addAll(this.recurse(file));
            }
        } else {
            String message = "Could not find file: '" + fileOrDir.getAbsolutePath() + "'.\nCheck existence and permissions.";
            this.log.warn((Object)message);
            this.errors.addError(FeedbackHandler.Feedback.BAD_FILE, message, true);
        }
        return result;
    }

    @Nullable
    private PageSplitter getPageSplitter() {
        Class<?> c;
        String classname = this.miscProperties.getProperty("pagesplitter", null);
        if (classname == null) {
            return null;
        }
        try {
            c = Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)("Could not find pagesplitter class named: " + classname), (Throwable)e);
            return null;
        }
        try {
            PageSplitter splitter = (PageSplitter)c.newInstance();
            return splitter;
        }
        catch (InstantiationException e) {
            this.log.error((Object)("Could not instantiate pagesplitter class named: " + classname), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)("Pagesplitter class can not legally be accessed: " + classname), (Throwable)e);
        }
        return null;
    }

    protected void setupPages(File baseDir, List<Page> pages) {
        String basepath = baseDir.getParentFile().getPath() + File.separator;
        int baselength = basepath.length();
        for (Page page : pages) {
            String pagePath = page.getFile().getPath();
            String pageName = this.getPagename(pagePath.substring(baselength));
            String path = this.getPath(pagePath);
            page.setPath(path);
            page.setName(pageName);
            if (!this.isHandlingPageHistoriesFromFilename()) continue;
            this.preserveHistory(page, pageName);
        }
    }

    private String getPath(String pagePath) {
        int fileNameStart = pagePath.lastIndexOf(File.separator);
        pagePath = fileNameStart >= 0 ? pagePath.substring(0, fileNameStart) : "";
        return pagePath;
    }

    protected Page preserveHistory(Page page, String filename) {
        String suffix = this.getPageHistorySuffix();
        if (suffix == null) {
            this.log.error((Object)"Error attempting to preserve history: Page history suffix is Null.");
            return page;
        }
        Matcher hashFinder = this.hashPattern.matcher(suffix);
        String suffixReplaceRegex = "";
        if (!hashFinder.find()) {
            this.log.error((Object)"Error attempting to preserve history: Suffix is invalid. Must contain '#'.");
            return page;
        }
        suffixReplaceRegex = hashFinder.replaceAll("(\\\\d+)");
        suffixReplaceRegex = "(.*)" + suffixReplaceRegex;
        Pattern suffixReplacePattern = Pattern.compile(suffixReplaceRegex);
        Matcher suffixReplacer = suffixReplacePattern.matcher(filename);
        if (suffixReplacer.find()) {
            String pagename = suffixReplacer.group(1);
            String versionString = suffixReplacer.group(2);
            int version = Integer.parseInt(versionString);
            page.setName(pagename);
            page.setVersion(version);
        }
        return page;
    }

    protected String getPagename(String pagePath) {
        String pageName = "";
        if (this.hierarchyHandler == HierarchyHandler.DEFAULT || this.hierarchyHandler == HierarchyHandler.HIERARCHY_BUILDER) {
            pageName = pagePath.substring(pagePath.lastIndexOf(File.separator) + 1);
        } else if (this.hierarchyHandler == HierarchyHandler.PAGENAME_HIERARCHIES) {
            String quotedSeparator = Pattern.quote(File.separator);
            pageName = pagePath.replaceAll(quotedSeparator, CONFLUENCE_SEPARATOR);
        }
        return pageName;
    }

    protected boolean convertPages(List<Page> pages, List<Converter> converters) {
        return this.convertPages(pages, converters, "Converting pages...");
    }

    protected boolean convertPages(List<Page> pages, List<Converter> converters, String note) {
        boolean result = true;
        this.state.updateNote(note);
        this.log.info((Object)note);
        this.startTotalConvertTime = new Date().getTime();
        Iterator<Page> iter = pages.iterator();
        while (iter.hasNext()) {
            File file;
            if (!this.running) {
                this.feedback = FeedbackHandler.Feedback.CANCELLED;
                return false;
            }
            Page page = iter.next();
            long startTimeStamp = this.conversionBookkeepingNextPage(page);
            if ((page.getOriginalText() == null || "".equals(page.getOriginalText())) && (file = this.getFileContents(page)) == null) {
                iter.remove();
                continue;
            }
            this.convertPage(converters, page);
            this.conversionBookkeepingEndThisPage(startTimeStamp);
            if (this.running) continue;
            this.feedback = FeedbackHandler.Feedback.CANCELLED;
            return false;
        }
        this.conversionBookkeepingEndAll(pages, converters);
        return result;
    }

    private long conversionBookkeepingEndThisPage(long startTimeStamp) {
        long stopTimeStamp = new Date().getTime();
        this.log.info((Object)("                   time to convert " + (stopTimeStamp - startTimeStamp) + "ms"));
        return stopTimeStamp;
    }

    private void conversionBookkeepingEndAll(List<Page> pages, List<Converter> converters) {
        long endTotalConvertTime = new Date().getTime();
        long totalTimeToConvert = (endTotalConvertTime - this.startTotalConvertTime) / 1000L;
        String baseMessage = "::: total time to convert files: " + totalTimeToConvert + " seconds.";
        this.log.info((Object)baseMessage);
    }

    private long conversionBookkeepingNextPage(Page page) {
        long startTimeStamp = new Date().getTime();
        this.log.info((Object)"-------------------------------------");
        this.log.info((Object)("converting page file: " + page.getName()));
        if (page.getFile() != null && page.getFile().getName() != null) {
            this.log.debug((Object)("original file name: " + page.getFile().getName()));
        }
        return startTimeStamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private File getFileContents(Page page) {
        File file = page.getFile();
        if (file == null) {
            if (page.getOriginalText() != null && !"".equals(page.getOriginalText())) {
                this.log.warn((Object)"This appears to be a unit test. Continue as for Unit Test.");
                String path = page.getPath();
                if (path != null) return new File(path);
                path = "";
                return new File(path);
            }
            this.log.warn((Object)("No file was set for page " + page.getName() + ". Skipping page."));
            return null;
        }
        if (page.getOriginalText() != null) return file;
        try {
            String pageContents = "";
            if (this.changingEncoding()) {
                String encoding = this.getEncoding();
                byte[] pagebytes = FileUtils.getBytesFromFile((File)file);
                try {
                    pageContents = new String(pagebytes, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    String baseerror = "Could not encode file with encoding: " + encoding + ".";
                    this.log.error((Object)(baseerror + " Using utf-8."));
                    this.errors.addError(FeedbackHandler.Feedback.BAD_SETTING, baseerror, true);
                    pageContents = new String(pagebytes, "utf-8");
                }
            } else {
                pageContents = FileUtils.readTextFile((File)file);
            }
            page.setOriginalText(pageContents);
        }
        catch (IOException e) {
            String message = "Could not read file " + file.getAbsolutePath() + ".\nCheck existence and permissions.";
            this.log.error((Object)message);
            this.errors.addError(FeedbackHandler.Feedback.BAD_FILE, message, true);
            return null;
        }
        page.setUnchangedSource(page.getOriginalText());
        return file;
    }

    private boolean changingEncoding() {
        if (this.miscProperties != null) {
            return this.miscProperties.containsKey("encoding");
        }
        return false;
    }

    private String getEncoding() {
        if (this.miscProperties != null) {
            return this.miscProperties.getProperty("encoding", "utf-8");
        }
        return "utf-8";
    }

    protected Page convertPage(List<Converter> converters, Page page) {
        if (page.getConvertedText() == null) {
            page.setConvertedText(page.getOriginalText());
        }
        for (Converter converter : converters) {
            try {
                this.state.updateProgress();
                if (this.settings != null) {
                    converter.setAttachmentDirectory(this.settings.getAttachmentDirectory());
                } else {
                    ConfluenceSettingsForm confSettings = UWCForm2.getInstance().getConfluenceSettingsForm();
                    converter.setAttachmentDirectory(confSettings.getAttachmentDirectory());
                }
                converter.convert(page);
                page.setOriginalText(page.getConvertedText());
            }
            catch (Exception e) {
                String note = "Exception thrown by converter " + converter.getKey() + " on page " + page.getName() + ". Continuing with next converter.";
                this.log.error((Object)note, (Throwable)e);
                this.errors.addError(FeedbackHandler.Feedback.CONVERTER_ERROR, note, true);
            }
            if (!converter.getErrors().hasErrors()) continue;
            this.hadConverterErrors = true;
            this.state.updateNote(converter.getErrors().getFeedbackWindowErrorMessages());
        }
        return page;
    }

    private void savePages(File outputDir, List<Page> pages) {
        String message = "Saving Pages to Filesystem";
        this.state.updateNote(message);
        this.log.info((Object)message);
        if (!outputDir.exists() && !outputDir.mkdir()) {
            String dirfailMessage = "Directory creation failed for directory " + outputDir.toString();
            this.log.error((Object)(FeedbackHandler.Feedback.BAD_OUTPUT_DIR + ": " + dirfailMessage));
            this.errors.addError(FeedbackHandler.Feedback.BAD_OUTPUT_DIR, dirfailMessage, true);
        }
        for (Page page : pages) {
            if (!this.running) {
                this.feedback = FeedbackHandler.Feedback.CANCELLED;
                return;
            }
            this.state.updateProgress();
            FileUtils.writeFile((String)page.getConvertedText(), (String)new File(outputDir, page.getName()).getPath());
        }
    }

    public static String validateSpacekey(String spacekey) {
        String validated = spacekey.replaceAll("[^A-Za-z0-9]", "");
        return validated;
    }

    private String getMaxAttachmentSizeStringFromModel() {
        return this.settings.getAttachmentSize();
    }

    protected void handlePageHistoryProperty(String key, String value) {
        Matcher switchFinder = this.switchPattern.matcher(key);
        if (switchFinder.find()) {
            this.handlingPageHistories = Boolean.parseBoolean(value);
            return;
        }
        Matcher suffixFinder = this.suffixPattern.matcher(key);
        if (suffixFinder.find()) {
            this.setPageHistorySuffix(value);
            return;
        }
    }

    protected void handleIllegalHandling(String key, String value) {
        boolean enabled = true;
        if ("false".equals(value = value.trim())) {
            enabled = false;
        }
        this.illegalHandlingEnabled = enabled;
    }

    protected void handleAutoDetectSpacekeys(String key, String value) {
        boolean enabled = false;
        if ("true".equals(value = value.trim())) {
            enabled = true;
        }
    }

    protected Properties handleMiscellaneousProperties(String key, String value) {
        Matcher miscKeyFinder = this.miscPropsPattern.matcher(key);
        if (miscKeyFinder.matches()) {
            String misckey = miscKeyFinder.group(1);
            if (this.miscProperties == null) {
                this.miscProperties = new Properties();
            }
            this.miscProperties.put(misckey, value);
            this.log.debug((Object)("Miscellaneous Property set: " + misckey + "=" + value));
            return this.miscProperties;
        }
        String error = "Miscellaneous property was detected, but key was invalid. Could not instantiate property: " + key + "=" + value;
        this.log.error((Object)error);
        this.errors.addError(FeedbackHandler.Feedback.BAD_PROPERTY, error, true);
        return this.miscProperties;
    }

    private void addDefaultMiscProperties() {
        this.handleMiscellaneousProperties("Testing.1234.spacekey.property", this.settings.getSpace());
    }

    protected void handleFilters(String key, String value) throws InstantiationException, IllegalAccessException {
        this.log.debug((Object)("filter property = " + value));
        this.getFilterValues().add(value);
    }

    private Set<String> getFilterValues() {
        if (this.filterValues == null) {
            this.filterValues = new HashSet<String>();
        }
        return this.filterValues;
    }

    private void handleXmlEvents(String key, String value) {
        String[] tags;
        String tag = this.getXmlEventTag(value);
        String classname = this.getXmlEventClassname(value);
        for (String onetag : tags = tag.split(",")) {
            onetag = onetag.trim();
            this.addOneXmlEvent(onetag, classname);
        }
    }

    private void addOneXmlEvent(String tag, String classname) {
        if (this.miscProperties.containsKey("xmlevents")) {
            Class<Object> eventsClass;
            String xmleventsclass = this.miscProperties.getProperty("xmlevents");
            try {
                eventsClass = Class.forName(xmleventsclass);
            }
            catch (ClassNotFoundException e) {
                this.log.warn((Object)("xmlevents property value - " + xmleventsclass + " - does not exist. Using DefaultXmlEvents."));
                this.miscProperties.remove("xmlevents");
                eventsClass = DefaultXmlEvents.class;
            }
            XmlEvents events = null;
            try {
                events = (XmlEvents)eventsClass.newInstance();
                events.addEvent(tag, classname);
                return;
            }
            catch (Exception e) {
                this.log.warn((Object)("xmlevents property value - " + xmleventsclass + " - hasn't implemented XmlEvents. Using DefaultXmlEvents."));
                this.miscProperties.remove("xmlevents");
            }
        }
        new DefaultXmlEvents().addEvent(tag, classname);
    }

    protected String getXmlEventClassname(String value) {
        Matcher finder = this.xmleventClassPattern.matcher(value);
        if (finder.find()) {
            return finder.group(1);
        }
        throw new IllegalArgumentException(XMLEVENT_PROP_ERROR);
    }

    protected String getXmlEventTag(String value) {
        Matcher finder = this.xmleventTagPattern.matcher(value);
        if (finder.find()) {
            return finder.group(1);
        }
        throw new IllegalArgumentException(XMLEVENT_PROP_ERROR);
    }

    protected boolean isHierarchySwitch(String key) {
        Matcher switchFinder = this.switchPattern.matcher(key);
        return switchFinder.find();
    }

    public boolean isNonConverterProperty(String input) {
        String converterTypes = "((.hierarchy-builder)|(page-history-preservation)|(illegal-handling)|(autodetect-spacekeys)|(.filter)|(.property)|(.xmlevent))";
        String converterPattern = "[-\\w\\d.]+?" + converterTypes + "=.*";
        return input.matches(converterPattern);
    }

    public boolean isHandlingPageHistoriesFromFilename() {
        return this.handlingPageHistories && this.pageHistorySuffix != null;
    }

    public String getPageHistorySuffix() {
        return this.pageHistorySuffix;
    }

    protected boolean setPageHistorySuffix(String suffix) {
        Matcher hashFinder = this.hashPattern.matcher(suffix);
        if (hashFinder.find()) {
            this.pageHistorySuffix = suffix;
            return true;
        }
        this.log.error((Object)("Error trying to preserve page history: Suffix '" + suffix + "' does not have a sortable component. Must include '#'."));
        this.pageHistorySuffix = null;
        return false;
    }

    protected HierarchyBuilder getHierarchyBuilder() {
        return this.hierarchyBuilder;
    }

    protected HierarchyHandler getHierarchyHandler() {
        return this.hierarchyHandler;
    }

    private void setHierarchyHandler(String input) {
        if (input.matches("UseBuilder")) {
            this.hierarchyHandler = HierarchyHandler.HIERARCHY_BUILDER;
        } else if (input.matches("UsePagenames")) {
            this.hierarchyHandler = HierarchyHandler.PAGENAME_HIERARCHIES;
        } else if (input.matches("Default")) {
            this.hierarchyHandler = HierarchyHandler.DEFAULT;
        }
    }

    public FeedbackHandler.Feedback getConverterFeedback() {
        return this.feedback;
    }

    public void resetFeedback() {
        this.feedback = FeedbackHandler.Feedback.NONE;
    }

    public void resetErrorHandlers() {
        this.errors.clear();
        this.hadConverterErrors = false;
    }

    public void resetHierarchy() {
        this.hierarchyBuilder = null;
        this.hierarchyHandler = HierarchyHandler.DEFAULT;
    }

    public ConverterErrors getErrors() {
        return this.errors;
    }

    public boolean hadConverterErrors() {
        return this.hadConverterErrors;
    }

    public boolean isIllegalHandlingEnabled() {
        return this.illegalHandlingEnabled;
    }

    protected static enum HierarchyHandler {
        DEFAULT,
        HIERARCHY_BUILDER,
        PAGENAME_HIERARCHIES;

    }
}

