/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.pivotal.web;

import com.atlassian.jira.plugins.importer.appbridge.software.JimJiraSoftwareAccessor;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ConfigFileHandler;
import com.atlassian.jira.plugins.importer.web.RemoteSiteImporterSetupPage;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import org.apache.commons.lang.StringUtils;

public class PivotalSetupPage
extends AbstractSetupPage
implements RemoteSiteImporterSetupPage {
    private String siteUsername;
    private String sitePassword;
    private String customPivotalUrl;
    private boolean useCustomPivotalUrl;
    private boolean showUsernameMapping;
    private final JimJiraSoftwareAccessor jimJiraSoftwareAccessor;
    private final ConfigFileHandler configFileHandler;

    public PivotalSetupPage(UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, JimJiraSoftwareAccessor jimJiraSoftwareAccessor, ConfigFileHandler configFileHandler, @ComponentImport PluginAccessor pluginAccessor) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
        this.jimJiraSoftwareAccessor = jimJiraSoftwareAccessor;
        this.configFileHandler = configFileHandler;
    }

    @Override
    protected void doValidation() {
        super.doValidation();
        if (!this.configFileHandler.verifyConfigFileParam(this)) {
            return;
        }
        if (this.isPreviousClicked()) {
            return;
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ImporterController controller = this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        this.publishImporterWizardStartedEvent();
        if (!this.isPreviousClicked() && !controller.createImportProcessBean(this)) {
            return "input";
        }
        return super.doExecute();
    }

    @Override
    public String getSiteUrl() {
        return this.useCustomPivotalUrl ? this.customPivotalUrl : "https://www.pivotaltracker.com/";
    }

    @Override
    public void setSiteUrl(String siteUrl) {
    }

    @Override
    public String getSiteUsername() {
        return this.siteUsername;
    }

    @Override
    public void setSiteUsername(String siteUsername) {
        this.siteUsername = StringUtils.trim((String)siteUsername);
    }

    @Override
    public String getSitePassword() {
        return this.sitePassword;
    }

    @Override
    public void setSitePassword(String sitePassword) {
        this.sitePassword = StringUtils.trim((String)sitePassword);
    }

    public boolean isShowUsernameMapping() {
        return this.showUsernameMapping;
    }

    public void setShowUsernameMapping(boolean showUsernameMapping) {
        this.showUsernameMapping = showUsernameMapping;
    }

    @Override
    public boolean getSiteCredentials() {
        return true;
    }

    public boolean getAttachmentsEnabled() {
        return this.getApplicationProperties().getOption("jira.option.allowattachments");
    }

    public boolean getIssueLinkingEnabled() {
        return this.getApplicationProperties().getOption("jira.option.issuelinking");
    }

    @Override
    public boolean isIssueLinkingEnabled() {
        return true;
    }

    @Override
    public boolean isSiteUrlRequired() {
        return false;
    }

    @Override
    public String getFormTitle() {
        return this.getText("jira-importer-plugin.wizard.connect.pivotal.title");
    }

    @Override
    public String getFormDescription() {
        return this.getText("jira-importer-plugin.wizard.connect.pivotal.description");
    }

    @Override
    public String getLoginLabel() {
        return this.getText("jira-importer-plugin.wizard.connect.pivotal.login.label");
    }

    @Override
    public String getPasswordLabel() {
        return this.getText("jira-importer-plugin.wizard.connect.pivotal.password.label");
    }

    public boolean isGreenHooperFeaturesEnabled() {
        return this.jimJiraSoftwareAccessor.isGreenHooperFeaturesEnabled();
    }

    public boolean isGreenHopperInstalledAndEnabled() {
        return this.jimJiraSoftwareAccessor.isGreenHopperInstalledAndEnabled();
    }

    public String getCustomPivotalUrl() {
        return this.customPivotalUrl;
    }

    public void setCustomPivotalUrl(String customPivotalUrl) {
        this.customPivotalUrl = customPivotalUrl;
    }

    public boolean isUseCustomPivotalUrl() {
        return this.useCustomPivotalUrl;
    }

    public void setUseCustomPivotalUrl(boolean useCustomPivotalUrl) {
        this.useCustomPivotalUrl = useCustomPivotalUrl;
    }
}

