/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.pivotal;

import com.atlassian.jira.issue.label.LabelParser;
import com.atlassian.jira.plugins.importer.XmlUtil;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.imports.config.UserNameMapper;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalExternalAttachment;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.jdom.Element;
import org.joda.time.DateTime;

public class StoryParser {
    private final UserNameMapper userNameMapper;
    private static final String DATE_TIME_PATTERN = "yyyy/MM/dd HH:mm:ss z";
    static final String SUBTASK_STATUS_FINISHED = "subtask_finished";
    static final String SUBTASK_STATUS_OPEN = "subtask_open";

    public StoryParser(UserNameMapper userNameMapper) {
        this.userNameMapper = userNameMapper;
    }

    public ExternalIssue parseStory(Element element) {
        Integer estimate;
        ExternalIssue externalIssue = new ExternalIssue();
        ArrayList customFields = Lists.newArrayList();
        externalIssue.setExternalId(element.getChildTextTrim("id"));
        externalIssue.setReporter(this.userNameMapper.getUsernameForLoginName(element.getChildText("requested_by")));
        externalIssue.setStatus(element.getChildText("current_state"));
        externalIssue.setAssignee(this.userNameMapper.getUsernameForLoginName(element.getChildText("owned_by")));
        externalIssue.setIssueType(element.getChildText("story_type"));
        externalIssue.setSummary(element.getChildText("name"));
        externalIssue.setDescription(element.getChildText("description"));
        DateTime creationDate = this.parseDateTime(element.getChildText("created_at"));
        externalIssue.setCreated(creationDate.toDate());
        DateTime updateDate = this.parseDateTime(element.getChildText("updated_at"));
        externalIssue.setUpdated(updateDate.toDate());
        externalIssue.setComments(this.parseNotes(element.getChild("notes")));
        externalIssue.setAttachments(this.parseAttachments(element.getChild("attachments")));
        externalIssue.setSubtasks(this.parseTasks(externalIssue.getAssignee(), externalIssue.getReporter(), element.getChild("tasks")));
        externalIssue.setLabels(this.parseLabels(element.getChild("labels")));
        Element estimateElement = element.getChild("estimate");
        if (estimateElement != null && "integer".equals(estimateElement.getAttributeValue("type")) && (estimate = Integer.valueOf(estimateElement.getTextTrim())) != -1) {
            customFields.add(new ExternalCustomFieldValue("Story Points", "com.atlassian.jira.plugin.system.customfieldtypes:float", "com.atlassian.jira.plugin.system.customfieldtypes:numberrange", estimate.toString()));
        }
        customFields.add(new ExternalCustomFieldValue("External issue URL", "com.atlassian.jira.plugin.system.customfieldtypes:url", "com.atlassian.jira.plugin.system.customfieldtypes:exacttextsearcher", element.getChildTextTrim("url")));
        externalIssue.setExternalCustomFieldValues(customFields);
        return externalIssue;
    }

    protected Set<String> parseLabels(@Nullable Element labels) {
        HashSet result = Sets.newHashSet();
        if (labels != null) {
            for (String label : StringUtils.split((String)labels.getText(), (char)',')) {
                String cleanLabel = LabelParser.getCleanLabel((String)label);
                if (!StringUtils.isNotBlank((String)cleanLabel)) continue;
                result.add(cleanLabel);
            }
        }
        return result;
    }

    List<ExternalAttachment> parseAttachments(@Nullable Element element) {
        return Lists.newArrayList((Iterable)Collections2.transform(XmlUtil.getChildren(element, "attachment"), (Function)new Function<Element, ExternalAttachment>(){

            public ExternalAttachment apply(Element element) {
                String filename = element.getChildText("filename");
                String url = element.getChildText("url");
                DateTime uploadedAt = StoryParser.this.parseDateTime(element.getChildText("uploaded_at"));
                PivotalExternalAttachment attachment = new PivotalExternalAttachment(filename, url, uploadedAt.toDate());
                attachment.setAttacher(StoryParser.this.userNameMapper.getUsernameForLoginName(element.getChildText("uploaded_by")));
                attachment.setDescription(element.getChildText("description"));
                return attachment;
            }
        }));
    }

    List<ExternalIssue> parseTasks(final @Nullable String assignee, final @Nullable String reporter, @Nullable Element element) {
        List taskElements = Ordering.natural().onResultOf((Function)new Function<Element, Comparable>(){

            public Comparable apply(Element input) {
                return Integer.valueOf(input.getChildTextTrim("position"));
            }
        }).sortedCopy(XmlUtil.getChildren(element, "task"));
        return Lists.newArrayList((Iterable)Collections2.transform((Collection)taskElements, (Function)new Function<Element, ExternalIssue>(){

            public ExternalIssue apply(Element input) {
                ExternalIssue subtask = new ExternalIssue();
                subtask.setAssignee(assignee);
                subtask.setReporter(reporter);
                subtask.setSummary(input.getChildText("description"));
                subtask.setCreated(StoryParser.this.parseDateTime(input.getChildText("created_at")).toDate());
                subtask.setIssueType("subtask");
                boolean finished = Boolean.valueOf(input.getChildTextTrim("complete"));
                subtask.setStatus(finished ? StoryParser.SUBTASK_STATUS_FINISHED : StoryParser.SUBTASK_STATUS_OPEN);
                return subtask;
            }
        }));
    }

    public List<ExternalComment> parseNotes(@Nullable Element element) {
        return Lists.newArrayList((Iterable)Collections2.transform(XmlUtil.getChildren(element, "note"), (Function)new Function<Element, ExternalComment>(){

            public ExternalComment apply(Element note) {
                return new ExternalComment(note.getChildText("text"), StoryParser.this.userNameMapper.getUsernameForLoginName(note.getChildText("author")), StoryParser.this.parseDateTime(note.getChildText("noted_at")));
            }
        }));
    }

    DateTime parseDateTime(String str) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TIME_PATTERN, Locale.ENGLISH);
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(str, parsePosition);
        if (date == null || parsePosition.getIndex() != str.length()) {
            throw new IllegalArgumentException("Cannot parse [" + str + "] to date/time using pattern [" + DATE_TIME_PATTERN + "]");
        }
        return new DateTime((Object)date);
    }

    public List<ExternalIssue> parseStories(@Nullable Element stories) {
        return Lists.transform(XmlUtil.getChildren(stories, "story"), (Function)new Function<Element, ExternalIssue>(){

            public ExternalIssue apply(Element from) {
                return StoryParser.this.parseStory(from);
            }
        });
    }
}

