/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.pivotal;

import com.atlassian.jira.plugins.importer.XmlUtil;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.config.UserNameMapper;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.jdom.Element;

public class ProjectParser {
    private final UserNameMapper userNameMapper;

    public ProjectParser(UserNameMapper userNameMapper) {
        this.userNameMapper = userNameMapper;
    }

    public String getName(Element element) {
        return element.getChildText("name");
    }

    @Nullable
    public String getChildText(Element element, String ... childrenNames) {
        for (String childrenName : childrenNames) {
            if ((element = element.getChild(childrenName)) != null) continue;
            return null;
        }
        return element.getText();
    }

    public List<String> getProjectNames(Element projects) {
        return Lists.newArrayList((Iterable)Collections2.transform(XmlUtil.getChildren(projects, "project"), (Function)new Function<Element, String>(){

            public String apply(Element from) {
                return ProjectParser.this.getName(from);
            }
        }));
    }

    public List<ExternalProject> getProjects(Element projects) {
        return Lists.newArrayList((Iterable)Collections2.transform(XmlUtil.getChildren(projects, "project"), (Function)new Function<Element, ExternalProject>(){

            public ExternalProject apply(Element from) {
                return ProjectParser.this.getProject(from);
            }
        }));
    }

    public ExternalProject getProject(Element element) {
        String id = element.getChildText("id");
        String name = this.getName(element);
        ExternalProject project = new ExternalProject(name, null);
        project.setLead(this.getProjectOwner(element));
        project.setId(id);
        return project;
    }

    @Nullable
    private String getProjectOwner(Element element) {
        List<Element> membershipElements = XmlUtil.getChildren(element.getChild("memberships"), "membership");
        for (Element membershipElement : membershipElements) {
            String ownerName;
            if (!"Owner".equals(membershipElement.getChildText("role")) || (ownerName = this.getChildText(membershipElement, "person", "name")) == null) continue;
            return this.userNameMapper.getUsernameForLoginName(ownerName);
        }
        return null;
    }
}

