/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.pivotal;

import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.imports.config.UserNameMapper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinitionsFactory;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelperImpl;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ConsoleImportLogger;
import com.atlassian.jira.plugins.importer.imports.pivotal.CachingPivotalClient;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalClient;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalDataBean;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalImporterController;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalRemoteException;
import com.atlassian.jira.plugins.importer.imports.pivotal.config.LoginNameValueMapper;
import com.atlassian.jira.plugins.importer.web.SiteConfiguration;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class PivotalConfigBean
extends AbstractConfigBean2
implements UserNameMapper {
    private final PivotalClient pivotalClient;
    private final String defaultResolutionId;
    private final SiteConfiguration credentials;
    private final PivotalImporterController importerController;
    private boolean showUserMappingPage;

    public PivotalConfigBean(SiteConfiguration credentials, PivotalImporterController importerController) {
        this.credentials = credentials;
        this.importerController = importerController;
        this.pivotalClient = new CachingPivotalClient(URI.create(credentials.getUrl()), this);
        this.defaultResolutionId = this.getApplicationProperties().getString("jira.constant.default.resolution");
    }

    @Override
    public ValueMappingHelper initializeValueMappingHelper() {
        ValueMappingDefinitionsFactory mappingDefinitionFactory = new ValueMappingDefinitionsFactory(){

            @Override
            public List<ValueMappingDefinition> createMappingDefinitions(ValueMappingHelper valueMappingHelper) {
                if (PivotalConfigBean.this.showUserMappingPage) {
                    Supplier<Set<String>> usernameProvider = new Supplier<Set<String>>(){

                        public Set<String> get() {
                            PivotalDataBean dataBean = PivotalConfigBean.this.importerController.createDataBean(false);
                            Set<ExternalUser> allUsers = dataBean.getAllUsers(ConsoleImportLogger.INSTANCE);
                            return ImmutableSet.copyOf((Iterable)Iterables.transform(allUsers, (Function)new ExternalUser.FullNameFunction()));
                        }
                    };
                    return Collections.singletonList(new LoginNameValueMapper(usernameProvider, PivotalConfigBean.this.getJiraAuthenticationContext()));
                }
                return Collections.emptyList();
            }
        };
        return new ValueMappingHelperImpl(mappingDefinitionFactory);
    }

    public PivotalClient getPivotalClient() {
        return this.pivotalClient;
    }

    @Override
    public List<String> getExternalProjectNames() {
        try {
            PivotalClient pivotalClient = this.getPivotalClient();
            if (!pivotalClient.isLoggedIn()) {
                pivotalClient.login(this.credentials.getUsername(), this.credentials.getPassword());
            }
            return Lists.newArrayList(pivotalClient.getAllProjectNames());
        }
        catch (PivotalRemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Map<String, String>> getAvailableFieldMappings(ExternalCustomField customField, Set<ExternalProject> projects) {
        return Maps.newLinkedHashMap();
    }

    @Override
    public List<ExternalCustomField> getCustomFields() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getLinkNamesFromDb() {
        return Collections.emptyList();
    }

    @Override
    public String getUsernameForLoginName(String loginName) {
        if (StringUtils.isBlank((String)this.getValueMappingHelper().getValueMapping("Username", loginName))) {
            return loginName;
        }
        return this.getValueMappingHelper().getValueMappingForImport("Username", loginName);
    }

    public boolean isShowUserMappingPage() {
        return this.showUserMappingPage;
    }

    public void setShowUserMappingPage(boolean showUserMappingPage) {
        this.showUserMappingPage = showUserMappingPage;
    }

    public String getDefaultResolutionId() {
        return this.defaultResolutionId;
    }

    public SiteConfiguration getCredentials() {
        return this.credentials;
    }
}

