/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.pivotal;

import com.atlassian.jira.plugins.importer.XmlUtil;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalWorklog;
import com.atlassian.jira.plugins.importer.external.beans.NamedExternalObject;
import com.atlassian.jira.plugins.importer.imports.HttpDownloader;
import com.atlassian.jira.plugins.importer.imports.config.UserNameMapper;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.pivotal.IterationParser;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalExternalAttachment;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalHttpException;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalIteration;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalRemoteException;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalTimeShiftsParser;
import com.atlassian.jira.plugins.importer.imports.pivotal.ProjectMembershipParser;
import com.atlassian.jira.plugins.importer.imports.pivotal.ProjectParser;
import com.atlassian.jira.plugins.importer.imports.pivotal.StoryParser;
import com.atlassian.jira.util.AttachmentUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class PivotalClient {
    private static final String PIVOTAL_HOST = "www.pivotaltracker.com";
    public static final String PIVOTAL_URL = "https://www.pivotaltracker.com/";
    private final String pivotalSigninUrl;
    private final String pivotalTimeshiftsUrl;
    private final String pivotalNotAllowedUrl;
    private final String USERNAME_QUERY_PARAM_NAME = "credentials[username]";
    private final String PASSWORD_QUERY_PARAM_NAME = "credentials[password]";
    private String token;
    private final URI rootUri;
    private DefaultHttpClient authenticatedHttpClient;
    private HttpContext httpContext;
    private final UserNameMapper userNameMapper;
    private static final int DEFAULT_STORY_PAGINATION_LIMIT = 2000;
    private int storyPaginationLimit = 2000;
    private static final Pattern AUTHENTICITY_PATTERN = Pattern.compile("input +name=\"authenticity_token\" +type=\"hidden\" +value=\"([^\"]+)\"");

    PivotalClient(URI uri) {
        this(uri, uri, UserNameMapper.NO_MAPPING);
    }

    public PivotalClient(URI uri, UserNameMapper userNameMapper) {
        this(uri, UriBuilder.fromUri((URI)uri).path("/services/v3").build(new Object[0]), userNameMapper);
    }

    private PivotalClient(URI uri, URI rootUri, UserNameMapper userNameMapper) {
        this.rootUri = rootUri;
        this.pivotalSigninUrl = UriBuilder.fromUri((URI)uri).path("/signin").build(new Object[0]).toString();
        this.pivotalTimeshiftsUrl = UriBuilder.fromUri((URI)uri).path("/time_shifts").build(new Object[0]).toString();
        this.pivotalNotAllowedUrl = UriBuilder.fromUri((URI)uri).path("/not_allowed").build(new Object[0]).toString();
        this.userNameMapper = userNameMapper;
    }

    public void login(String username, String password) throws PivotalRemoteException {
        this.token = null;
        this.httpContext = new BasicHttpContext();
        this.authenticatedHttpClient = this.getHttpClient();
        this.authenticatedHttpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        this.authenticatedHttpClient.getParams().setBooleanParameter("http.protocol.single-cookie-header", true);
        InputStream is = this.openGet(UriBuilder.fromUri((URI)this.rootUri).path("tokens/active").build(new Object[0]).toString());
        try {
            SAXBuilder builder = XmlUtil.getSAXBuilder();
            Document document = builder.build(is);
            this.token = document.getRootElement().getChildText("guid");
            if (this.token == null) {
                throw new PivotalRemoteException("Login failed. Authentication token has not been served by Pivotal Tracker");
            }
        }
        catch (Exception e) {
            throw new PivotalRemoteException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public void logout() {
        this.token = null;
        this.httpContext = null;
        if (this.authenticatedHttpClient != null) {
            this.authenticatedHttpClient.getConnectionManager().shutdown();
            this.authenticatedHttpClient = null;
        }
    }

    protected String fixDownloadUrl(String url) {
        return url.startsWith("http://") ? "https" + StringUtils.removeStart((String)url, (String)"http") : url;
    }

    private void download(String url, File destination) throws IOException {
        FileOutputStream outputStream = null;
        InputStream inputStream = this.openGet(this.fixDownloadUrl(url));
        try {
            outputStream = FileUtils.openOutputStream((File)destination);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new PivotalRemoteException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    private InputStream openGet(String url) throws PivotalRemoteException {
        HttpGet getMethod = new HttpGet(url);
        try {
            HttpResponse response = this.executeWithLogin(getMethod);
            if (response.getStatusLine().getStatusCode() != 200) {
                EntityUtils.consume((HttpEntity)response.getEntity());
                throw new PivotalHttpException("HTTP Error code " + response.getStatusLine() + " returned by Pivotal Tracker", response.getStatusLine());
            }
            InputStream is = response.getEntity().getContent();
            if (is == null) {
                throw new PivotalRemoteException("Connection failed. Empty response returned by Pivotal Tracker");
            }
            return is;
        }
        catch (PivotalRemoteException e) {
            throw e;
        }
        catch (IOException e) {
            throw new PivotalRemoteException(e);
        }
    }

    private HttpResponse executeWithLogin(HttpGet get) throws IOException {
        get.getParams().setBooleanParameter("http.protocol.handle-redirects", false);
        HttpResponse response = this.authenticatedHttpClient.execute((HttpUriRequest)get, this.httpContext);
        String redirectUri = this.getRedirectLocation(response);
        if (redirectUri == null) {
            return response;
        }
        EntityUtils.consume((HttpEntity)response.getEntity());
        if (this.pivotalSigninUrl.equals(redirectUri)) {
            this.ensureLoggedInToWeb();
        }
        get.getParams().setBooleanParameter("http.protocol.handle-redirects", true);
        get.getParams().setBooleanParameter("http.protocol.allow-circular-redirects", true);
        return this.authenticatedHttpClient.execute((HttpUriRequest)get, this.httpContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureLoggedInToWeb() throws IOException {
        HttpPost signInPost = new HttpPost(this.pivotalSigninUrl);
        UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)this.authenticatedHttpClient.getCredentialsProvider().getCredentials(AuthScope.ANY);
        String authenticityToken = this.fetchAuthenticityToken(credentials);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity((List)Lists.newArrayList((Object[])new NameValuePair[]{new BasicNameValuePair("authenticity_token", authenticityToken), new BasicNameValuePair("credentials[username]", credentials.getUserName()), new BasicNameValuePair("credentials[password]", credentials.getPassword()), new BasicNameValuePair("time_zone_offset", "0")}));
        signInPost.setEntity((HttpEntity)entity);
        HttpResponse response = this.authenticatedHttpClient.execute((HttpUriRequest)signInPost, this.httpContext);
        try {
            if (response.getStatusLine().getStatusCode() != 302 || this.pivotalSigninUrl.equals(this.getRedirectLocation(response))) {
                throw new PivotalRemoteException("Failed to authenticate Pivotal connection");
            }
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    private String fetchAuthenticityToken(UsernamePasswordCredentials credentials) throws IOException {
        URI signInUri = UriBuilder.fromUri((String)this.pivotalSigninUrl).queryParam("credentials[username]", new Object[]{credentials.getUserName()}).build(new Object[0]);
        HttpGet signInGet = new HttpGet(signInUri);
        HttpResponse response = this.authenticatedHttpClient.execute((HttpUriRequest)signInGet, this.httpContext);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new PivotalRemoteException("Failed to retrieve Pivotal sign-in form, authentication failed");
        }
        Matcher matcher = AUTHENTICITY_PATTERN.matcher(EntityUtils.toString((HttpEntity)response.getEntity()));
        if (!matcher.find()) {
            throw new PivotalRemoteException("Authenticity token not found in Pivotal sign-in form, authentication failed");
        }
        return matcher.group(1);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Element getWithToken(URI uri) throws PivotalRemoteException {
        Element element;
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpGet getMethod = new HttpGet(uri.toString());
        getMethod.addHeader("X-TrackerToken", this.token);
        InputStream is = null;
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)getMethod, this.httpContext);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new PivotalRemoteException("HTTP Error code " + response + " returned by Pivotal Tracker");
            }
            is = response.getEntity().getContent();
            if (is == null) {
                throw new PivotalRemoteException("Login failed. Empty response returned by Pivotal Tracker");
            }
            Document document = XmlUtil.getSAXBuilder().build(is);
            element = document.getRootElement();
        }
        catch (PivotalRemoteException e) {
            try {
                throw e;
                catch (IOException e2) {
                    throw new PivotalRemoteException(e2);
                }
                catch (JDOMException e3) {
                    throw new PivotalRemoteException(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return element;
    }

    private DefaultHttpClient getHttpClient() {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpDownloader.setDefaultProxy(client);
        return client;
    }

    public List<String> getAllProjectNames() throws PivotalRemoteException {
        List<ExternalProject> allProjects = this.getAllProjects(UserNameMapper.NO_MAPPING);
        return Lists.transform(allProjects, (Function)NamedExternalObject.NAME_FUNCTION);
    }

    public List<ExternalProject> getAllProjects(ImportLogger log) throws PivotalRemoteException {
        return this.getAllProjects(this.userNameMapper);
    }

    private List<ExternalProject> getAllProjects(UserNameMapper userNameMapper) throws PivotalRemoteException {
        URI uri = UriBuilder.fromUri((URI)this.rootUri).path("projects").build(new Object[0]);
        Element projects = this.getWithToken(uri);
        return new ProjectParser(userNameMapper).getProjects(projects);
    }

    public List<ExternalIssue> getStories(String projectId, ImportLogger importLogger) throws PivotalRemoteException {
        int paginationLimit = this.storyPaginationLimit;
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.rootUri).path("projects").path(projectId).path("stories").queryParam("limit", new Object[]{paginationLimit});
        StoryParser storyParser = new StoryParser(this.userNameMapper);
        ArrayList stories = Lists.newArrayList();
        int offset = 0;
        while (true) {
            importLogger.log("Retrieving Pivotal stories (%d to %d).", offset, offset + paginationLimit - 1);
            URI uri = uriBuilder.replaceQueryParam("offset", new Object[]{offset}).build(new Object[0]);
            List<ExternalIssue> storiesPage = storyParser.parseStories(this.getWithToken(uri));
            stories.addAll(storiesPage);
            if (storiesPage.size() != paginationLimit) break;
            offset += paginationLimit;
        }
        importLogger.log("Retrieved in total %d Pivotal stories.", stories.size());
        return stories;
    }

    public List<PivotalIteration> getIterations(String projectId, ImportLogger importLogger) throws PivotalRemoteException {
        URI uri = UriBuilder.fromUri((URI)this.rootUri).path("projects").path(projectId).path("iterations").build(new Object[0]);
        Element projects = this.getWithToken(uri);
        return new IterationParser(this.userNameMapper).parseIterations(projects);
    }

    public List<ExternalUser> getMembers(String projectId, ImportLogger importLogger) throws PivotalRemoteException {
        URI uri = UriBuilder.fromUri((URI)this.rootUri).path("projects").path(projectId).path("memberships").build(new Object[0]);
        Element memberships = this.getWithToken(uri);
        return new ProjectMembershipParser(this.userNameMapper).parseUsers(projectId, memberships);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExternalWorklog> getWorklog(long projectId, ImportLogger importLogger) throws IOException {
        HttpGet timeShiftsGet = new HttpGet(this.pivotalTimeshiftsUrl + "?" + URLEncodedUtils.format((List)Lists.newArrayList((Object[])new NameValuePair[]{new BasicNameValuePair("date_period[start]", "1/1/1990"), new BasicNameValuePair("date_period[finish]", "1/1/2100"), new BasicNameValuePair("project", String.valueOf(projectId)), new BasicNameValuePair("person", "none"), new BasicNameValuePair("grouped_by", "none"), new BasicNameValuePair("commit", "Export to CSV")}), (String)"UTF-8"));
        HttpResponse response = this.executeWithLogin(timeShiftsGet);
        try {
            String contentType;
            if (this.pivotalNotAllowedUrl.equals(this.getRedirectLocation(response))) {
                importLogger.log("Time tracking is not enabled for this account in Pivotal Tracker, skipping.", new Object[0]);
                List<ExternalWorklog> list = Collections.emptyList();
                return list;
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                importLogger.fail(null, "Error downloading time tracking information from Pivotal Tracker: %s", response.getStatusLine().toString());
                List<ExternalWorklog> list = Collections.emptyList();
                return list;
            }
            Header header = response.getEntity().getContentType();
            String string = contentType = header != null ? header.getValue() : null;
            if (!StringUtils.startsWithIgnoreCase((String)contentType, (String)"text/csv")) {
                importLogger.fail(null, "Error downloading time tracking information from Pivotal Tracker: expected text/csv content type; got %s", contentType);
                List<ExternalWorklog> list = Collections.emptyList();
                return list;
            }
            List<ExternalWorklog> list = new PivotalTimeShiftsParser(EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"), this.userNameMapper).parseWorklog();
            return list;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    public boolean isLoggedIn() {
        return this.token != null;
    }

    public Collection<ExternalAttachment> getAttachmentsForIssue(ExternalIssue externalIssue, ImportLogger log) {
        List<ExternalAttachment> externalAttachments = externalIssue.getAttachments();
        ArrayList result = Lists.newArrayListWithCapacity((int)externalAttachments.size());
        for (ExternalAttachment attachment : externalAttachments) {
            PivotalExternalAttachment pivotalAttachment = (PivotalExternalAttachment)attachment;
            if (StringUtils.isBlank((String)pivotalAttachment.getUrl())) {
                log.warn("Attachment URL missing for attachment '%s' in Pivotal Story '%s'; skipping.", attachment.getName(), externalIssue.getExternalId());
                continue;
            }
            try {
                File file = File.createTempFile("pivotalAttachment-", ".tmp", this.getTempDir());
                this.download(pivotalAttachment.getUrl(), file);
                pivotalAttachment.setAttachment(file);
                result.add(pivotalAttachment);
            }
            catch (Exception e) {
                log.fail(e, "Error retrieving attachment '%s' from '%s' for Pivotal Story '%s'", attachment.getName(), pivotalAttachment.getUrl(), externalIssue.getExternalId());
            }
        }
        return result;
    }

    protected File getTempDir() {
        return AttachmentUtils.getTemporaryAttachmentDirectory();
    }

    @Nullable
    private String getRedirectLocation(HttpResponse response) {
        if (response.getStatusLine().getStatusCode() != 302) {
            return null;
        }
        Header location = response.getFirstHeader("location");
        return location == null ? null : location.getValue();
    }

    public void setStoryPaginationLimit(int storyPaginationLimit) {
        if (storyPaginationLimit < 1 || storyPaginationLimit > 3000) {
            throw new IllegalArgumentException("Pagination limit must be between 1 and 3000");
        }
        this.storyPaginationLimit = storyPaginationLimit;
    }
}

