/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.pivotal;

import com.atlassian.jira.plugins.importer.XmlUtil;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.imports.config.UserNameMapper;
import com.atlassian.jira.plugins.importer.imports.pivotal.PivotalIteration;
import com.atlassian.jira.plugins.importer.imports.pivotal.StoryParser;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.jdom.Element;
import org.joda.time.DateTime;

public class IterationParser {
    private final StoryParser storyParser;

    public IterationParser(UserNameMapper userNameMapper) {
        this.storyParser = new StoryParser(userNameMapper);
    }

    public List<PivotalIteration> parseIterations(@Nullable Element iterations) {
        return Lists.newArrayList((Iterable)Collections2.transform(XmlUtil.getChildren(iterations, "iteration"), (Function)new Function<Element, PivotalIteration>(){

            public PivotalIteration apply(Element from) {
                return IterationParser.this.parseIteration(from);
            }
        }));
    }

    protected PivotalIteration parseIteration(Element from) {
        String number = from.getChildTextTrim("number");
        DateTime start = this.storyParser.parseDateTime(from.getChildTextTrim("start"));
        DateTime finish = this.storyParser.parseDateTime(from.getChildTextTrim("finish"));
        List<ExternalIssue> issues = this.storyParser.parseStories(from.getChild("stories"));
        return new PivotalIteration(number, start, finish, issues);
    }
}

