/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.imports.AbstractResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisConfigBean;
import com.opensymphony.util.TextUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class UserTransformer
extends AbstractResultSetTransformer<ExternalUser> {
    private final MantisConfigBean configBean;

    public UserTransformer(MantisConfigBean configBean, ImportLogger log) {
        super(log);
        this.configBean = configBean;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT id, username, realname, email, enabled FROM mantis_user_table";
    }

    @Override
    public ExternalUser transform(ResultSet rs) throws SQLException {
        String fullName = TextUtils.noNull((String)rs.getString("realname"));
        String email = TextUtils.noNull((String)rs.getString("email"));
        String username = this.configBean.getUsernameForLoginName(rs.getString("username"));
        boolean active = rs.getBoolean("enabled");
        if (StringUtils.isBlank((String)username)) {
            this.log.warn("Username is blank and is not imported", new Object[0]);
            return null;
        }
        ExternalUser user = new ExternalUser(username, StringUtils.isEmpty((String)fullName) ? this.getFullNameFromEmail(email) : fullName, email);
        if (!active) {
            user.setActive(false);
            user.getGroups().add(this.configBean.getInactiveUsersGroup());
        }
        return user;
    }

    public String getFullNameFromEmail(String email) {
        if (email == null) {
            return "";
        }
        int index = email.indexOf("@");
        if (index != -1) {
            return email.substring(0, index);
        }
        return "";
    }

    public MantisConfigBean getConfigBean() {
        return this.configBean;
    }
}

