/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis.transformer;

import com.atlassian.jira.plugins.importer.SqlUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisConfigBean;
import com.atlassian.jira.plugins.importer.imports.mantis.transformer.UserTransformer;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class RequiredUserTransformer
extends UserTransformer {
    private final Collection<ExternalProject> projects;

    public RequiredUserTransformer(MantisConfigBean configBean, Collection<ExternalProject> projects, ImportLogger log) {
        super(configBean, log);
        this.projects = projects;
    }

    @Override
    public String getSqlQuery() {
        if (this.projects.size() == 0) {
            return super.getSqlQuery();
        }
        String projectIds = SqlUtils.comma(this.projects);
        String fields = "SELECT u.id,username,realname,email,enabled FROM mantis_user_table AS u JOIN ";
        String union = StringUtils.containsIgnoreCase((String)this.getConfigBean().getJdbcConnection().getDriverName(), (String)"jtds") ? " UNION " : " UNION DISTINCT ";
        return "SELECT u.id,username,realname,email,enabled FROM mantis_user_table AS u JOIN mantis_bug_table AS b ON (b.reporter_id = u.id OR b.handler_id = u.id) WHERE project_id IN (" + projectIds + ")" + union + "SELECT u.id,username,realname,email,enabled FROM mantis_user_table AS u JOIN " + "mantis_bugnote_table AS n ON (n.reporter_id = u.id) JOIN mantis_bug_table AS b ON (n.bug_id = b.id) WHERE b.project_id IN (" + projectIds + ")" + union + "SELECT u.id,username,realname,email,enabled FROM mantis_user_table AS u JOIN " + "mantis_bug_monitor_table AS m ON (m.user_id = u.id) JOIN mantis_bug_table AS b ON (m.bug_id = b.id) WHERE b.project_id IN (" + projectIds + ")";
    }
}

