/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisConfigBean;
import com.google.common.base.Joiner;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LinksTransformer
implements ResultSetTransformer<ExternalLink> {
    private final MantisConfigBean configBean;
    private final Iterable<String> importedProjectIds;

    public LinksTransformer(MantisConfigBean configBean, Iterable<String> importedProjectIds) {
        this.configBean = configBean;
        this.importedProjectIds = importedProjectIds;
    }

    @Override
    public String getSqlQuery() {
        String projectIds = Joiner.on((String)", ").join(this.importedProjectIds);
        return "SELECT r.source_bug_id,r.destination_bug_id,r.relationship_type FROM mantis_bug_relationship_table r LEFT JOIN mantis_bug_table b1 ON r.source_bug_id = b1.id LEFT JOIN mantis_bug_table b2 ON r.destination_bug_id = b2.id WHERE b1.project_id IN (" + projectIds + ") AND b2.project_id IN (" + projectIds + ")";
    }

    @Override
    public ExternalLink transform(ResultSet rs) throws SQLException {
        return new ExternalLink(this.configBean.getLinkMapping(this.getLinkName(rs.getInt("relationship_type"))), rs.getString("source_bug_id"), rs.getString("destination_bug_id"));
    }

    private String getLinkName(int relType) {
        switch (relType) {
            case 2: {
                return "Parent of / Child of";
            }
            case 1: {
                return "Related to";
            }
            case 0: {
                return "Duplicate of / Has duplicate";
            }
        }
        return "Unknown link type";
    }
}

