/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis.transformer;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.plugins.importer.EmptyStreamException;
import com.atlassian.jira.plugins.importer.FileCopyUtil;
import com.atlassian.jira.plugins.importer.NotEmptyInputStream;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.imports.AbstractAttachmentTransformer;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.mantis.CredentialsRequiredException;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisClient;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisConfigBean;
import com.atlassian.jira.plugins.importer.web.SiteConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AttachmentTransformer
extends AbstractAttachmentTransformer {
    private static final Logger logger = Logger.getLogger(AttachmentTransformer.class);
    private final ImportLogger log;
    protected final String ixBug;
    private MantisClient mantisClient;
    private MantisConfigBean.TimestampHelper timestampHelper;
    private final MantisConfigBean configBean;

    public AttachmentTransformer(MantisConfigBean configBean, String ixBug, SiteConfiguration mantisUrl, ImportLogger log) {
        this.configBean = configBean;
        this.ixBug = ixBug;
        this.timestampHelper = new MantisConfigBean.TimestampHelper();
        this.log = log;
        this.mantisClient = new MantisClient(mantisUrl);
        try {
            Integer.parseInt(ixBug);
        }
        catch (NumberFormatException e) {
            log.fail(e, "Passed Mantis id ('%s') is not a number", ixBug);
        }
    }

    @Override
    public String getSqlQuery() {
        return "SELECT f.id, f.filename, f.file_type, f.content, f.date_added, f.description, u.username FROM mantis_bug_file_table f LEFT JOIN mantis_user_table u ON f.user_id = u.id WHERE bug_id = " + this.ixBug + " ORDER BY date_added ASC";
    }

    @Override
    public ExternalAttachment transform(ResultSet rs) throws SQLException {
        ExternalAttachment externalAttachment = null;
        String fileName = rs.getString("filename");
        if (StringUtils.isNotBlank((String)fileName)) {
            try {
                File file = this.copyAttachment(rs);
                externalAttachment = new ExternalAttachment(fileName, file, this.timestampHelper.getTimestamp(rs, "date_added"));
                externalAttachment.setAttacher(this.getAuthor(rs));
                externalAttachment.setDescription(rs.getString("description"));
            }
            catch (DataAccessException e) {
                this.log.fail(e, "Can't get attachment details", new Object[0]);
                return null;
            }
            catch (CredentialsRequiredException e) {
                this.log.fail(e, "Credentials are required to download attachments", new Object[0]);
                return null;
            }
        }
        return externalAttachment;
    }

    protected String getAuthor(ResultSet rs) throws SQLException {
        return this.configBean.getUsernameForLoginName(rs.getString("username"));
    }

    /*
     * Loose catch block
     */
    protected File copyAttachment(ResultSet rs) throws SQLException {
        File file;
        NotEmptyInputStream contentStream = null;
        File file2 = null;
        try {
            contentStream = new NotEmptyInputStream(rs.getBinaryStream("content"));
            file2 = this.getTempFile();
            FileCopyUtil.copy(contentStream, file2);
            file = file2;
        }
        catch (EmptyStreamException e) {
            this.deleteFile(file2);
            File file3 = this.downloadAttachment(rs.getString("id"));
            IOUtils.closeQuietly((InputStream)contentStream);
            return file3;
        }
        catch (IOException e2) {
            this.deleteFile(file2);
            throw new DataAccessException("Exception occurred dealing with attachment.", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(contentStream);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)contentStream);
        return file;
    }

    private void deleteFile(File file) {
        if (file != null && !file.delete()) {
            logger.warn((Object)("Could not delete temporary file: " + file));
        }
    }

    protected File downloadAttachment(String attachId) throws SQLException {
        try {
            if (this.mantisClient.getUrlBean().isUseCredentials() && !this.mantisClient.isAuthenticated()) {
                this.mantisClient.login();
            }
            return this.mantisClient.getAttachment(this.ixBug, attachId);
        }
        catch (IOException e) {
            throw new DataAccessException("Exception occurred dealing with attachment.", (Throwable)e);
        }
    }
}

