/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis.config;

import com.atlassian.jira.plugins.importer.imports.AbstractStatusValueMapper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisFieldConstants;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public class StatusValueMapper
extends AbstractStatusValueMapper {
    public static final String FIELD = "status";

    public StatusValueMapper(JdbcConnection jdbcConnection, JiraAuthenticationContext authenticationContext, AbstractConfigBean2 configBean) {
        super(jdbcConnection, authenticationContext, configBean);
    }

    @Override
    public String getExternalFieldId() {
        return FIELD;
    }

    @Override
    public String getDescription() {
        return this.getI18n().getText("jira-importer-plugin.config.mantis.mappings.value.status");
    }

    @Override
    public String getSqlQuery() {
        return "SELECT DISTINCT status FROM mantis_bug_table";
    }

    @Override
    public String transformStatus(String status) {
        return MantisFieldConstants.getStatusName(status);
    }

    @Override
    public Collection<ValueMappingEntry> getDefaultValues() {
        return ImmutableList.builder().add((Object[])new ValueMappingEntry[]{new ValueMappingEntry("new", 1), new ValueMappingEntry("feedback", 1), new ValueMappingEntry("acknowledged", 1), new ValueMappingEntry("confirmed", 1), new ValueMappingEntry("assigned", 3), new ValueMappingEntry("resolved", 5), new ValueMappingEntry("closed", 6)}).build();
    }
}

