/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis.config;

import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.imports.AbstractPriorityValueMapper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisFieldConstants;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Set;

public class SeverityToPriorityValueMapper
extends AbstractPriorityValueMapper {
    private final ExternalCustomField customField;

    public SeverityToPriorityValueMapper(JdbcConnection jdbcConnection, JiraAuthenticationContext authenticationContext, FieldManager fieldManager, ExternalCustomField customField) {
        super(jdbcConnection, authenticationContext, fieldManager);
        this.customField = customField;
    }

    @Override
    public String getExternalFieldId() {
        return this.customField.getId();
    }

    @Override
    public String getDescription() {
        return this.getI18n().getText("jira-importer-plugin.config.mantis.mappings.value.severity");
    }

    @Override
    public Set<String> getDistinctValues() {
        return Sets.newTreeSet(this.jdbcConnection.queryDb(new SeverityTransformer()));
    }

    @Override
    public Collection<ValueMappingEntry> getDefaultValues() {
        return new ImmutableList.Builder().add((Object[])new ValueMappingEntry[]{new ValueMappingEntry("block", 1), new ValueMappingEntry("crash", 2), new ValueMappingEntry("feature", 3), new ValueMappingEntry("major", 3), new ValueMappingEntry("minor", 4), new ValueMappingEntry("tweak", 4), new ValueMappingEntry("text", 5), new ValueMappingEntry("trivial", 5)}).build();
    }

    static class SeverityTransformer
    implements ResultSetTransformer<String> {
        SeverityTransformer() {
        }

        @Override
        public String getSqlQuery() {
            return "SELECT DISTINCT severity FROM mantis_bug_table ORDER BY severity";
        }

        @Override
        public String transform(ResultSet rs) throws SQLException {
            return MantisFieldConstants.getSeverityName(rs.getString(1));
        }
    }
}

