/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis.config;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinitionsFactory;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.imports.mantis.MantisConfigBean;
import com.atlassian.jira.plugins.importer.imports.mantis.config.CustomFieldValueMapper;
import com.atlassian.jira.plugins.importer.imports.mantis.config.LoginNameValueMapper;
import com.atlassian.jira.plugins.importer.imports.mantis.config.MultipleSelectionValueMapper;
import com.atlassian.jira.plugins.importer.imports.mantis.config.PriorityToPriorityValueMapper;
import com.atlassian.jira.plugins.importer.imports.mantis.config.PriorityValueMapper;
import com.atlassian.jira.plugins.importer.imports.mantis.config.ResolutionValueMapper;
import com.atlassian.jira.plugins.importer.imports.mantis.config.SeverityToIssueTypeValueMapper;
import com.atlassian.jira.plugins.importer.imports.mantis.config.SeverityToPriorityValueMapper;
import com.atlassian.jira.plugins.importer.imports.mantis.config.SeverityValueMapper;
import com.atlassian.jira.plugins.importer.imports.mantis.config.StatusValueMapper;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class MantisValueMappingDefinitionsFactory
implements ValueMappingDefinitionsFactory {
    private final JiraAuthenticationContext authenticationContext;
    private final ConstantsManager constantsManager;
    private final MantisConfigBean configBean;
    private final FieldManager fieldManager;

    public MantisValueMappingDefinitionsFactory(JiraAuthenticationContext authenticationContext, ConstantsManager constantsManager, MantisConfigBean configBean, FieldManager fieldManager) {
        this.authenticationContext = authenticationContext;
        this.constantsManager = constantsManager;
        this.configBean = configBean;
        this.fieldManager = fieldManager;
    }

    @Override
    public List<ValueMappingDefinition> createMappingDefinitions(ValueMappingHelper valueMappingHelper) {
        JdbcConnection jdbcConnection = this.configBean.getJdbcConnection();
        ArrayList mappings = Lists.newArrayList((Object[])new ValueMappingDefinition[]{new SeverityToIssueTypeValueMapper(jdbcConnection, this.authenticationContext, this.constantsManager), new LoginNameValueMapper(jdbcConnection, this.authenticationContext), new StatusValueMapper(jdbcConnection, this.authenticationContext, this.configBean), new ResolutionValueMapper(jdbcConnection, this.authenticationContext, this.constantsManager)});
        for (ExternalCustomField customField : this.configBean.getCustomFields()) {
            String type = customField.getTypeKey();
            if ("severity".equals(customField.getId())) {
                if (this.configBean.isFieldMappedToIssueField("severity")) {
                    mappings.add(new SeverityToPriorityValueMapper(jdbcConnection, this.authenticationContext, this.fieldManager, customField));
                    continue;
                }
                mappings.add(new SeverityValueMapper(this.configBean, this.authenticationContext, customField));
                continue;
            }
            if ("priority".equals(customField.getId())) {
                if (this.configBean.isFieldMappedToIssueField("priority")) {
                    mappings.add(new PriorityToPriorityValueMapper(this.configBean, this.authenticationContext, this.fieldManager, customField));
                    continue;
                }
                mappings.add(new PriorityValueMapper(this.configBean, this.authenticationContext, customField));
                continue;
            }
            if ("com.atlassian.jira.plugin.system.customfieldtypes:multiselect".equals(type) || "com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes".equals(type)) {
                mappings.add(new MultipleSelectionValueMapper(this.configBean, this.authenticationContext, customField));
            }
            if (!"com.atlassian.jira.plugin.system.customfieldtypes:select".equals(type)) continue;
            mappings.add(new CustomFieldValueMapper(jdbcConnection, this.authenticationContext, customField));
        }
        return mappings;
    }
}

