/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.mantis;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.plugins.importer.imports.HttpDownloader;
import com.atlassian.jira.plugins.importer.imports.mantis.CredentialsRequiredException;
import com.atlassian.jira.plugins.importer.web.SiteConfiguration;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class MantisClient
extends HttpDownloader {
    private final SiteConfiguration urlBean;
    private final Pattern footerRegex;
    private boolean logged;
    private HttpContext httpContext;

    public MantisClient(SiteConfiguration urlBean) {
        this.urlBean = urlBean;
        this.footerRegex = Pattern.compile("Mantis[BT]{2} Group");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> validateUrl() {
        DefaultHttpClient client = this.createHttpClient();
        HttpHead get = new HttpHead(this.urlBean.getUrl() + "/main_page.php");
        try {
            HttpResponse status = client.execute((HttpUriRequest)get);
            try {
                if (status.getStatusLine().getStatusCode() == 200) {
                    if (status.getFirstHeader("refresh") != null) {
                        Map map = MapBuilder.build((Object)this.getI18nBean().getText("jira-importer-plugin.external.mantis.uses.iis.mode"), (Object)this.getI18nBean().getText("jira-importer-plugin.external.mantis.uses.iis.mode.hint"));
                        return map;
                    }
                    Map<String, String> map = Collections.emptyMap();
                    return map;
                }
                Map map = MapBuilder.build((Object)this.getI18nBean().getText("jira-importer-plugin.external.mantis.site.url.notdetected"), (Object)this.getI18nBean().getText("jira-importer-plugin.importer.site.url.httperrorcode", Integer.toString(status.getStatusLine().getStatusCode()), get.getURI().toString()));
                return map;
            }
            finally {
                EntityUtils.consume((HttpEntity)status.getEntity());
            }
        }
        catch (Exception e) {
            return MapBuilder.build((Object)this.getI18nBean().getText("jira-importer-plugin.importer.site.connection.failed", this.urlBean.getUrl(), e.getMessage()), null);
        }
    }

    public File getAttachment(String ixBug, String attachId) throws IOException {
        String attachUrl = this.urlBean.getUrl() + "/file_download.php?type=bug&file_id=" + attachId;
        return this.getAttachmentFromUrl(this.httpContext, ixBug, attachUrl);
    }

    @Override
    protected void validateAttachment(String ixBug, HttpResponse get, File file) throws IOException {
        if (this.isTextHtml(get) && this.containsLoginPage(file, this.getEncoding(get))) {
            throw new CredentialsRequiredException(ixBug);
        }
    }

    private boolean isTextHtml(HttpResponse get) {
        try {
            ContentType contentType = ContentType.getOrDefault((HttpEntity)get.getEntity());
            return contentType.getMimeType().startsWith("text/html");
        }
        catch (ParseException parseException) {
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        return false;
    }

    private String getEncoding(HttpResponse get) {
        try {
            ContentType contentType = ContentType.getOrDefault((HttpEntity)get.getEntity());
            Charset charset = contentType.getCharset();
            if (charset != null) {
                return charset.toString();
            }
        }
        catch (ParseException parseException) {
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        return this.client.getParams().getParameter("http.protocol.content-charset").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsLoginPage(File file, String encoding) throws IOException {
        boolean bl;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            LineIterator lineIterator = IOUtils.lineIterator((InputStream)inputStream, (String)encoding);
            boolean title = false;
            boolean logo = false;
            boolean passwordInput = false;
            boolean footer = false;
            while (lineIterator.hasNext()) {
                String line = lineIterator.nextLine();
                title |= line.contains("<title>Mantis");
                logo |= line.contains("alt=\"Mantis");
                passwordInput |= line.contains("type=\"password\"");
                footer |= this.footerRegex.matcher(line).find();
            }
            bl = title && logo && passwordInput && footer;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return bl;
    }

    public void login() throws IOException {
        if (!this.logged) {
            this.httpContext = this.createHttpContext();
            String error = this.doLogin(this.client, this.httpContext);
            if (error != null) {
                throw new IOException(error);
            }
            this.logged = true;
        }
    }

    public void logout() throws IOException {
        this.logged = false;
        this.httpContext = null;
        this.client.getConnectionManager().shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String doLogin(DefaultHttpClient client, HttpContext httpContext) {
        HttpPost post = new HttpPost(this.urlBean.getUrl() + "/login.php");
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity((List)Lists.newArrayList((Object[])new NameValuePair[]{new BasicNameValuePair("username", this.urlBean.getUsername()), new BasicNameValuePair("password", this.urlBean.getPassword()), new BasicNameValuePair("secure_session", "on"), new BasicNameValuePair("return", "index.php")}));
            post.setEntity((HttpEntity)entity);
            HttpResponse status = client.execute((HttpUriRequest)post, httpContext);
            try {
                if (status.getStatusLine().getStatusCode() == 302) {
                    if (status.getFirstHeader("Location") != null && status.getFirstHeader("Location").getValue().contains("login_cookie_test.php?return=")) {
                        String string = null;
                        return string;
                    }
                    String string = this.getI18nBean().getText("jira-importer-plugin.importer.site.credentials.invalid");
                    return string;
                }
                String string = this.getI18nBean().getText("jira-importer-plugin.importer.site.url.httperrorcode") + " " + status;
                return string;
            }
            finally {
                EntityUtils.consume((HttpEntity)status.getEntity());
            }
        }
        catch (Exception e) {
            return this.getI18nBean().getText("jira-importer-plugin.importer.site.connection.failed", this.urlBean.getUrl(), e.getMessage());
        }
    }

    public String validateCredentials() {
        return this.doLogin(this.createHttpClient(), this.createHttpContext());
    }

    protected I18nHelper getI18nBean() {
        return ((JiraAuthenticationContext)ComponentManager.getComponent(JiraAuthenticationContext.class)).getI18nHelper();
    }

    public Map<String, String> validateConnection() {
        String error;
        HashMap errors = Maps.newHashMap();
        errors.putAll(this.validateUrl());
        if (errors.isEmpty() && this.urlBean.isUseCredentials() && (error = this.validateCredentials()) != null) {
            errors.put(error, null);
        }
        return errors;
    }

    public SiteConfiguration getUrlBean() {
        return this.urlBean;
    }

    public boolean isAuthenticated() {
        return this.logged;
    }
}

