/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.json.rest;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporterFactory;
import com.atlassian.jira.plugins.importer.imports.importer.impl.DefaultAvatarsProvider;
import com.atlassian.jira.plugins.importer.imports.importer.services.ImporterExecutionInfo;
import com.atlassian.jira.plugins.importer.imports.importer.services.ImporterExecutionService;
import com.atlassian.jira.plugins.importer.imports.json.JsonAttachmentsProvider;
import com.atlassian.jira.plugins.importer.imports.json.rest.JsonRestImportService;
import com.atlassian.jira.plugins.importer.sample.SampleData;
import com.atlassian.jira.plugins.importer.sample.SampleDataBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class JsonRestImportServiceImpl
implements JsonRestImportService {
    public static final String IMPORTER_NAME = "JSON-REST";
    private final JiraHome jiraHome;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ConstantsManager constantsManager;
    private final JiraDataImporterFactory jiraDataImporterFactory;
    private final ImporterExecutionService importerExecutionService;

    @Autowired
    public JsonRestImportServiceImpl(@ComponentImport JiraHome jiraHome, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport ConstantsManager constantsManager, JiraDataImporterFactory jiraDataImporterFactory, @Qualifier(value="perUserPerImporter") ImporterExecutionService importerExecutionService) {
        this.jiraHome = jiraHome;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.constantsManager = constantsManager;
        this.jiraDataImporterFactory = jiraDataImporterFactory;
        this.importerExecutionService = importerExecutionService;
    }

    @Override
    public boolean isImporterRunning(ApplicationUser user) {
        return this.importerExecutionService.isImporterRunning(IMPORTER_NAME, user);
    }

    @Override
    public synchronized Optional<UUID> startImport(ApplicationUser user, SampleData sampleData) {
        SampleDataBean sampleDataBean = new SampleDataBean(this.jiraAuthenticationContext, this.constantsManager, sampleData, new JsonAttachmentsProvider(this.jiraHome), new DefaultAvatarsProvider(this.jiraHome), null);
        JiraDataImporter importer = this.jiraDataImporterFactory.create();
        importer.initializeLog();
        importer.setDataBean(sampleDataBean);
        return this.importerExecutionService.startImport(IMPORTER_NAME, user, importer);
    }

    @Override
    public Optional<JiraDataImporter> getImporter(UUID uuid, ApplicationUser user) {
        Optional<ImporterExecutionInfo> infoForImport = this.importerExecutionService.getInfoForImport(uuid);
        if (infoForImport.isPresent() && ((ImporterExecutionInfo)infoForImport.get()).getUser().equals((Object)user)) {
            return this.importerExecutionService.getImporter(uuid);
        }
        return Optional.absent();
    }
}

