/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.json;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.imports.importer.impl.DefaultAvatarsProvider;
import com.atlassian.jira.plugins.importer.imports.json.JsonAttachmentsProvider;
import com.atlassian.jira.plugins.importer.imports.json.web.JsonSetupPage;
import com.atlassian.jira.plugins.importer.sample.SampleData;
import com.atlassian.jira.plugins.importer.sample.SampleDataImporter2;
import com.atlassian.jira.plugins.importer.web.AbstractImporterController;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import webwork.action.ActionContext;

public class JsonImporterController
extends AbstractImporterController {
    private static final String IMPORT_BEAN_SESSION_ATTRIBUTE = "issue.importer.jira.json.import.bean";
    private static final String IMPORT_FILE_SESSION_ATTRIBUTE = "issue.importer.jira.json.import.file";
    private final SampleDataImporter2 sampleDataImporter;
    private final JiraHome jiraHome;

    public JsonImporterController(JiraDataImporter importer, SampleDataImporter2 sampleDataImporter, @ComponentImport JiraHome jiraHome) {
        super(importer, IMPORT_BEAN_SESSION_ATTRIBUTE, "JSON");
        this.sampleDataImporter = sampleDataImporter;
        this.jiraHome = jiraHome;
    }

    @Override
    public boolean createImportProcessBean(AbstractSetupPage setupPage) {
        JsonSetupPage jsonSetupPage = (JsonSetupPage)setupPage;
        this.storeImportProcessBeanInSession(new ImportProcessBean());
        try {
            ActionContext.getSession().put(IMPORT_FILE_SESSION_ATTRIBUTE, FileUtils.readFileToString((File)jsonSetupPage.getTempAttachment().getFile()));
            return true;
        }
        catch (IOException e) {
            setupPage.addErrorMessage(e.getMessage());
            return false;
        }
    }

    @Override
    public ImportDataBean createDataBean() throws Exception {
        String json = (String)ActionContext.getSession().get(IMPORT_FILE_SESSION_ATTRIBUTE);
        SampleData sampleData = this.sampleDataImporter.parseSampleData(json);
        return this.sampleDataImporter.createDataBean(sampleData, null, new JsonAttachmentsProvider(this.jiraHome), new DefaultAvatarsProvider(this.jiraHome));
    }

    @Override
    public List<String> getSteps() {
        return Lists.newArrayList((Object[])new String[]{JsonSetupPage.class.getSimpleName()});
    }

    @Override
    public List<String> getStepNameKeys() {
        return Lists.newArrayList((Object[])new String[]{"jira-importer-plugin.wizard.step.JsonSetupPage"});
    }

    @Override
    public boolean isUsingConfiguration() {
        return false;
    }
}

