/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.json;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.imports.AttachmentImportException;
import com.atlassian.jira.plugins.importer.imports.AttachmentImporter;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.sample.AttachmentsProvider;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import javax.annotation.Nonnull;

public class JsonAttachmentsProvider
implements AttachmentsProvider {
    private final JiraHome jiraHome;

    public JsonAttachmentsProvider(JiraHome jiraHome) {
        this.jiraHome = jiraHome;
    }

    @Override
    @Nonnull
    public File getAttachmentForIssue(ExternalIssue externalIssue, final String name, ImportLogger log) {
        AttachmentImporter attachmentImporter = new AttachmentImporter(this.jiraHome, externalIssue);
        ExternalAttachment attachment = (ExternalAttachment)Iterables.find(externalIssue.getAttachments(), (Predicate)new Predicate<ExternalAttachment>(){

            public boolean apply(ExternalAttachment input) {
                return input.getName().equals(name);
            }
        });
        try {
            attachment.setAttachment(attachmentImporter.importAttachmentFrom(attachment));
            return attachment.getAttachment();
        }
        catch (IOException e) {
            String message = String.format("An exception occurred dealing with attachment '%s'.", attachment.getUri());
            throw new AttachmentImportException(message, e);
        }
        catch (ParseException e) {
            String message = String.format("Cannot parse '%s' as attachment info: %s", attachment.getAttachment(), e.getMessage());
            throw new AttachmentImportException(message, e);
        }
    }
}

