/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer.services;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugins.importer.analytics.ImporterFinishedEvent;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ImporterCallable;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ImporterExecutionContext;
import com.atlassian.jira.plugins.importer.imports.importer.services.ImporterExecutionInfo;
import com.atlassian.jira.plugins.importer.imports.importer.services.ImporterExecutionService;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="perUserPerImporter")
public class PerUserAndImporterService
implements ImporterExecutionService {
    public static final String TASK_DESCRIPTION = "JIRA Importers Plugin - Running importer";
    private final TaskManager taskManager;
    private final Map<UUID, JiraDataImporter> runningImports = new ConcurrentHashMap<UUID, JiraDataImporter>();
    private final Cache<UUID, JiraDataImporter> cachedResults;
    private final Map<ImporterExecutionInfo, UUID> importerUserToUUID = new ConcurrentHashMap<ImporterExecutionInfo, UUID>();
    private final CompatibilityBridgeUtils bridgeUtils;

    @Autowired
    public PerUserAndImporterService(@ComponentImport TaskManager taskManager, @ComponentImport EventPublisher eventPublisher, CompatibilityBridgeUtils bridgeUtils) {
        this.taskManager = taskManager;
        this.bridgeUtils = bridgeUtils;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<UUID, JiraDataImporter>(){

            public void onRemoval(RemovalNotification<UUID, JiraDataImporter> notification) {
                UUID uuid = (UUID)notification.getKey();
                Optional infoForUuid = PerUserAndImporterService.this.getInfoForUuid(uuid);
                if (!PerUserAndImporterService.this.isImporterRunning(uuid) && infoForUuid.isPresent()) {
                    PerUserAndImporterService.this.importerUserToUUID.remove(infoForUuid.get());
                }
            }
        });
        this.cachedResults = bridgeUtils.buildCache(cacheBuilder, new CacheLoader<UUID, JiraDataImporter>(){

            public JiraDataImporter load(UUID key) throws Exception {
                return (JiraDataImporter)PerUserAndImporterService.this.runningImports.get(key);
            }
        });
        eventPublisher.register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onImporterFinished(ImporterFinishedEvent event) {
        Optional<UUID> uuidForImporter = this.findUuidForImporter(event.getImporter());
        if (uuidForImporter.isPresent()) {
            UUID uuid = (UUID)uuidForImporter.get();
            this.cachedResults.invalidate((Object)uuid);
            this.bridgeUtils.getFromCache(this.cachedResults, uuid);
            PerUserAndImporterService perUserAndImporterService = this;
            synchronized (perUserAndImporterService) {
                this.runningImports.remove(uuid);
            }
        }
    }

    private Optional<UUID> findUuidForImporter(JiraDataImporter importer) {
        for (Map.Entry<UUID, JiraDataImporter> entry : this.runningImports.entrySet()) {
            if (importer != entry.getValue()) continue;
            return Optional.of((Object)entry.getKey());
        }
        return Optional.absent();
    }

    private Optional<ImporterExecutionInfo> getInfoForUuid(UUID uuid) {
        for (Map.Entry<ImporterExecutionInfo, UUID> entry : this.importerUserToUUID.entrySet()) {
            if (!uuid.equals(entry.getValue())) continue;
            return Optional.of((Object)entry.getKey());
        }
        return Optional.absent();
    }

    @Override
    public boolean isImporterRunning(String importerId, ApplicationUser user) {
        return this.isImporterRunning(this.findUUID(importerId, user));
    }

    @Override
    public boolean isImporterRunning(UUID importId) {
        return importId != null && this.runningImports.containsKey(importId);
    }

    @Override
    public synchronized Optional<UUID> startImport(String importerId, ApplicationUser user, JiraDataImporter importer) {
        if (this.isImporterRunning(importerId, user)) {
            return Optional.absent();
        }
        this.clearOldImport(importerId, user);
        ImporterCallable importerCallable = new ImporterCallable(importer, new ImporterExecutionContext(importerId, user));
        UUID uuid = UUID.randomUUID();
        this.runningImports.put(uuid, importer);
        this.importerUserToUUID.put(new ImporterExecutionInfo(user, importerId), uuid);
        this.taskManager.submitTask((Callable)importerCallable, TASK_DESCRIPTION, (TaskContext)new DummyTaskContext());
        return Optional.of((Object)uuid);
    }

    private void clearOldImport(String importerId, ApplicationUser user) {
        UUID lastUUID;
        while ((lastUUID = this.findUUID(importerId, user)) != null) {
            this.cachedResults.invalidate((Object)lastUUID);
        }
    }

    @Override
    public Optional<JiraDataImporter> getImporter(String importerId, ApplicationUser user) {
        return this.getImporter(this.findUUID(importerId, user));
    }

    @Override
    public Optional<JiraDataImporter> getImporter(UUID importId) {
        JiraDataImporter fromCache = this.bridgeUtils.getFromCache(this.cachedResults, importId);
        return Optional.fromNullable((Object)fromCache);
    }

    @Override
    public Optional<ImporterExecutionInfo> getInfoForImport(UUID importId) {
        return this.getInfoForUuid(importId);
    }

    private UUID findUUID(String importerId, ApplicationUser user) {
        return this.importerUserToUUID.get(new ImporterExecutionInfo(user, importerId));
    }

    private static class DummyTaskContext
    implements TaskContext {
        private DummyTaskContext() {
        }

        public String buildProgressURL(Long taskId) {
            return null;
        }
    }
}

