/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer.impl.customfields;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.plugins.importer.appbridge.software.JimJiraSoftwareAccessor;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CFValueHandler;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CFValueHandlerEpicLink;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CFValueHandlerMultiple;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CFValueHandlerNumber;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CFValueHandlerProject;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CFValueHandlerSLA;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CFValueHandlerSprint;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CFValueHandlerVersion;
import com.atlassian.jira.plugins.importer.sample.mapper.ObjectMapperFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomFieldValueFactory {
    private static final Logger log = LoggerFactory.getLogger(CustomFieldValueFactory.class);
    private final List<CFValueHandler> valueHandlers;

    @Autowired
    public CustomFieldValueFactory(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport VersionManager versionManager, @ComponentImport OptionsManager optionsManager, @ComponentImport ProjectManager projectManager, @ComponentImport CustomFieldManager customFieldManager, @ComponentImport SearchProvider searchProvider, JimJiraSoftwareAccessor jimJiraSoftwareAccessor, ObjectMapperFactory mapperFactory) {
        this.valueHandlers = ImmutableList.of((Object)new CFValueHandlerNumber(), (Object)new CFValueHandlerProject(projectManager), (Object)new CFValueHandlerVersion(versionManager), (Object)new CFValueHandlerMultiple(optionsManager), (Object)new CFValueHandlerEpicLink(jiraAuthenticationContext, customFieldManager, searchProvider, jimJiraSoftwareAccessor), (Object)new CFValueHandlerSprint(jimJiraSoftwareAccessor), (Object)new CFValueHandlerSLA(mapperFactory));
    }

    public Optional<Object> prepareValueForCustomField(CustomField customField, Issue issue, Collection<Object> values) {
        Optional<Object> preparedValue = this.prepareRawValueForCustomField(customField, issue, values);
        if (!preparedValue.isPresent()) {
            return Optional.absent();
        }
        CustomFieldParamsImpl customFieldParams = new CustomFieldParamsImpl(customField, preparedValue.get());
        CustomFieldType customFieldType = customField.getCustomFieldType();
        return Optional.fromNullable((Object)customFieldType.getValueFromCustomFieldParams((CustomFieldParams)customFieldParams));
    }

    public Optional<Object> prepareRawValueForCustomField(CustomField customField, Issue issue, Collection<Object> values) {
        Optional<Object> preparedValue = Optional.of(values);
        for (CFValueHandler valueHandler : this.valueHandlers) {
            if (!valueHandler.canHandleCustomField(customField, issue)) continue;
            preparedValue = valueHandler.prepareCustomFieldValue(customField, issue, values);
            break;
        }
        return preparedValue;
    }

    public Optional<Object> prepareValueForExport(CustomField customField, Issue issue) {
        for (CFValueHandler valueHandler : this.valueHandlers) {
            if (!valueHandler.canHandleCustomField(customField, issue)) continue;
            return valueHandler.exportValue(customField, issue);
        }
        Object issueValue = customField.getValue(issue);
        if (issueValue == null) {
            return Optional.absent();
        }
        CustomFieldType customFieldType = customField.getCustomFieldType();
        try {
            return Optional.fromNullable((Object)customFieldType.getStringFromSingularObject(issueValue));
        }
        catch (Exception e) {
            log.debug("Cannot extract value from field {} of type {}", (Object)customField, (Object)customFieldType);
            return Optional.absent();
        }
    }
}

