/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer.impl.customfields;

import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.importer.appbridge.servicedesk.ServiceDeskBridge;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CFValueHandler;
import com.atlassian.jira.plugins.importer.sample.mapper.ObjectMapperFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFValueHandlerSLA
implements CFValueHandler {
    private static final Logger log = LoggerFactory.getLogger(CFValueHandlerSLA.class);
    private static final String SLA_CF_TYPE = "com.atlassian.servicedesk:sd-sla-field";
    private static final String SLA_METRIC_ID = "metricId";
    private static final String SLA_GOAL_ID = "goalId";
    private static final String SLA_QUERY_REF = "jqlQuery";
    private static final String SLA_ONGOING_DATA = "ongoingSLAData";
    private final ObjectMapperFactory mapperFactory;

    public CFValueHandlerSLA(ObjectMapperFactory mapperFactory) {
        this.mapperFactory = mapperFactory;
    }

    @Override
    public boolean canHandleCustomField(CustomField customfield, Issue issue) {
        CustomFieldType customFieldType = customfield.getCustomFieldType();
        String cfKey = customFieldType != null ? customFieldType.getKey() : "";
        return SLA_CF_TYPE.equals(cfKey);
    }

    @Override
    public Optional<Object> prepareCustomFieldValue(CustomField customField, Issue issue, Collection<Object> values) {
        if (values.isEmpty()) {
            return Optional.absent();
        }
        Object valueObject = values.iterator().next();
        if (valueObject instanceof Map) {
            Map value = (Map)valueObject;
            try {
                this.transformSLAGoal(customField, issue, value);
                return Optional.of((Object)this.mapperFactory.createPeriodAwareMapper().writeValueAsString(valueObject));
            }
            catch (Exception e) {
                log.warn("Cannot transform SLA value", (Throwable)e);
                return Optional.absent();
            }
        }
        return valueObject != null ? Optional.of((Object)valueObject.toString()) : Optional.absent();
    }

    @Override
    public Optional<Object> exportValue(CustomField customField, Issue issue) {
        Object value = customField.getValue(issue);
        return Optional.fromNullable((Object)value);
    }

    private void transformSLAGoal(CustomField customField, Issue issue, Map<String, Object> fieldValue) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Map ongoingSLAData = (Map)fieldValue.get(SLA_ONGOING_DATA);
        if (ongoingSLAData == null) {
            log.debug("Cannot get ongoing SLA data for issue {} and field {}", (Object)issue, (Object)customField);
            return;
        }
        String goalJQL = (String)ongoingSLAData.get(SLA_QUERY_REF);
        if (goalJQL == null) {
            log.debug("Encountered null-valued goal JQL. Skipping goal transformation");
            return;
        }
        ServiceDeskBridge bridge = this.getSDBridge();
        Option goalOption = bridge.getGoal(issue.getProjectObject(), customField.getFieldName(), goalJQL);
        ongoingSLAData.remove(SLA_QUERY_REF);
        if (!goalOption.isDefined()) {
            log.debug("Couldn't get proper goal goal. Skipping goal transformation");
            return;
        }
        ServiceDeskBridge.SLAGoal goal = (ServiceDeskBridge.SLAGoal)goalOption.get();
        fieldValue.put(SLA_METRIC_ID, goal.getTimeMetricId());
        ongoingSLAData.put(SLA_GOAL_ID, goal.getGoalId());
    }

    @VisibleForTesting
    ServiceDeskBridge getSDBridge() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (ServiceDeskBridge)Class.forName("com.atlassian.jira.plugins.importer.appbridge.servicedesk.ServiceDeskBridgeImpl").newInstance();
    }
}

