/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer.impl.customfields;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.ProjectCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CFValueHandler;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.google.common.base.Optional;
import java.util.Collection;
import org.ofbiz.core.entity.GenericValue;

public class CFValueHandlerProject
implements CFValueHandler {
    private final ProjectManager projectManager;

    public CFValueHandlerProject(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    @Override
    public boolean canHandleCustomField(CustomField customfield, Issue issue) {
        return customfield.getCustomFieldType() instanceof ProjectCFType;
    }

    @Override
    public Optional<Object> prepareCustomFieldValue(CustomField customField, Issue issue, Collection<Object> values) {
        String value = this.getValue(values);
        if (value == null) {
            return Optional.absent();
        }
        Optional<Project> projectOptional = this.getByProjectKey(value);
        if (!projectOptional.isPresent()) {
            projectOptional = this.getByProjectId(value);
        }
        if (!projectOptional.isPresent()) {
            projectOptional = this.getByProjectName(value);
        }
        if (projectOptional.isPresent()) {
            return Optional.of((Object)((Project)projectOptional.get()).getId().toString());
        }
        return Optional.absent();
    }

    @Override
    public Optional<Object> exportValue(CustomField customField, Issue issue) {
        Object value = customField.getValue(issue);
        if (value instanceof Project) {
            Project project = (Project)value;
            return Optional.of((Object)project.getKey());
        }
        if (value instanceof GenericValue) {
            GenericValue genericValue = (GenericValue)value;
            return Optional.fromNullable((Object)genericValue.getString("ID"));
        }
        return Optional.absent();
    }

    private Optional<Project> getByProjectKey(String key) {
        return Optional.fromNullable((Object)this.projectManager.getProjectObjByKey(key));
    }

    private Optional<Project> getByProjectId(String id) {
        try {
            return Optional.fromNullable((Object)this.projectManager.getProjectObj(Long.valueOf(Long.parseLong(id))));
        }
        catch (NumberFormatException numberFormatException) {
            return Optional.absent();
        }
    }

    private Optional<Project> getByProjectName(String name) {
        return Optional.fromNullable((Object)this.projectManager.getProjectObjByName(name));
    }

    private String getValue(Collection<Object> values) {
        if (values.size() > 0) {
            return values.iterator().next().toString();
        }
        return null;
    }
}

