/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer.impl.customfields;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.MultipleCustomFieldType;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CFValueHandler;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

public class CFValueHandlerMultiple
implements CFValueHandler {
    private static final Function<Option, String> OPTION_VALUE_GETTER = new Function<Option, String>(){

        public String apply(Option input) {
            return input.getValue();
        }
    };
    private final OptionsManager optionsManager;

    public CFValueHandlerMultiple(OptionsManager optionsManager) {
        this.optionsManager = optionsManager;
    }

    @Override
    public boolean canHandleCustomField(CustomField customfield, Issue issue) {
        return customfield.getCustomFieldType() instanceof MultipleCustomFieldType;
    }

    @Override
    public Optional<Object> prepareCustomFieldValue(CustomField customField, Issue issue, Collection<Object> values) {
        Options options = this.optionsManager.getOptions(customField.getRelevantConfig(issue));
        if (this.isValueOptionsHierarchy(values)) {
            return this.handleOptionsHierarchy(values, options);
        }
        return this.handleFlatOptions(values, options);
    }

    @Override
    public Optional<Object> exportValue(CustomField customField, Issue issue) {
        MultipleCustomFieldType type = (MultipleCustomFieldType)customField.getCustomFieldType();
        Object valueFromIssue = type.getValueFromIssue(customField, issue);
        if (valueFromIssue instanceof Option) {
            Option option = (Option)valueFromIssue;
            return Optional.of((Object)option.getValue());
        }
        if (valueFromIssue instanceof Collection) {
            Collection optionCollection = (Collection)valueFromIssue;
            Iterable optionValues = Iterables.transform((Iterable)optionCollection, OPTION_VALUE_GETTER);
            return Optional.of((Object)ImmutableList.copyOf((Iterable)optionValues));
        }
        if (valueFromIssue instanceof Map) {
            Map optionMap = (Map)valueFromIssue;
            Map optionStringMap = Maps.transformValues((Map)optionMap, OPTION_VALUE_GETTER);
            return Optional.of((Object)optionStringMap);
        }
        return Optional.absent();
    }

    private Optional<Object> handleFlatOptions(Collection<Object> values, final Options options) {
        Iterable optionsFromValues = Iterables.transform(values, (Function)new Function<Object, String>(){

            public String apply(@Nullable Object input) {
                if (input == null) {
                    return null;
                }
                Option optionForValue = options.getOptionForValue(input.toString(), null);
                return CFValueHandlerMultiple.this.getOptionIdInString(optionForValue);
            }
        });
        ArrayList optionIds = Lists.newArrayList((Iterable)Iterables.filter((Iterable)optionsFromValues, (Predicate)Predicates.notNull()));
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(null, optionIds);
        return Optional.of((Object)resultMap);
    }

    private Optional<Object> handleOptionsHierarchy(Collection<Object> values, Options options) {
        Object parent;
        Map map = (Map)values.iterator().next();
        HashMap resultMap = Maps.newHashMap();
        Object v = parent = map.get(null) != null ? map.get(null) : map.get("");
        if (parent == null) {
            return Optional.absent();
        }
        Option parentOption = options.getOptionForValue(parent.toString(), null);
        if (parentOption == null) {
            return Optional.absent();
        }
        resultMap.put(null, this.getOptionIdInString(parentOption));
        Integer level = 1;
        while (parentOption != null && map.get(level.toString()) != null) {
            Object nextLevelOption = map.get(level.toString());
            Option newOption = options.getOptionForValue(nextLevelOption.toString(), parentOption.getOptionId());
            if (newOption != null) {
                resultMap.put(level.toString(), this.getOptionIdInString(newOption));
            }
            parentOption = newOption;
            level = level + 1;
        }
        return Optional.of((Object)resultMap);
    }

    private String getOptionIdInString(@Nullable Option option) {
        Long optionId = option != null ? option.getOptionId() : null;
        return optionId != null ? optionId.toString() : "-1";
    }

    private boolean isValueOptionsHierarchy(Collection<Object> values) {
        Iterator<Object> iterator = values.iterator();
        if (iterator.hasNext()) {
            return iterator.next() instanceof Map;
        }
        return false;
    }
}

