/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer.impl;

import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.csv.ImportException;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PriorityUtils {
    private static final Logger log = LoggerFactory.getLogger(PriorityUtils.class);
    private final PrioritySchemeManager prioritySchemeManager;
    private final PriorityManager priorityManager;
    private final ProjectManager projectManager;

    @Autowired
    public PriorityUtils(@ComponentImport PrioritySchemeManager prioritySchemeManager, @ComponentImport PriorityManager priorityManager, @ComponentImport ProjectManager projectManager) {
        this.prioritySchemeManager = prioritySchemeManager;
        this.priorityManager = priorityManager;
        this.projectManager = projectManager;
    }

    public String preFilterPriority(ExternalIssue externalIssue, ExternalProject project, ImportLogger log) throws ImportException {
        String priorityId = externalIssue.getPriority();
        if ("<<!clear!>>".equals(priorityId)) {
            return null;
        }
        if (StringUtils.isNotBlank((String)priorityId)) {
            Priority priority = this.priorityManager.getPriority(priorityId);
            if (priority == null) {
                priority = this.priorityManager.createPriority(priorityId, "Created by JIM during import process", "/images/icons/priority_major.gif", "#009900");
                log.log("Priority [%s] wasn't found so it has been created.", priorityId);
            }
            if (!this.isPriorityInProjectScheme(project.getJiraId(), priority)) {
                if (!this.tryToAssociateWithProjectScheme(project.getJiraId(), priority)) {
                    String message = String.format("Priority [ %s ] is not in the project [ %s ] Priority Schema.  Also Priority Schema couldn't be changed, because it's shared by more than one project.", priority.getName(), project.getKey());
                    throw new ImportException(message);
                }
                log.log("Priority [%s] has been associated with the destination project Priority scheme", priorityId);
            }
            return priority.getId();
        }
        priorityId = this.prioritySchemeManager.getDefaultOption((IssueContext)new ProjectContext(project.getJiraId()));
        if (priorityId != null) {
            return priorityId;
        }
        throw new ImportException("Couldn't get default priority for this project");
    }

    private boolean tryToAssociateWithProjectScheme(Long jiraId, Priority priority) {
        Project project = this.projectManager.getProjectObj(jiraId);
        FieldConfigScheme priorityScheme = this.prioritySchemeManager.getScheme(project);
        FieldConfig fieldConfig = this.prioritySchemeManager.getFieldConfigForDefaultMapping(priorityScheme);
        if (priorityScheme == null) {
            log.warn("Couldn't find priorityScheme for project {}", (Object)project);
            return false;
        }
        if (fieldConfig == null) {
            log.warn("Couldn't find fieldConfig for project {}", (Object)project);
            return false;
        }
        if (priorityScheme.getAssociatedProjectIds().size() > 1) {
            return false;
        }
        ArrayList<String> options = new ArrayList<String>(this.prioritySchemeManager.getOptions(fieldConfig));
        options.add(priority.getId());
        this.prioritySchemeManager.setOptions(fieldConfig, options);
        return true;
    }

    private boolean isPriorityInProjectScheme(Long jiraProjectId, Priority priority) {
        Project projectObj = this.projectManager.getProjectObj(jiraProjectId);
        return this.prioritySchemeManager.getOptions(this.prioritySchemeManager.getFieldConfigForDefaultMapping(this.prioritySchemeManager.getScheme(projectObj))).contains(priority.getId());
    }
}

