/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer.impl;

import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.plugins.importer.external.beans.ExternalHistoryGroup;
import com.atlassian.jira.plugins.importer.external.beans.ExternalHistoryItem;
import com.atlassian.jira.plugins.importer.external.beans.ExternalHistoryItemBuilder;
import com.atlassian.jira.plugins.importer.imports.importer.impl.HistoryItemHandler;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.ofbiz.core.entity.GenericValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OfBizHistoryImporter {
    private final OfBizDelegator delegator;
    private final UserKeyService userKeyService;
    private final List<HistoryItemHandler> historyHandlers;

    @Autowired
    public OfBizHistoryImporter(@ComponentImport OfBizDelegator delegator, @ComponentImport UserKeyService userKeyService, List<HistoryItemHandler> historyHandlers) {
        this.delegator = delegator;
        this.userKeyService = userKeyService;
        this.historyHandlers = historyHandlers;
    }

    public void importHistory(MutableIssue issue, Iterable<ExternalHistoryGroup> history) {
        Long issueId = issue.getId();
        for (ExternalHistoryGroup group : history) {
            HashMap values = Maps.newHashMap();
            values.put("issue", issueId);
            if (group.getAuthor() != null) {
                String userKey = this.userKeyService.getKeyForUsername(group.getAuthor());
                if (userKey == null) {
                    userKey = group.getAuthor();
                }
                values.put("author", userKey);
            }
            if (group.getCreated() != null) {
                values.put("created", new Timestamp(group.getCreated().getMillis()));
            } else {
                values.put("created", new Timestamp(DateTime.now().getMillis()));
            }
            GenericValue changeGroup = this.delegator.createValue("ChangeGroup", (Map)values);
            for (ExternalHistoryItem changeItem : group.getItems()) {
                ExternalHistoryItemBuilder transformedItem = new ExternalHistoryItemBuilder().copy(changeItem);
                if ("assignee".equals(changeItem.getField()) || "reporter".equals(changeItem.getField())) {
                    transformedItem.setOldValue(StringUtils.defaultString((String)this.userKeyService.getKeyForUsername(changeItem.getOldValue()), (String)changeItem.getOldValue()));
                    transformedItem.setNewValue(StringUtils.defaultString((String)this.userKeyService.getKeyForUsername(changeItem.getNewValue()), (String)changeItem.getNewValue()));
                } else {
                    Option<HistoryItemHandler> handler = this.findHandler(changeItem, (Issue)issue);
                    if (handler.isDefined()) {
                        transformedItem.copy(((HistoryItemHandler)handler.get()).rewriteHistoryItem(changeItem, (Issue)issue));
                    }
                }
                Map<String, Object> fields = this.getHistoryItemDataMap(changeGroup.getLong("id"), transformedItem.createExternalHistoryItem());
                this.delegator.createValue("ChangeItem", fields);
            }
        }
    }

    private Map<String, Object> getHistoryItemDataMap(Long groupId, ExternalHistoryItem changeItem) {
        return MapBuilder.newBuilder().add((Object)"group", (Object)groupId).add((Object)"fieldtype", (Object)changeItem.getFieldType()).add((Object)"field", (Object)changeItem.getField()).add((Object)"oldvalue", (Object)changeItem.getOldValue()).add((Object)"oldstring", (Object)changeItem.getOldDisplayValue()).add((Object)"newvalue", (Object)changeItem.getNewValue()).add((Object)"newstring", (Object)changeItem.getNewDisplayValue()).toMap();
    }

    private Option<HistoryItemHandler> findHandler(final ExternalHistoryItem item, final Issue issue) {
        return Iterables.findFirst(this.historyHandlers, (Predicate)new Predicate<HistoryItemHandler>(){

            public boolean apply(HistoryItemHandler input) {
                return input.canHandleHistoryItem(item, issue);
            }
        });
    }
}

