/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer.impl;

import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.CreateAttachmentParamsBean;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelParser;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.external.ExternalException;
import com.atlassian.jira.plugins.importer.external.UserProvider;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.csv.ImportException;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ImportObjectIdMappings;
import com.atlassian.jira.plugins.importer.imports.importer.impl.PriorityUtils;
import com.atlassian.jira.plugins.importer.managers.CreateIssueLinkManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.web.util.AttachmentException;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExternalUtils {
    public static final String GENERIC_CONTENT_TYPE = "application/octet-stream";
    private final ProjectManager projectManager;
    private final IssueManager issueManager;
    private final JiraAuthenticationContext authenticationContext;
    private final VersionManager versionManager;
    private final WorkflowManager workflowManager;
    private final PermissionManager permissionManager;
    private final IssueFactory issueFactory;
    private final AttachmentManager attachmentManager;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final CreateIssueLinkManager issueLinkManager;
    private final FieldManager fieldManager;
    private final ApplicationProperties applicationProperties;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final CommentManager commentManager;
    private final OfBizDelegator genericDelegator;
    private final ConstantsManager constantsManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final SubTaskManager subTaskManager;
    private final UserKeyService userKeyService;
    private final TextFieldCharacterLengthValidator textFieldCharacterLengthValidator;
    private final CompatibilityBridgeUtils bridgeUtils;
    private final IssueTypeManager issueTypeManager;
    private final OptionSetManager optionSetManager;
    private final ProjectComponentManager projectComponentManager;
    private final PriorityUtils priorityUtils;

    @Autowired
    public ExternalUtils(@ComponentImport ProjectManager projectManager, @ComponentImport IssueManager issueManager, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport VersionManager versionManager, @ComponentImport ConstantsManager constantsManager, @ComponentImport WorkflowManager workflowManager, @ComponentImport PermissionManager permissionManager, @ComponentImport IssueFactory issueFactory, @ComponentImport AttachmentManager attachmentManager, @ComponentImport IssueLinkTypeManager issueLinkTypeManager, CreateIssueLinkManager issueLinkManager, @ComponentImport FieldManager fieldManager, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport IssueTypeSchemeManager issueTypeSchemeManager, @ComponentImport CommentManager commentManager, @ComponentImport OfBizDelegator genericDelegator, @ComponentImport IssueSecurityLevelManager issueSecurityLevelManager, @ComponentImport SubTaskManager subTaskManager, @ComponentImport UserKeyService userKeyService, @ComponentImport TextFieldCharacterLengthValidator textFieldCharacterLengthValidator, @ComponentImport IssueTypeManager issueTypeManager, @ComponentImport OptionSetManager optionSetManager, @ComponentImport ProjectComponentManager projectComponentManager, CompatibilityBridgeUtils bridgeUtils, PriorityUtils priorityUtils) {
        this.projectManager = projectManager;
        this.issueManager = issueManager;
        this.authenticationContext = authenticationContext;
        this.versionManager = versionManager;
        this.constantsManager = constantsManager;
        this.workflowManager = workflowManager;
        this.permissionManager = permissionManager;
        this.issueFactory = issueFactory;
        this.attachmentManager = attachmentManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueLinkManager = issueLinkManager;
        this.fieldManager = fieldManager;
        this.applicationProperties = applicationProperties;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.commentManager = commentManager;
        this.genericDelegator = genericDelegator;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.subTaskManager = subTaskManager;
        this.userKeyService = userKeyService;
        this.textFieldCharacterLengthValidator = textFieldCharacterLengthValidator;
        this.bridgeUtils = bridgeUtils;
        this.issueTypeManager = issueTypeManager;
        this.optionSetManager = optionSetManager;
        this.projectComponentManager = projectComponentManager;
        this.priorityUtils = priorityUtils;
    }

    public Version createVersion(ExternalProject externalProject, ExternalVersion externalVersion, ImportLogger log) {
        Version jiraVersion = null;
        try {
            String versionName = externalVersion.getName();
            jiraVersion = this.versionManager.createVersion(versionName, externalVersion.getReleaseDate() != null ? externalVersion.getReleaseDate().toDate() : null, externalVersion.getDescription(), externalProject.getJiraId(), null);
            this.bridgeUtils.setVersionReleasedArchivedAndStartDate(this.versionManager, this.versionManager.getVersion(jiraVersion.getId()), externalVersion.isReleased(), externalVersion.isArchived(), externalVersion.getStartDate());
            jiraVersion = this.versionManager.getVersion(jiraVersion.getId());
        }
        catch (Exception e) {
            log.warn(e, "Problems encountered while creating Version %s", externalVersion);
        }
        return jiraVersion;
    }

    public GenericValue createIssue(Issue issue, String status, String resolution, ImportLogger log) throws ExternalException {
        String normalizedStatus = this.normalizeStatus(issue.getProjectObject(), issue.getIssueTypeObject(), status);
        try {
            GenericValue issueGV = this.bridgeUtils.createIssue(this.issueManager, this.authenticationContext.getUser(), issue);
            if (StringUtils.isNotBlank((String)normalizedStatus)) {
                this.setCurrentWorkflowStep(issueGV, normalizedStatus, resolution, log);
            }
            return issueGV;
        }
        catch (Exception e) {
            throw new ExternalException("Unable to create issue: " + issue, e);
        }
    }

    protected String normalizeStatus(Project project, IssueType issueType, String status) throws WorkflowException, ExternalException {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkNotNull((Object)issueType);
        if (StringUtils.isBlank((String)status)) {
            return null;
        }
        IssueConstant statusObject = this.constantsManager.getConstantByNameIgnoreCase(ConstantsManager.STATUS_CONSTANT_TYPE, status);
        if (statusObject == null) {
            statusObject = this.constantsManager.getConstantObject(ConstantsManager.STATUS_CONSTANT_TYPE, status);
        }
        if (statusObject == null) {
            throw new ExternalException(String.format("Status %s cannot be found in JIRA neither by name and id", status));
        }
        JiraWorkflow workflow = this.workflowManager.getWorkflow(project.getId(), issueType.getId());
        if (!this.isStatusInWorkflow(workflow, statusObject)) {
            throw new ExternalException(String.format("Status [ %s ] does not have a linked step in the [ %s ] workflow. Please map to a different status.", statusObject.getName(), workflow.getName()));
        }
        return statusObject.getId();
    }

    private boolean isStatusInWorkflow(JiraWorkflow workflow, final IssueConstant statusConstant) {
        return Iterables.any((Iterable)workflow.getLinkedStatusObjects(), (Predicate)new Predicate<Status>(){

            public boolean apply(Status input) {
                return input.getId().equals(statusConstant.getId());
            }
        });
    }

    public void setCurrentWorkflowStep(GenericValue issue, String statusId, String resolution, ImportLogger log) throws GenericEntityException, WorkflowException {
        if (issue != null) {
            Status status = this.constantsManager.getStatusObject(statusId);
            if (status != null) {
                JiraWorkflow workflow = this.workflowManager.getWorkflow(issue);
                StepDescriptor linkedStep = workflow.getLinkedStep(status);
                List wfCurrentStepCollection = this.genericDelegator.findByAnd("OSCurrentStep", EasyMap.build((Object)"entryId", (Object)issue.getLong("workflowId")));
                if (wfCurrentStepCollection != null && !wfCurrentStepCollection.isEmpty()) {
                    GenericValue wfCurrentStep = (GenericValue)wfCurrentStepCollection.iterator().next();
                    if (linkedStep != null) {
                        wfCurrentStep.set("stepId", (Object)linkedStep.getId());
                        wfCurrentStep.store();
                    } else {
                        log.fail(null, "Workflow '%s' does not have a step for status '%s'.", workflow.getName(), status.getName());
                    }
                } else {
                    log.warn("Workflow Id not found", new Object[0]);
                }
                issue.set("status", (Object)statusId);
                issue.set("resolution", (Object)resolution);
                issue.store();
            } else {
                log.warn("Status GV for '%s' was null. Issue not updated: %s", statusId, issue);
            }
        }
    }

    public void addComments(UserProvider userProvider, Issue issue, ExternalComment externalComment, boolean dispatchEvent, ImportLogger log) throws ExternalException {
        this.addComments(userProvider, issue, externalComment, dispatchEvent, true, log);
    }

    public void addComments(UserProvider userProvider, Issue issue, ExternalComment externalComment, boolean dispatchEvent, boolean tweakIssueUpdateDate, ImportLogger log) throws ExternalException {
        ApplicationUser commenter = null;
        String username = externalComment.getAuthor();
        if (username != null && (commenter = userProvider.getUser(username)) == null) {
            log.warn("Commenter named %s not found. Creating issue with currently logged in user instead", username);
        }
        if (commenter == null) {
            commenter = this.authenticationContext.getUser();
        }
        if (!this.permissionManager.hasPermission(15, issue, commenter)) {
            String s = "Comment not created. The user (" + commenter.getDisplayName() + ") do not have permission to comment on an issue in project: " + this.projectManager.getProjectObj(issue.getLong("project")).getName();
            log.warn(s, new Object[0]);
            throw new ExternalException(s);
        }
        try {
            String authorKey = this.userKeyService.getKeyForUsername(commenter.getName());
            Date timePerformed = externalComment.getCreated() != null ? externalComment.getCreated().toDate() : null;
            this.commentManager.create(issue, authorKey, authorKey, externalComment.getBody(), null, null, timePerformed, timePerformed, dispatchEvent, tweakIssueUpdateDate);
        }
        catch (Exception e) {
            log.warn(e, "Unable to create comment %s. Comment not created", externalComment);
            throw new ExternalException(e);
        }
    }

    protected String cleanFileName(String fileName) {
        fileName = StringUtils.replaceChars((String)fileName, (String)"\\/", (String)"--");
        return StringUtils.stripStart((String)fileName, (String)"-");
    }

    public void attachFile(UserProvider userProvider, ExternalAttachment externalAttachment, MutableIssue issue, ImportLogger log) throws ExternalException {
        String username = externalAttachment.getAttacher();
        ApplicationUser user = userProvider.getUser(username);
        if (user == null) {
            if (username != null) {
                log.warn("User named %s not found. attaching to issue with currently logged in user instead", username);
            }
            user = this.authenticationContext.getUser();
        }
        try {
            String fileName = this.cleanFileName(externalAttachment.getName());
            CreateAttachmentParamsBean.Builder attachmentBean = new CreateAttachmentParamsBean.Builder(externalAttachment.getAttachment(), fileName, GENERIC_CONTENT_TYPE, user, (Issue)issue).createdTime((Date)new Timestamp(externalAttachment.getCreated().getMillis()));
            this.attachmentManager.createAttachment(attachmentBean.build());
            if (StringUtils.isNotBlank((String)externalAttachment.getDescription())) {
                ExternalComment comment = new ExternalComment(this.trimToLimit(this.getAuthenticationContext().getI18nHelper().getText("jira-importer-plugins.external.utils.attachment.description", fileName, externalAttachment.getDescription())), user.getName(), externalAttachment.getCreated());
                this.addComments(userProvider, (Issue)issue, comment, false, log);
            }
        }
        catch (AttachmentException e) {
            throw new ExternalException(e);
        }
    }

    private String trimToLimit(String input) {
        if (this.textFieldCharacterLengthValidator.isTextTooLong(input)) {
            return StringUtils.abbreviate((String)input, (int)Ints.saturatedCast((long)this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters()));
        }
        return input;
    }

    public void createIssueLink(Issue sourceIssue, Issue destinationIssue, String linkName, Long sequence, boolean subtask, ImportLogger log) throws ExternalException {
        if (sourceIssue != null && destinationIssue != null) {
            try {
                if (subtask) {
                    if (!sourceIssue.getIssueTypeObject().isSubTask()) {
                        log.fail(null, "Issue '%s' is not of a sub-task type (%s). It will NOT be a sub-task of the issue '%s'", sourceIssue.getKey(), sourceIssue.getIssueTypeObject().getName(), destinationIssue.getKey());
                        return;
                    }
                    this.bridgeUtils.createSubTaskIssueLink(this.subTaskManager, destinationIssue, sourceIssue, this.authenticationContext.getUser());
                    log.log("Created parent-child (sub-task) relationship between %s and %s", sourceIssue.getKey(), destinationIssue.getKey());
                } else {
                    IssueLinkType linkType = this.createOrFindLinkType(linkName);
                    if (linkType != null) {
                        this.issueLinkManager.createIssueLink(sourceIssue.getId(), destinationIssue.getId(), linkType.getId(), sequence);
                        log.log("Created link '%s' between %s and %s", linkType.getName(), sourceIssue.getKey(), destinationIssue.getKey());
                    }
                }
            }
            catch (CreateException e) {
                throw new ExternalException(e.getMessage(), e);
            }
        }
    }

    private IssueLinkType createOrFindLinkType(String name) throws ExternalException {
        Collection dependency = this.issueLinkTypeManager.getIssueLinkTypesByName(name);
        if (dependency.isEmpty()) {
            try {
                this.issueLinkTypeManager.createIssueLinkType(name, name, name, null);
            }
            catch (IllegalArgumentException e) {
                throw new ExternalException(e);
            }
            dependency = this.issueLinkTypeManager.getIssueLinkTypesByName(name);
        }
        return (IssueLinkType)dependency.iterator().next();
    }

    private List<Version> retrieveVersionsFromExternalIds(Iterable<String> externalVersionIds, ExternalProject project, ImportObjectIdMappings mappings, ImportLogger log) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (String externalVersionId : externalVersionIds) {
            Version version = mappings.getVersion(project.getName(), externalVersionId);
            if (version != null) {
                versions.add(version);
                continue;
            }
            log.log("Version does not exist for project: '%s' : and version: '%s'.", project, externalVersionId);
        }
        return versions;
    }

    private static <T> T getOrClear(T x) {
        return x == "<<!clear!>>" ? null : (T)x;
    }

    private static <T extends Iterable<?>> T getOrEmpty(T x) {
        return (T)(Iterables.contains(x, (Object)"<<!clear!>>") ? Collections.emptyList() : x);
    }

    public MutableIssue convertExternalIssueToIssue(UserProvider userProvider, ExternalIssue externalIssue, ExternalProject externalProject, ImportObjectIdMappings mappings, ImportLogger log) throws ImportException {
        boolean isExistingIssue;
        Project project = this.projectManager.getProjectObj(externalProject.getJiraId());
        String targetKey = this.getJiraIssueKey(log, project, externalIssue.getKey());
        MutableIssue issue = this.getCorrectIssue(targetKey);
        issue.setProjectId(externalProject.getJiraId());
        if (issue.getIssueTypeId() == null || !StringUtils.isBlank((String)externalIssue.getIssueType())) {
            issue.setIssueTypeId(this.preFilterIssueType(externalIssue, externalProject, log).getId());
        }
        if (issue.getSecurityLevelId() == null) {
            try {
                issue.setSecurityLevelId(this.issueSecurityLevelManager.getSchemeDefaultSecurityLevel(project.getGenericValue()));
            }
            catch (GenericEntityException e) {
                throw new ImportException("Can't get default security level for a project", e);
            }
        }
        if (externalIssue.getReporter() != null) {
            this.bridgeUtils.setReporter(issue, userProvider.getUser(ExternalUtils.getOrClear(externalIssue.getReporter())));
        }
        if (externalIssue.getAssignee() != null) {
            this.bridgeUtils.setAssignee(issue, userProvider.getUser(ExternalUtils.getOrClear(externalIssue.getAssignee())));
        }
        boolean bl = isExistingIssue = issue.getId() != null;
        if (isExistingIssue && externalIssue.getSummary() != null) {
            if (externalIssue.getSummary() == "<<!clear!>>") {
                throw new ImportException("Cannot clear issue summary");
            }
            issue.setSummary(externalIssue.getSummary());
        }
        if (!isExistingIssue) {
            String summary = this.preFilterSummary(externalIssue);
            if (StringUtils.isBlank((String)summary)) {
                throw new ImportException("Blank summary detected. Such issue cannot be imported");
            }
            issue.setSummary(summary);
        }
        if (externalIssue.getDescription() != null) {
            issue.setDescription(ExternalUtils.getOrClear(externalIssue.getDescription()));
        }
        if (externalIssue.getEnvironment() != null) {
            issue.setEnvironment(ExternalUtils.getOrClear(externalIssue.getEnvironment()));
        }
        if (externalIssue.getPriority() != null) {
            issue.setPriorityId(this.priorityUtils.preFilterPriority(externalIssue, externalProject, log));
        }
        if (externalIssue.getResolution() != null) {
            issue.setResolutionId(ExternalUtils.getOrClear(externalIssue.getResolution()));
        }
        if (externalIssue.getCreated() != null) {
            issue.setCreated(this.toTimeStamp(externalIssue.getCreated()));
        }
        if (externalIssue.getUpdated() != null) {
            issue.setUpdated(this.toTimeStamp(externalIssue.getUpdated()));
        }
        if (externalIssue.getDuedate() != null) {
            issue.setDueDate(this.toTimeStamp(ExternalUtils.getOrClear(externalIssue.getDuedate())));
        }
        if (issue.getCreated() == null) {
            issue.setCreated(new Timestamp(System.currentTimeMillis()));
        }
        if (issue.getUpdated() == null) {
            issue.setUpdated(issue.getCreated());
        }
        if (externalIssue.getResolutionDate() != null && externalIssue.getResolution() != null) {
            issue.setResolutionDate(this.toTimeStamp(ExternalUtils.getOrClear(externalIssue.getResolutionDate())));
        } else if (externalIssue.getResolution() != null) {
            issue.setResolutionDate(issue.getUpdated());
        }
        if (externalIssue.getVotes() != null) {
            issue.setVotes(externalIssue.getVotes());
        }
        if (this.fieldManager.isTimeTrackingOn()) {
            if (externalIssue.getOriginalEstimate() != null) {
                issue.setOriginalEstimate(this.convertPeriod(externalIssue.getOriginalEstimate()));
            }
            if (externalIssue.getTimeSpent() != null) {
                issue.setTimeSpent(this.convertPeriod(externalIssue.getTimeSpent()));
            }
            if (externalIssue.getEstimate() != null) {
                issue.setEstimate(this.convertPeriod(externalIssue.getEstimate()));
            } else if (externalIssue.getOriginalEstimate() != null && this.getApplicationProperties().getOption("jira.timetracking.estimates.legacy.behaviour")) {
                issue.setEstimate(this.convertPeriod(externalIssue.getOriginalEstimate()));
            }
        }
        if (externalIssue.getAffectedVersions() != null) {
            issue.setAffectedVersions(this.retrieveVersionsFromExternalIds(externalIssue.getAffectedVersions(), externalProject, mappings, log));
        }
        if (externalIssue.getFixedVersions() != null) {
            issue.setFixVersions(this.retrieveVersionsFromExternalIds(externalIssue.getFixedVersions(), externalProject, mappings, log));
        }
        if (!externalIssue.getLabels().isEmpty()) {
            issue.setLabels(ExternalUtils.createLabels((Collection<String>)ExternalUtils.getOrEmpty(externalIssue.getLabels())));
        }
        if (externalIssue.getComponents() != null) {
            this.bridgeUtils.setComponents(issue, this.retrieveComponents(externalIssue.getComponents(), project, log));
        }
        return issue;
    }

    private List<ProjectComponent> retrieveComponents(final List<String> components, Project project, ImportLogger log) {
        Collection projectComponents = this.projectComponentManager.findAllForProject(project.getId());
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)projectComponents, (Predicate)new Predicate<ProjectComponent>(){

            public boolean apply(final ProjectComponent projectComponent) {
                return Iterables.any((Iterable)components, (Predicate)new Predicate<String>(){

                    public boolean apply(@Nullable String s) {
                        return projectComponent.getName().equalsIgnoreCase(s);
                    }
                });
            }
        }));
    }

    private MutableIssue getCorrectIssue(String targetKey) {
        MutableIssue existingIssue = targetKey != null ? this.issueManager.getIssueObject(targetKey) : null;
        return existingIssue == null ? this.newIssueInstance(targetKey) : existingIssue;
    }

    private String getJiraIssueKey(ImportLogger log, Project project, String externalIssueKey) {
        if (externalIssueKey != null) {
            long fromKey = JiraKeyUtils.getFastCountFromKey((String)externalIssueKey);
            if (fromKey == -1L) {
                log.warn("Specifed issue key '%s' seems invalid. This key will be ignored and auto-generated one will be used instead.", externalIssueKey);
                return null;
            }
            return project.getKey() + "-" + fromKey;
        }
        return null;
    }

    @Nullable
    private Long convertPeriod(@Nullable Period period) {
        return period != null ? Long.valueOf(period.toStandardSeconds().getSeconds()) : null;
    }

    protected static Set<Label> createLabels(Collection<String> labels) {
        HashSet result = Sets.newHashSet();
        for (String label : labels) {
            String cleanLabel;
            if (StringUtils.isBlank((String)label) || !StringUtils.isNotBlank((String)(cleanLabel = LabelParser.getCleanLabel((String)label)))) continue;
            result.add(new Label(null, null, null, cleanLabel));
        }
        return result;
    }

    public MutableIssue newIssueInstance(@Nullable String key) {
        MutableIssue issue = this.issueFactory.getIssue();
        return key == null ? issue : this.bridgeUtils.createFixedKeyIssue(issue, key);
    }

    private String preFilterSummary(ExternalIssue externalIssue) {
        String summary = externalIssue.getSummary();
        if (StringUtils.isBlank((String)summary) && !StringUtils.isNotBlank((String)externalIssue.getDescription())) {
            return StringUtils.abbreviate((String)externalIssue.getDescription(), (int)250);
        }
        return summary;
    }

    private IssueType preFilterIssueType(ExternalIssue externalIssue, ExternalProject project, ImportLogger log) throws ImportException {
        String issueType = externalIssue.getIssueType();
        if (StringUtils.isNotBlank((String)issueType)) {
            IssueType type = this.constantsManager.getIssueTypeObject(issueType);
            if (type == null) {
                type = this.issueTypeManager.createIssueType(issueType, "Created by JIM during import process", "/images/icons/issuetypes/genericissue.png");
                log.log("Issue Type [%s] wasn't found so it has been created.", new Object[0]);
            }
            if (!this.isIssueTypeInProjectScheme(project.getJiraId(), type)) {
                if (!this.tryToAssociateWithProjectScheme(project.getJiraId(), type)) {
                    String message = String.format("Issue type [ %s ] is not in the project [ %s ] Issue Type Schema.  Also Issue Type Schema couldn't be changed, because it's shared by more than one project.", type.getName(), project.getKey());
                    throw new ImportException(message);
                }
                log.log("Issue Type [%s] has been associated with the destination project Issue Type scheme", new Object[0]);
            }
            return type;
        }
        IssueType issueTypeDefault = this.issueTypeSchemeManager.getDefaultValue(this.projectManager.getProjectObj(project.getJiraId()).getGenericValue());
        if (issueTypeDefault != null) {
            return issueTypeDefault;
        }
        return this.getNonDefaultIssue(project);
    }

    private boolean tryToAssociateWithProjectScheme(Long jiraId, IssueType type) {
        Project project = this.projectManager.getProjectObj(jiraId);
        FieldConfigScheme issueTypeScheme = this.issueTypeSchemeManager.getConfigScheme(project);
        FieldConfig fieldConfig = issueTypeScheme.getOneAndOnlyConfig();
        if (issueTypeScheme.getAssociatedProjectIds().size() > 1 && fieldConfig != null) {
            return false;
        }
        ArrayList optionSets = Lists.newArrayList((Iterable)this.optionSetManager.getOptionsForConfig(fieldConfig).getOptionIds());
        optionSets.add(type.getId());
        this.issueTypeSchemeManager.update(issueTypeScheme, (Collection)optionSets);
        return true;
    }

    private IssueType getNonDefaultIssue(ExternalProject project) throws ImportException {
        Project jiraProject = this.projectManager.getProjectObj(project.getJiraId());
        Collection typesForProject = this.issueTypeSchemeManager.getIssueTypesForProject(jiraProject);
        IssueType bugType = (IssueType)Iterables.getFirst((Iterable)Iterables.filter((Iterable)typesForProject, (Predicate)new Predicate<IssueType>(){

            public boolean apply(IssueType input) {
                return "Bug".equals(input.getName());
            }
        }), null);
        if (bugType != null) {
            return bugType;
        }
        if (typesForProject.isEmpty()) {
            throw new ImportException("Issue Type schema associated with this project doesn't have any issue type");
        }
        return (IssueType)typesForProject.iterator().next();
    }

    private boolean isIssueTypeInProjectScheme(Long jiraProjectId, IssueType issueType) {
        Project projectObj = this.projectManager.getProjectObj(jiraProjectId);
        Collection issueTypes = this.issueTypeSchemeManager.getIssueTypesForProject(projectObj);
        return issueTypes.contains(issueType);
    }

    @Nullable
    private Timestamp toTimeStamp(@Nullable DateTime date) {
        if (date != null) {
            return new Timestamp(date.getMillis());
        }
        return null;
    }

    public DateUtils getDateUtils() {
        return new DateUtils(this.authenticationContext.getI18nHelper().getDefaultResourceBundle());
    }

    public boolean isIssueLinkingOn() {
        return this.applicationProperties.getOption("jira.option.issuelinking");
    }

    public boolean areAttachmentsEnabled() {
        return this.applicationProperties.getOption("jira.option.allowattachments");
    }

    public boolean areSubtasksEnabled() {
        return this.applicationProperties.getOption("jira.option.allowsubtasks");
    }

    public String getPotentialProjectKey(String name, int keylength) {
        String potentialKey = (name = StringUtils.deleteWhitespace((String)name)).length() < keylength ? name + this.generatePaddingString(keylength - name.length()) : name.substring(0, keylength);
        if (this.projectManager.getProjectObjByKey(potentialKey) != null) {
            return this.getPotentialProjectKey(name, ++keylength);
        }
        return potentialKey;
    }

    public String getProjectKey(String name) {
        Project project = this.projectManager.getProjectObjByName(name);
        if (project == null) {
            return this.getPotentialProjectKey(name.toUpperCase(), 3);
        }
        return project.getKey();
    }

    private String generatePaddingString(int length) {
        char[] padarray = new char[length];
        for (int i = 0; i < length; ++i) {
            padarray[i] = 74;
        }
        return String.valueOf(padarray);
    }

    public JiraAuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    public IssueFactory getIssueFactory() {
        return this.issueFactory;
    }

    public IssueManager getIssueManager() {
        return this.issueManager;
    }

    public OfBizDelegator getGenericDelegator() {
        return this.genericDelegator;
    }

    public ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    public GenericValue updateIssue(MutableIssue issue, String status, ImportLogger log) throws ExternalException {
        Issue updatedIssue = this.bridgeUtils.updateIssue(this.getAuthenticationContext().getUser(), issue);
        GenericValue issueGV = updatedIssue.getGenericValue();
        String normalizedStatus = this.normalizeStatus(issue.getProjectObject(), issue.getIssueTypeObject(), status);
        try {
            this.genericDelegator.storeAll((List)ImmutableList.of((Object)issueGV));
            if (StringUtils.isNotBlank((String)normalizedStatus)) {
                GenericValue beforeStatusChangeGv = this.issueManager.getIssue(issue.getKey());
                this.setCurrentWorkflowStep(issueGV, normalizedStatus, issue.getResolutionId(), log);
                GenericValue genericValue = ChangeLogUtils.createChangeGroup((ApplicationUser)this.getAuthenticationContext().getUser(), (GenericValue)beforeStatusChangeGv, (GenericValue)issueGV, (Collection)Lists.newArrayList(), (boolean)true);
            }
            return issueGV;
        }
        catch (Exception e) {
            throw new ExternalException("Unable to create issue: " + issue, e);
        }
    }
}

