/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer.impl;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.SummarySystemField;
import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelParser;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.statistics.util.DocumentHitCollector;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogImpl;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.plugins.importer.BackCompatibilityUtil;
import com.atlassian.jira.plugins.importer.analytics.ImporterCancelledEvent;
import com.atlassian.jira.plugins.importer.analytics.ImporterFinishedEvent;
import com.atlassian.jira.plugins.importer.analytics.ImporterStartedEvent;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.external.ExternalException;
import com.atlassian.jira.plugins.importer.external.ExternalProjectUtils;
import com.atlassian.jira.plugins.importer.external.ExternalUserUtils;
import com.atlassian.jira.plugins.importer.external.InvalidUsernamesException;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.external.beans.ExternalWorklog;
import com.atlassian.jira.plugins.importer.imports.csv.ImportException;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.ImportStats;
import com.atlassian.jira.plugins.importer.imports.importer.UnknownUsersException;
import com.atlassian.jira.plugins.importer.imports.importer.impl.AbstractDataImporter;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ExternalUtils;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ImportObjectIdMappings;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ImporterExecutionContext;
import com.atlassian.jira.plugins.importer.imports.importer.impl.OfBizHistoryImporter;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ProjectAvatarUtil;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ProjectCategoryUtil;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CustomFieldsUtil;
import com.atlassian.jira.plugins.importer.managers.CreateConstantsManager;
import com.atlassian.jira.plugins.importer.managers.CreateProjectManager;
import com.atlassian.jira.plugins.importer.sample.Callbacks;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ImportUtils;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.joda.time.DateTime;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@Nonnull
public class DefaultJiraDataImporter
extends AbstractDataImporter {
    public static final String EXTERNAL_ISSUE_ID = "External issue ID";
    public static final String EXTERNAL_ISSUE_URL = "External issue URL";
    private static final int MAX_ISSUES_PER_REINDEX = 50;
    private final Pattern issueKeyParser = Pattern.compile("^([^-]*)-([0-9]*)$");
    private final ExternalUtils utils;
    private final WorklogManager worklogManager;
    private final FieldManager fieldManager;
    private final WatcherManager watcherManager;
    private final VoteManager voteManager;
    private final SubTaskManager subTaskManager;
    private final VersionManager versionManager;
    private final ExternalUserUtils externalUserUtils;
    private final CreateProjectManager createProjectManager;
    private final CrowdService crowdService;
    private final SearchProviderFactory searchServiceFactory;
    private final UserKeyService userKeyService;
    private final ProjectComponentManager componentManager;
    private final CustomFieldManager customFieldManager;
    private final OfBizHistoryImporter historyImporter;
    private final CustomFieldsUtil customFieldsUtil;
    private final IssueIndexManager indexManager;
    private final CreateConstantsManager createConstantsManager;
    private final Collection<GenericValue> unindexedIssueGvs = new LinkedList<GenericValue>();
    private final ProjectManager projectManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final CompatibilityBridgeUtils bridgeUtils;
    private final IssuePropertyService issuePropertyService;
    private Option<? extends Class> textCustomFieldType;
    private Set<ApplicationUser> usersToDeactivate = new HashSet<ApplicationUser>();
    private Set<ApplicationUser> createdUsers = new HashSet<ApplicationUser>();
    private UserProvider userProvider;
    private ImportObjectIdMappings mappings;
    private Map<String, String> externalIdToIssueKey;
    private Map<String, Option<CustomField>> customFieldsCache;
    private int skippedIssues;
    private Callbacks callbacks;
    private EventPublisher eventPublisher;
    private final TextFieldCharacterLengthValidator textFieldCharacterLengthValidator;
    private ImporterExecutionContext context;

    public DefaultJiraDataImporter(ExternalUtils utils, WorklogManager worklogManager, FieldManager fieldManager, WatcherManager watcherManager, VoteManager voteManager, IssueIndexManager indexManager, CreateConstantsManager createConstantsManager, SubTaskManager subTaskManager, VersionManager versionManager, ExternalUserUtils externalUserUtils, ProjectManager projectManager, CreateProjectManager createProjectManager, CrowdService crowdService, SearchProviderFactory searchProviderFactory, ProjectComponentManager componentManager, CustomFieldManager customFieldManager, CustomFieldsUtil customFieldsUtil, FieldLayoutManager fieldLayoutManager, FieldConfigSchemeManager fieldConfigSchemeManager, OfBizHistoryImporter historyImporter, TaskManager taskManager, UserKeyService userKeyService, BackCompatibilityUtil backCompatibilityUtil, EventPublisher eventPublisher, TextFieldCharacterLengthValidator textFieldCharacterLengthValidator, CompatibilityBridgeUtils bridgeUtils, IssuePropertyService issuePropertyService) {
        super(taskManager, backCompatibilityUtil, utils.getAuthenticationContext());
        this.utils = utils;
        this.worklogManager = worklogManager;
        this.fieldManager = fieldManager;
        this.watcherManager = watcherManager;
        this.voteManager = voteManager;
        this.indexManager = indexManager;
        this.createConstantsManager = createConstantsManager;
        this.subTaskManager = subTaskManager;
        this.versionManager = versionManager;
        this.externalUserUtils = externalUserUtils;
        this.createProjectManager = createProjectManager;
        this.crowdService = crowdService;
        this.searchServiceFactory = searchProviderFactory;
        this.componentManager = componentManager;
        this.customFieldManager = customFieldManager;
        this.customFieldsUtil = customFieldsUtil;
        this.fieldLayoutManager = fieldLayoutManager;
        this.historyImporter = historyImporter;
        this.projectManager = projectManager;
        this.userKeyService = userKeyService;
        this.eventPublisher = eventPublisher;
        this.textFieldCharacterLengthValidator = textFieldCharacterLengthValidator;
        this.bridgeUtils = bridgeUtils;
        this.issuePropertyService = issuePropertyService;
    }

    public static String rewriteStringWithIssueKeys(String regexPattern, Map<String, String> keyLookupTable, String s) {
        Validate.notNull((Object)regexPattern);
        Validate.notNull((Object)s);
        String result = s;
        Pattern pattern = Pattern.compile(regexPattern, 2);
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            String oldIds = matcher.group(1);
            String cleanedOldIds = StringUtils.replace((String)oldIds, (String)" ", (String)"");
            StringTokenizer st = new StringTokenizer(cleanedOldIds, ",");
            StringBuffer sb = DefaultJiraDataImporter.translateKeys(keyLookupTable, st);
            if (sb == null) continue;
            if (oldIds.endsWith(" ")) {
                sb.append(" ");
            }
            result = result.replace(matcher.group(0), sb.toString());
        }
        return result;
    }

    @Nullable
    private static StringBuffer translateKeys(Map<String, String> keyLookupTable, StringTokenizer tokenizer) {
        StringBuffer sb = new StringBuffer();
        if (tokenizer.countTokens() > 1) {
            sb.append("issues ");
        }
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (keyLookupTable.containsKey(token)) {
                sb.append(keyLookupTable.get(token));
                if (!tokenizer.hasMoreTokens()) continue;
                sb.append(", ");
                continue;
            }
            return null;
        }
        return sb;
    }

    private boolean isAnyRequiredUserNonExistent() {
        for (ExternalUser externalUser : this.dataBean.getRequiredUsers(this.getSelectedProjects(), this.log)) {
            ApplicationUser user = this.userProvider.getUser(externalUser);
            if (user != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<ExternalUser> getNonExistentAssociatedUsers() {
        HashSet<ExternalUser> nonExistentUsers = new HashSet<ExternalUser>();
        for (ExternalUser externalUser : this.dataBean.getRequiredUsers(this.getSelectedProjects(), this.log)) {
            ApplicationUser user = this.userProvider.getUser(externalUser);
            if (user != null) continue;
            nonExistentUsers.add(externalUser);
        }
        return nonExistentUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doImport(ImporterExecutionContext importerExecutionContext) {
        try {
            Set<ExternalProject> selectedProjects;
            block41: {
                selectedProjects = this.getSelectedProjects();
                this.log.log("Import started by %s using %s", this.utils.getAuthenticationContext().getUser().getName(), this.dataBean.getClass().getName());
                this.preImport(importerExecutionContext);
                this.stats.beginStep(ImportStats.Stage.VALIDATE);
                try {
                    if (this.isExternalUserManagementEnabled()) {
                        Set<ExternalUser> unknownUsers = this.getNonExistentAssociatedUsers();
                        if (this.isAnyRequiredUserNonExistent()) {
                            throw new UnknownUsersException(this.getI18nHelper().getText("jira-importer-plugin.external.user.externalusermanagementenabled"), unknownUsers);
                        }
                    }
                }
                finally {
                    this.stats.endStep();
                }
                this.stats.beginStep(ImportStats.Stage.USERS);
                try {
                    if (!this.isExternalUserManagementEnabled()) {
                        this.importUsers();
                        this.log.log("%d users successfully created.", this.stats.getStage(ImportStats.Stage.USERS).getItemsCreated());
                    } else {
                        this.log.skip("Users");
                    }
                }
                finally {
                    this.stats.endStep();
                }
                this.log.log("Retrieving projects...", new Object[0]);
                this.stats.beginStep(ImportStats.Stage.PROJECTS);
                try {
                    this.stats.setTotalItems(selectedProjects.size());
                    for (ExternalProject externalProject : selectedProjects) {
                        if (this.isShouldStopImport()) {
                            break;
                        }
                        this.stats.incrementProgress();
                        this.importProject(externalProject);
                        this.importVersions(externalProject);
                        this.importComponents(externalProject);
                    }
                }
                finally {
                    this.stats.endStep();
                }
                this.stats.beginStep(ImportStats.Stage.CUSTOM_FIELDS);
                try {
                    if (selectedProjects.isEmpty()) break block41;
                    this.log.log("Retrieving custom fields...", new Object[0]);
                    Collection<ExternalCustomField> customFields = this.dataBean.getCustomFields();
                    this.stats.setTotalItems(customFields.size());
                    Iterator<ExternalCustomField> iterator = customFields.iterator();
                    while (iterator.hasNext()) {
                        ExternalCustomField field = iterator.next();
                        if (this.isShouldStopImport()) {
                            break;
                        }
                        this.stats.incrementProgress();
                        this.verifyCustomFieldOrCreate(field);
                    }
                }
                finally {
                    this.stats.endStep();
                }
            }
            this.log.beginImportSection("Issues");
            this.stats.beginStep(ImportStats.Stage.ISSUES);
            try {
                this.stats.setTotalItems(this.dataBean.getTotalIssues(selectedProjects, this.log));
                for (ExternalProject externalProject : selectedProjects) {
                    if (this.isShouldStopImport()) break;
                    this.importIssues(externalProject);
                }
                if (this.skippedIssues > 0) {
                    this.log.warn("%d of %d issues have been skipped because they already exist in destination projects.", this.skippedIssues, this.stats.getIssuesStage().getItemsToBeImported());
                }
                if (this.unindexedIssueGvs.size() > 0) {
                    this.reindexIssues();
                }
                long totalItems = this.stats.getTotalItems();
                long importedItems = this.stats.getIssuesStage().getItemsImported();
                String fmt = (totalItems == importedItems ? "%d" : "%d out of %d") + " issues successfully created";
                this.log.log(fmt, importedItems, totalItems);
            }
            finally {
                this.stats.endStep();
                this.log.endImportSection("Issues");
            }
            this.stats.beginStep(ImportStats.Stage.LINKS);
            try {
                String string;
                Map<String, String> externalIdsToIssueKeys = this.dataBean.getExternalSystemUrl() != null ? this.getExternalIdsToIssueKeysMap(this.createQueryForExternalSystemUrl(this.dataBean.getExternalSystemUrl())) : this.getExternalIdsToIssueKeysMap(this.getSelectedProjects());
                externalIdsToIssueKeys.putAll(this.externalIdToIssueKey);
                if (!this.isShouldStopImport() && (string = this.dataBean.getIssueKeyRegex()) != null) {
                    this.rewriteOldIssueKeys(externalIdsToIssueKeys, string);
                }
                if (!this.isShouldStopImport()) {
                    this.importIssueLinks(externalIdsToIssueKeys, this.utils.areSubtasksEnabled(), this.utils.isIssueLinkingOn());
                }
            }
            finally {
                this.stats.endStep();
            }
            if (!this.usersToDeactivate.isEmpty()) {
                for (ApplicationUser applicationUser : this.usersToDeactivate) {
                    this.externalUserUtils.deactivateUser(applicationUser, this.log);
                }
                this.usersToDeactivate.clear();
            }
        }
        catch (InvalidUsernamesException e) {
            this.log.fail(e, e.getMessage(), new Object[0]);
        }
        catch (UnknownUsersException e) {
            this.log.fail(e, e.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            this.log.fail(e, "Unexpected failure occurred. Importer will stop immediately. Data may be in an unstable state", new Object[0]);
        }
        catch (Error e) {
            this.log.fail(e, "Unexpected failure occurred. Importer will stop immediately. Data may be in an unstable state", new Object[0]);
        }
        this.postImport(importerExecutionContext);
    }

    private Query createQueryForExternalSystemUrl(String externalSystemUrl) {
        Collection customFields = this.customFieldManager.getCustomFieldObjectsByName(EXTERNAL_ISSUE_URL);
        BooleanQuery query = new BooleanQuery();
        for (CustomField cf : customFields) {
            query.add((Query)new PrefixQuery(new Term(cf.getId(), externalSystemUrl)), BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    protected void preImport(ImporterExecutionContext importerExecutionContext) {
        ImportUtils.setSubvertSecurityScheme((boolean)true);
        ImportUtils.setEnableNotifications((boolean)false);
        this.stats.start();
        this.eventPublisher.publish((Object)new ImporterStartedEvent(importerExecutionContext.getExternalSystem()));
        this.skippedIssues = 0;
        this.unindexedIssueGvs.clear();
        this.mappings = new ImportObjectIdMappings();
        this.externalIdToIssueKey = Maps.newHashMap();
        this.customFieldsCache = Maps.newHashMap();
        this.callbacks = this.dataBean.getCallbacks();
        this.context = importerExecutionContext;
    }

    protected void postImport(ImporterExecutionContext importerExecutionContext) {
        if (this.isAborted()) {
            this.log.log(StringUtils.repeat((String)"-", (int)30), new Object[0]);
            this.log.log("IMPORT CANCELLED", new Object[0]);
            this.log.log("The import has been cancelled by %s. Cleaning up import...", this.abortedBy);
            this.log.log(StringUtils.repeat((String)"-", (int)30), new Object[0]);
            this.eventPublisher.publish((Object)new ImporterCancelledEvent(importerExecutionContext.getExternalSystem(), this.stats.getWarnings().size(), this.stats.getFailures().size()));
        }
        this.userProvider = null;
        this.dataBean.cleanUp();
        ImportUtils.setSubvertSecurityScheme((boolean)false);
        this.utils.getProjectManager().refresh();
        ImportUtils.setEnableNotifications((boolean)true);
        if (this.unindexedIssueGvs.size() > 0) {
            this.reindexIssues();
        } else {
            this.log.log("No issues need to be reindexed.", new Object[0]);
        }
        this.stats.stop();
        this.mappings = null;
        this.callbacks = null;
        this.context = null;
        ImporterFinishedEvent finishedEvent = new ImporterFinishedEvent(importerExecutionContext.getExternalSystem(), this.stats.getUsersStage().getItemsCreated(), this.stats.getIssuesStage().getItemsCreated(), this.stats.getProjectsStage().getItemsCreated(), this.stats.getUsersStage().getItemsToBeImported(), this.stats.getIssuesStage().getItemsToBeImported(), this.stats.getProjectsStage().getItemsToBeImported(), this.stats.getIssuesStage().getItemsUpdated(), this.stats.getFailures().size(), this.stats.getWarnings().size(), this.stats.getElapsedTime());
        finishedEvent.setImporter(this);
        this.eventPublisher.publish((Object)finishedEvent);
    }

    protected void importUsers() throws InvalidUsernamesException {
        this.log.beginImportSection("Users");
        Collection<ExternalUser> users = this.externalUserUtils.prepareUsers(this.dataBean.getAllUsers(this.log), this.userProvider, this.log);
        Set<ExternalUser> requiredUsers = this.dataBean.getRequiredUsers(this.getSelectedProjects(), this.log);
        this.stats.setTotalItems(users.size());
        int inactiveUsersDueToLicenseLimit = 0;
        int successfullyCreatedUserCount = 0;
        for (ExternalUser externalUser : users) {
            if (this.isShouldStopImport()) break;
            this.stats.incrementProgress();
            if (this.userProvider.getUser(externalUser) != null) continue;
            if (!requiredUsers.contains(externalUser)) {
                externalUser.getGroups().add(this.dataBean.getUnusedUsersGroup());
            }
            try {
                ExternalUserUtils.CreatedUserStatus createStatus = this.externalUserUtils.importUser(externalUser, this.log);
                ApplicationUser createdUser = this.userProvider.getUser(externalUser);
                this.callbacks.afterUserCreated(externalUser, createdUser);
                this.stats.incrementCreated();
                if (createStatus == ExternalUserUtils.CreatedUserStatus.InactiveInExternalSystem) {
                    this.deactivateUser(createdUser);
                    continue;
                }
                if (createStatus == ExternalUserUtils.CreatedUserStatus.InactiveDueToLicenseLimit) {
                    ++inactiveUsersDueToLicenseLimit;
                    continue;
                }
                if (createStatus == ExternalUserUtils.CreatedUserStatus.Active) {
                    ++successfullyCreatedUserCount;
                    this.createdUsers.add(createdUser);
                    continue;
                }
                if (createStatus != ExternalUserUtils.CreatedUserStatus.InactiveDueToLicenseRolesEnabled) continue;
                this.createdUsers.add(createdUser);
            }
            catch (Exception e) {
                this.log.warn(e, "Cannot create user %s", externalUser.getName());
            }
        }
        if (this.bridgeUtils.rolesEnabled()) {
            this.log.log("%d users associated with import. All of them imported as inactive, this can be changed after import in User Access step.", users.size(), successfullyCreatedUserCount);
        } else if (inactiveUsersDueToLicenseLimit > 0) {
            this.log.warn("%d users associated with import. %d were imported as inactive due to license limits. Check log for details.", users.size(), inactiveUsersDueToLicenseLimit);
        } else {
            this.log.log("%d users associated with import. %d new users were created and imported as active.", users.size(), successfullyCreatedUserCount);
        }
        this.log.endImportSection("Users");
    }

    private void deactivateUser(ApplicationUser user) {
        this.usersToDeactivate.add(user);
    }

    private Project importProject(ExternalProject externalProject) throws Exception {
        boolean wasProjectCreated;
        Project jiraProject = ExternalProjectUtils.getProject(this.projectManager, externalProject);
        if (jiraProject == null) {
            try {
                if (externalProject.getLead() != null) {
                    ApplicationUser projectLead = this.userProvider.getUser(externalProject.getLead());
                    if (projectLead != null) {
                        externalProject.setLead(projectLead.getName());
                    } else {
                        this.log.warn("Cannot find user '%s' - Current user will be set as project lead for '%s - %s'", externalProject.getLead(), externalProject.getKey(), externalProject.getName());
                        externalProject.setLead(null);
                    }
                }
                jiraProject = this.createProjectManager.createProject(this.utils.getAuthenticationContext().getUser(), externalProject, this.log);
                File projectAvatar = this.dataBean.getAvatarForProject(externalProject, this.log);
                if (projectAvatar != null) {
                    ProjectAvatarUtil.setProjectAvatar(jiraProject, projectAvatar);
                }
                if (StringUtils.isNotBlank((String)externalProject.getProjectCategoryName())) {
                    ProjectCategoryUtil.setProjectCategory(jiraProject, externalProject.getProjectCategoryName());
                }
                wasProjectCreated = true;
                this.log.log("Created Project: %s successfully", externalProject);
            }
            catch (Exception e) {
                throw new Exception("Unable to import Project " + externalProject, e);
            }
        } else {
            wasProjectCreated = false;
            this.log.log("Project %s exists and found correctly.", externalProject);
        }
        this.setProjectRoles(jiraProject, externalProject);
        this.callbacks.afterProjectCreated(externalProject, jiraProject, wasProjectCreated);
        this.stats.incrementCreated();
        externalProject.setJiraId(jiraProject.getId());
        return jiraProject;
    }

    private void setProjectRoles(Project jiraProject, ExternalProject externalProject) throws Exception {
        Set<ExternalUser> users = this.dataBean.getRequiredUsers(Collections.singleton(externalProject), this.log);
        HashMultimap userRoles = HashMultimap.create();
        userRoles.put((Object)"Developers", (Object)externalProject.getLead());
        for (ExternalUser user : users) {
            for (String role : user.getProjectRoles().get((Object)externalProject.getId())) {
                userRoles.put((Object)role, (Object)this.userProvider.getUser(user.getName()).getName());
            }
        }
        for (String role : userRoles.keySet()) {
            this.externalUserUtils.addUsersToProjectRole(this.utils.getAuthenticationContext().getUser(), jiraProject, role, userRoles.get((Object)role), this.log);
        }
    }

    private void importVersions(ExternalProject externalProject) {
        this.log.beginImportSection("Versions");
        Collection<ExternalVersion> versions = this.dataBean.getVersions(externalProject, this.log);
        if (versions != null) {
            for (ExternalVersion externalVersion : versions) {
                if (this.isShouldStopImport()) break;
                Version jiraVersion = this.versionManager.getVersion(externalProject.getJiraId(), externalVersion.getName());
                if (jiraVersion == null) {
                    this.log.log("Importing version %s", externalVersion.getName());
                    jiraVersion = this.utils.createVersion(externalProject, externalVersion, this.log);
                    if (jiraVersion != null) {
                        this.callbacks.afterVersionCreated(externalVersion, jiraVersion);
                    } else {
                        this.log.fail(null, "Unable to import version %s", externalVersion);
                    }
                }
                this.mappings.addVersionMapping(externalProject.getName(), externalVersion.getName(), jiraVersion);
            }
        }
        this.log.endImportSection("Versions");
    }

    private void importComponents(ExternalProject externalProject) {
        this.log.beginImportSection("Components");
        Collection<ExternalComponent> components = this.dataBean.getComponents(externalProject, this.log);
        if (components != null) {
            for (ExternalComponent externalComponent : components) {
                Map<String, ProjectComponent> projectComponents = this.getProjectComponents(externalProject.getJiraId());
                if (this.isShouldStopImport()) break;
                ProjectComponent jiraComponent = projectComponents.get(externalComponent.getName().toUpperCase());
                if (jiraComponent == null) {
                    this.log.log("Importing component %s", externalComponent.getName());
                    String lead = null;
                    if (StringUtils.isNotBlank((String)externalComponent.getLead())) {
                        ApplicationUser leadUser = this.userProvider.getUser(externalComponent.getLead());
                        if (leadUser != null) {
                            lead = leadUser.getName();
                        } else {
                            this.log.warn("Component lead %s not found", externalComponent.getLead());
                        }
                    }
                    if ((jiraComponent = this.createProjectComponent(externalProject, new ExternalComponent(externalComponent.getName(), externalComponent.getId(), lead, externalComponent.getDescription()), this.log)) != null) {
                        this.callbacks.afterComponentCreated(externalComponent, jiraComponent);
                    } else {
                        this.log.fail(null, "Unable to import component %s", externalComponent);
                    }
                }
                if (jiraComponent == null) continue;
                this.mappings.addComponentMapping(externalProject.getName(), externalComponent.getName(), jiraComponent);
            }
        }
        this.log.endImportSection("Components");
    }

    @Override
    public void setDataBean(ImportDataBean dataBean) {
        super.setDataBean(dataBean);
        this.userProvider = new UserProvider();
        this.createdUsers = Sets.newHashSet();
    }

    private void importIssues(ExternalProject externalProject) {
        Map<String, String> existingIssues = this.getExternalIdsToIssueKeysMap(externalProject);
        Iterator<ExternalIssue> issues = this.dataBean.getIssuesIterator(externalProject, this.log);
        HashSet assignees = Sets.newHashSet();
        long counterForProject = this.projectManager.getCurrentCounterForProject(externalProject.getJiraId());
        while (issues != null && issues.hasNext() && !this.isShouldStopImport()) {
            this.stats.incrementProgress();
            ExternalIssue externalIssue = issues.next();
            String oldId = externalIssue.getExternalId();
            if (existingIssues.containsKey(oldId)) {
                ++this.skippedIssues;
                this.log.log("External issue %s already exists as %s, not importing.", oldId, existingIssues.get(oldId));
                continue;
            }
            this.log.log("Importing issue: %s", externalIssue);
            MutableIssue lastCreatedIssue = null;
            try {
                lastCreatedIssue = this.createIssue(externalProject, externalIssue, assignees);
                Long issueKeyNumber = this.getIssueKeyNumber(lastCreatedIssue.getKey());
                if (issueKeyNumber != null) {
                    counterForProject = Math.max(counterForProject, issueKeyNumber);
                }
            }
            catch (ExternalException e) {
                this.log.fail((Throwable)((Object)e), "Error importing issue %s", externalIssue);
            }
            this.reindexIfRequired(lastCreatedIssue);
        }
        Project project = this.projectManager.getProjectObj(externalProject.getJiraId());
        this.projectManager.setCurrentCounterForProject(project, counterForProject);
        if (!assignees.isEmpty()) {
            try {
                this.externalUserUtils.addUsersToProjectRole(this.utils.getAuthenticationContext().getUser(), this.utils.getProjectManager().getProjectObj(externalProject.getJiraId()), "Developers", assignees, this.log);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Long getIssueKeyNumber(String key) {
        Matcher issueKeyMatcher = this.issueKeyParser.matcher(key);
        if (issueKeyMatcher.matches()) {
            try {
                return Long.parseLong(issueKeyMatcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.log.warn("Issue key has invalid format: '" + key + "'", new Object[0]);
        return null;
    }

    private void reindexIfRequired(@Nullable MutableIssue lastCreatedIssue) {
        IssueType issueTypeObject;
        IssueType issueType = issueTypeObject = lastCreatedIssue != null ? lastCreatedIssue.getIssueTypeObject() : null;
        if (this.unindexedIssueGvs.size() >= 50) {
            this.reindexIssues();
        } else if (issueTypeObject != null && "Epic".equals(issueTypeObject.getName())) {
            this.reindexIssues();
        }
    }

    private Map<String, String> getExternalIdsToIssueKeysMap(Set<ExternalProject> projects) {
        BooleanQuery query = new BooleanQuery();
        for (ExternalProject project : projects) {
            query.add((Query)new TermQuery(new Term("projid", "" + project.getJiraId())), BooleanClause.Occur.SHOULD);
        }
        return this.getExternalIdsToIssueKeysMap((Query)query);
    }

    private Map<String, String> getExternalIdsToIssueKeysMap(ExternalProject project) {
        return this.getExternalIdsToIssueKeysMap((Query)new TermQuery(new Term("projid", "" + project.getJiraId())));
    }

    private Map<String, String> getExternalIdsToIssueKeysMap(Query query) {
        final HashMap issueKeyMappings = Maps.newHashMap();
        final Collection ids = this.customFieldManager.getCustomFieldObjectsByName(EXTERNAL_ISSUE_ID);
        if (ids == null || ids.isEmpty()) {
            return issueKeyMappings;
        }
        IndexSearcher searcher = this.searchServiceFactory.getSearcher("issues");
        DocumentHitCollector hitCollector = new DocumentHitCollector(searcher){

            public void collect(Document document) {
                Issue issue = DefaultJiraDataImporter.this.utils.getIssueFactory().getIssue(document);
                for (CustomField cf : ids) {
                    Object value = issue.getCustomFieldValue(cf);
                    if (value == null) continue;
                    issueKeyMappings.put(value.toString(), issue.getKey());
                }
            }
        };
        try {
            searcher.search(query, (Collector)hitCollector);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return issueKeyMappings;
    }

    private MutableIssue createIssue(@Nonnull ExternalProject externalProject, @Nonnull ExternalIssue externalIssue, @Nonnull Set<String> assignees) throws ExternalException {
        GenericValue issueGV;
        this.translateIssueConstants(externalIssue);
        this.trimFieldsToLimit(externalIssue);
        boolean created = false;
        try {
            MutableIssue convertedIssue = this.utils.convertExternalIssueToIssue(this.userProvider, externalIssue, externalProject, this.mappings, this.log);
            ImmutableList externalCustomFieldValues = externalIssue.getExternalCustomFieldValues();
            if (externalIssue.getExternalId() != null && !externalIssue.isAutoExternalId()) {
                externalCustomFieldValues = ImmutableList.builder().addAll(externalCustomFieldValues).add((Object)new ExternalCustomFieldValue(EXTERNAL_ISSUE_ID, "com.atlassian.jira.plugin.system.customfieldtypes:textfield", "com.atlassian.jira.plugin.system.customfieldtypes:textsearcher", externalIssue.getExternalId())).build();
            }
            this.importExternalCustomFields(convertedIssue, (Collection<ExternalCustomFieldValue>)externalCustomFieldValues, convertedIssue.getId() == null);
            if (convertedIssue.getId() == null) {
                this.fillEmptyRequiredFields(convertedIssue);
                issueGV = this.utils.createIssue((Issue)convertedIssue, externalIssue.getStatus(), externalIssue.getResolution(), this.log);
                created = true;
            } else {
                issueGV = this.utils.updateIssue(convertedIssue, externalIssue.getStatus(), this.log);
            }
        }
        catch (ImportException e) {
            throw new ExternalException("Unable to create or update issue: " + externalIssue, (Throwable)((Object)e));
        }
        this.unindexedIssueGvs.add(issueGV);
        MutableIssue mutableIssue = this.utils.getIssueFactory().getIssue(issueGV);
        ApplicationUser assignee = this.bridgeUtils.getAssignee((Issue)mutableIssue);
        if (assignee != null) {
            assignees.add(assignee.getName());
        }
        if (externalIssue.getExternalId() != null) {
            this.externalIdToIssueKey.put(externalIssue.getExternalId(), mutableIssue.getKey());
        }
        if (externalIssue.getComments() != null) {
            this.importComments(externalIssue, (Issue)mutableIssue);
        }
        if (externalIssue.getVoters() != null) {
            this.importVoters(externalIssue, mutableIssue);
        }
        if (externalIssue.getWatchers() != null) {
            MutableIssue newIssue = this.importWatchers(externalIssue, (Issue)mutableIssue);
            MutableIssue mutableIssue2 = mutableIssue = newIssue != null ? newIssue : mutableIssue;
        }
        if (this.fieldManager.isTimeTrackingOn() && externalIssue.getWorklogs() != null) {
            this.importWorklog(externalIssue, mutableIssue.getGenericValue());
        }
        if (this.utils.areAttachmentsEnabled()) {
            try {
                Collection<ExternalAttachment> attachments = this.dataBean.getAttachmentsForIssue(externalIssue, this.log);
                for (ExternalAttachment externalAttachment : attachments) {
                    this.utils.attachFile(this.userProvider, externalAttachment, mutableIssue, this.log);
                }
            }
            catch (Exception e) {
                this.log.fail(e, "Failed to attach attachments to issue %s", mutableIssue.getKey());
            }
        }
        if (this.subTaskManager.isSubTasksEnabled()) {
            List<ExternalIssue> subtasks = externalIssue.getSubtasks();
            for (ExternalIssue externalIssue2 : subtasks) {
                MutableIssue subtask = this.createIssue(externalProject, externalIssue2, assignees);
                try {
                    this.bridgeUtils.createSubTaskIssueLink(this.subTaskManager, (Issue)mutableIssue, (Issue)subtask, this.authenticationContext.getUser());
                }
                catch (CreateException e) {
                    this.log.fail(e, "Failed to create sub-task link for %s", mutableIssue.getKey());
                }
            }
        }
        if (externalIssue.getHistory() != null) {
            this.historyImporter.importHistory(mutableIssue, externalIssue.getHistory());
        }
        if (!externalIssue.getProperties().isEmpty()) {
            ApplicationUser user = this.authenticationContext.getUser();
            for (Map.Entry entry : externalIssue.getProperties().entrySet()) {
                EntityPropertyService.PropertyInput propertyInput = new EntityPropertyService.PropertyInput((String)entry.getValue(), (String)entry.getKey());
                EntityPropertyService.SetPropertyValidationResult validationResult = this.issuePropertyService.validateSetProperty(user, mutableIssue.getId(), propertyInput);
                if (validationResult.isValid()) {
                    this.issuePropertyService.setProperty(user, validationResult);
                    continue;
                }
                String errorMessages = Joiner.on((String)", ").join((Iterable)validationResult.getErrorCollection().getErrorMessages());
                this.log.warn("Cannot add issue property with key: " + (String)entry.getKey() + " due to: " + errorMessages, new Object[0]);
            }
        }
        if (created) {
            this.callbacks.afterIssueCreated(externalIssue, (Issue)mutableIssue);
            this.stats.incrementCreated();
        } else {
            this.callbacks.afterIssueUpdated(externalIssue, (Issue)mutableIssue);
            this.stats.incrementUpdated();
        }
        return mutableIssue;
    }

    private void trimFieldsToLimit(ExternalIssue externalIssue) {
        String environment;
        String description;
        String summary = externalIssue.getSummary();
        if (summary != null && (long)summary.length() > SummarySystemField.MAX_LEN) {
            this.logFieldTrimmed("Summary", SummarySystemField.MAX_LEN);
            externalIssue.setSummary(StringUtils.abbreviate((String)summary, (int)SummarySystemField.MAX_LEN.intValue()));
        }
        if (this.textFieldCharacterLengthValidator.isTextTooLong(description = externalIssue.getDescription())) {
            this.logFieldTrimmed("Description", this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters());
            externalIssue.setDescription(StringUtils.abbreviate((String)description, (int)Ints.saturatedCast((long)this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters())));
        }
        if (this.textFieldCharacterLengthValidator.isTextTooLong(environment = externalIssue.getEnvironment())) {
            this.logFieldTrimmed("Environment", this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters());
            externalIssue.setEnvironment(StringUtils.abbreviate((String)environment, (int)Ints.saturatedCast((long)this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters())));
        }
    }

    private void logFieldTrimmed(String fieldName, long length) {
        this.log.log("%2$s longer than max length of %1$d. Truncating to %1$d characters.", length, fieldName);
    }

    private void fillEmptyRequiredFields(final MutableIssue issue) {
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(issue.getProjectObject(), issue.getIssueTypeObject().getId());
        List fieldLayoutItems = fieldLayout.getFieldLayoutItems();
        Iterable emptyRequiredFields = Iterables.filter((Iterable)fieldLayoutItems, (Predicate)new Predicate<FieldLayoutItem>(){

            public boolean apply(FieldLayoutItem fieldLayoutItem) {
                if (fieldLayoutItem.isRequired()) {
                    boolean hasValue;
                    OrderableField orderableField = fieldLayoutItem.getOrderableField();
                    try {
                        hasValue = orderableField instanceof CustomField ? issue.getCustomFieldValue((CustomField)orderableField) != null : orderableField.hasValue((Issue)issue);
                    }
                    catch (Exception e) {
                        return false;
                    }
                    if (orderableField != null && !hasValue) {
                        return true;
                    }
                }
                return false;
            }
        });
        for (FieldLayoutItem fieldLayoutItem : emptyRequiredFields) {
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            HashMap fieldValueHolder = Maps.newHashMap();
            orderableField.populateDefaults((Map)fieldValueHolder, (Issue)issue);
            orderableField.updateIssue(fieldLayoutItem, issue, (Map)fieldValueHolder);
        }
    }

    private void translateIssueConstants(ExternalIssue externalIssue) throws ExternalException {
        String[] constantTypes;
        for (String constantType : constantTypes = new String[]{ConstantsManager.ISSUE_TYPE_CONSTANT_TYPE, ConstantsManager.PRIORITY_CONSTANT_TYPE, ConstantsManager.RESOLUTION_CONSTANT_TYPE}) {
            String id;
            String issueConstantKey = constantType.toLowerCase();
            String constantValue = externalIssue.getField(issueConstantKey);
            if (constantValue == "<<!clear!>>" || !StringUtils.isNotEmpty((String)constantValue)) continue;
            IssueConstant constant = this.createConstantsManager.getConstant(constantValue, constantType);
            if (constant == null && ConstantsManager.RESOLUTION_CONSTANT_TYPE.equals(constantType) && this.isUnresolvedString(constantValue)) {
                id = null;
            } else if (constant == null) {
                id = this.createConstantsManager.addConstant(constantValue, constantType);
                this.log.log("Created %s : %s with id %s", constantType, constantValue, id);
            } else {
                id = constant.getId();
            }
            externalIssue.setField(issueConstantKey, id);
        }
    }

    private boolean isUnresolvedString(String constantValue) {
        return "Unresolved".equalsIgnoreCase(constantValue) || this.getI18nHelper().getText("common.resolution.unresolved").equalsIgnoreCase(constantValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importVoters(ExternalIssue externalIssue, MutableIssue issue) throws ExternalException {
        String resolutionId = issue.getResolutionId();
        Timestamp resolutionDate = issue.getResolutionDate();
        issue.setResolutionId(null);
        try {
            for (String username : externalIssue.getVoters()) {
                ApplicationUser voter = this.userProvider.getUser(username);
                if (voter == null) {
                    throw new ExternalException("No such user: " + username);
                }
                if (this.voteManager.addVote(voter, (Issue)issue)) continue;
                this.log.log("Failed to import vote on %s", issue.getKey());
            }
        }
        finally {
            issue.setResolutionId(resolutionId);
            issue.setResolutionDate(resolutionDate);
        }
    }

    private MutableIssue importWatchers(ExternalIssue externalIssue, Issue issue) throws ExternalException {
        for (String username : externalIssue.getWatchers()) {
            try {
                ApplicationUser watcher = this.userProvider.getUser(username);
                if (watcher != null) {
                    issue = this.bridgeUtils.startWatching(this.watcherManager, watcher, issue);
                    continue;
                }
                this.log.warn("Watcher '%s' doesn't have an account in JIRA", username);
            }
            catch (RuntimeException e) {
                this.log.fail(e, "Failed to add a watcher to issue with id '%s'", externalIssue.getExternalId());
            }
        }
        if (issue instanceof MutableIssue) {
            return (MutableIssue)issue;
        }
        return null;
    }

    protected void importWorklog(ExternalIssue externalIssue, GenericValue issueGV) throws ExternalException {
        for (ExternalWorklog externalWorklog : externalIssue.getWorklogs()) {
            MutableIssue issue = this.utils.getIssueFactory().getIssue(issueGV);
            ApplicationUser user = this.userProvider.getUser(externalWorklog.getAuthor());
            DateTime startDate = externalWorklog.getStartDate();
            WorklogImpl worklog = new WorklogImpl(this.worklogManager, (Issue)issue, null, user != null ? user.getKey() : null, externalWorklog.getComment(), startDate != null ? startDate.toDate() : new Date(), null, null, externalWorklog.getTimeSpent());
            this.bridgeUtils.createWorklog(user, (Worklog)worklog);
        }
    }

    private void importComments(ExternalIssue externalIssue, Issue issue) {
        for (ExternalComment externalComment : externalIssue.getComments()) {
            try {
                DateTime commentDate = externalComment.getCreated();
                if (commentDate == null) {
                    commentDate = externalIssue.getUpdated() != null ? externalIssue.getUpdated() : externalIssue.getCreated();
                }
                this.utils.addComments(this.userProvider, issue, new ExternalComment(this.trimCommentBodyToLimit(externalComment.getBody()), externalComment.getAuthor(), commentDate), false, false, this.log);
            }
            catch (ExternalException e) {
                this.log.fail((Throwable)((Object)e), "Unable to import comment %s", externalComment);
            }
        }
    }

    private String trimCommentBodyToLimit(String body) {
        if (this.textFieldCharacterLengthValidator.isTextTooLong(body)) {
            this.logFieldTrimmed("Comment body", this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters());
            return StringUtils.abbreviate((String)body, (int)Ints.saturatedCast((long)this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters()));
        }
        return body;
    }

    protected Option<CustomField> verifyCustomFieldOrCreate(ExternalCustomFieldValue fieldValue) throws ExternalException {
        String cfName = fieldValue.getFieldName();
        if (!this.customFieldsCache.containsKey(cfName)) {
            ExternalCustomField customField = new ExternalCustomField(cfName, cfName, fieldValue.getFieldType(), fieldValue.getSearcherType());
            return Option.option((Object)this.verifyCustomFieldOrCreate(customField));
        }
        return this.customFieldsCache.get(cfName);
    }

    protected CustomField verifyCustomFieldOrCreate(ExternalCustomField customField) throws ExternalException {
        CustomField neededCustomField;
        Set<ExternalProject> selectedProjects = this.getSelectedProjects();
        Optional<CustomField> existingCustomField = this.customFieldsUtil.getExistingCustomField(customField, selectedProjects);
        if (!existingCustomField.isPresent() && this.context.getOptions().canCreateCustomFields()) {
            neededCustomField = this.createNewCustomField(customField);
        } else if (!existingCustomField.isPresent()) {
            neededCustomField = null;
        } else {
            ProjectContext projectContext = new ProjectContext(selectedProjects.iterator().next().getJiraId());
            neededCustomField = (CustomField)existingCustomField.get();
            this.customFieldsUtil.addOptions(neededCustomField, customField.getValueSet(), (IssueContext)projectContext);
        }
        this.customFieldsCache.put(customField.getName(), (Option<CustomField>)Option.option((Object)neededCustomField));
        return neededCustomField;
    }

    private CustomField createNewCustomField(ExternalCustomField customField) throws ExternalException {
        this.log.log("Custom field not found. Creating a new custom field for %s", customField);
        CustomField createdCustomField = this.customFieldsUtil.createNewCustomField(customField, this.getSelectedProjects());
        this.callbacks.afterCustomFieldCreated(customField, createdCustomField);
        this.stats.getStage(ImportStats.Stage.CUSTOM_FIELDS).incrementCreated();
        CustomField neededCustomField = createdCustomField;
        return neededCustomField;
    }

    protected void importExternalCustomFields(MutableIssue issue, Collection<ExternalCustomFieldValue> fieldValues, boolean isNewIssue) throws ExternalException {
        for (ExternalCustomFieldValue customFieldValue : fieldValues) {
            String valueString;
            Option<CustomField> matchingCustomField = this.verifyCustomFieldOrCreate(customFieldValue);
            if (matchingCustomField.isEmpty()) {
                this.log.warn("Custom Field [ %s ] was not found and cannot be created", customFieldValue.getFieldName());
                continue;
            }
            Set<ExternalProject> selectedProjects = this.getSelectedProjects();
            CustomField customField = (CustomField)matchingCustomField.get();
            Either<String, Boolean> fieldIsApplicableForIssue = this.customFieldsUtil.makeSureCustomFieldIsApplicableForIssue(customField, (Issue)issue, this.context.getOptions());
            if (fieldIsApplicableForIssue.isLeft()) {
                this.log.warn((String)fieldIsApplicableForIssue.left().get(), new Object[0]);
                continue;
            }
            if (!((Boolean)fieldIsApplicableForIssue.right().get()).booleanValue()) continue;
            Object value = this.trimTextCustomFieldToLimit(customField, customFieldValue.getValue());
            if (this.customFieldsUtil.isValueEmpty(value)) {
                String valueString2;
                String string = valueString2 = value != null ? value.toString() : "null";
                if (isNewIssue) {
                    this.log.log("Ignoring empty [ %s ] for CustomField %s in Issue '%s'", valueString2, customField.getName(), issue.getSummary());
                    continue;
                }
                this.log.log("Value [ %s ] was interpreted as empty for CustomField %s in Issue %s. Custom Field will be cleared.", valueString2, customField.getName(), issue.getKey());
                this.clearCustomFieldValue(issue, customField);
                continue;
            }
            if ("<<!clear!>>".equals(value)) {
                this.clearCustomFieldValue(issue, customField);
                continue;
            }
            this.customFieldsUtil.addOptions(customField, value, (IssueContext)issue);
            try {
                boolean wasAddedSuccessfully = this.customFieldsUtil.setCustomFieldValueForIssue(customField, value, issue);
                if (wasAddedSuccessfully) continue;
                valueString = value != null ? value.toString() : "null";
                this.log.warn("Cannot add value [ %s ] to CustomField %s in Issue with summary '%s'. Probably value was in incorrect format", valueString, customField.getName(), issue.getSummary());
            }
            catch (Exception e) {
                valueString = value != null ? value.toString() : "null";
                this.log.warn(e, "Cannot add value [ %s ] to CustomField %s in Issue with summary '%s'. Exception Message: %s", valueString, customField.getName(), issue.getSummary(), e.getMessage());
            }
        }
    }

    private Object trimTextCustomFieldToLimit(CustomField customField, Object customFieldValue) {
        String stringValue;
        Object singleValue;
        if (!this.getTextCustomFieldClass().isEmpty() && ((Class)this.getTextCustomFieldClass().get()).isAssignableFrom(customField.getCustomFieldType().getClass()) && (singleValue = this.customFieldsUtil.normalizeToCollection(customFieldValue).iterator().next()) instanceof String && this.textFieldCharacterLengthValidator.isTextTooLong(stringValue = (String)singleValue)) {
            this.logFieldTrimmed(customField.getName(), this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters());
            return StringUtils.abbreviate((String)stringValue, (int)Ints.saturatedCast((long)this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters()));
        }
        return customFieldValue;
    }

    private Option<? extends Class> getTextCustomFieldClass() {
        if (this.textCustomFieldType == null) {
            try {
                this.textCustomFieldType = Option.some(Class.forName("com.atlassian.jira.issue.customfields.TextCustomFieldType"));
            }
            catch (Exception e) {
                this.log.log("Text custom fields will not be trimmed to character limit - class 'com.atlassian.jira.issue.customfields.TextCustomFieldType' is not available.", new Object[0]);
                this.textCustomFieldType = Option.none();
            }
        }
        return this.textCustomFieldType;
    }

    private void clearCustomFieldValue(MutableIssue issue, CustomField customField) {
        boolean clearValueSuccessful = this.customFieldsUtil.clearValueForIssue(customField, (Issue)issue);
        if (!clearValueSuccessful) {
            this.log.warn("Removing value for custom field '%s' from issue %s is not supported, skipping.", customField.getName(), issue.getKey());
        }
    }

    private void rewriteOldIssueKeys(Map<String, String> issueKeyMappings, String regex) {
        try {
            this.log.log("Rewriting old issue keys for %d issues", issueKeyMappings.size());
            for (String issueKey : issueKeyMappings.values()) {
                String newDescription;
                MutableIssue issue = this.utils.getIssueManager().getIssueObject(issueKey);
                if (issue == null) continue;
                String oldSummary = issue.getSummary();
                String newSummary = DefaultJiraDataImporter.rewriteStringWithIssueKeys(regex, issueKeyMappings, oldSummary);
                String oldDescription = issue.getDescription();
                if (!(oldDescription == null || oldDescription.equals(newDescription = DefaultJiraDataImporter.rewriteStringWithIssueKeys(regex, issueKeyMappings, oldDescription)) && oldSummary.equals(newSummary))) {
                    this.log.log("Rewritten summary and/or description for issue %s", issueKey);
                    issue.setSummary(newSummary);
                    issue.setDescription(newDescription);
                    issue.store();
                }
                List comments = this.utils.getGenericDelegator().findByAnd("Action", EasyMap.build((Object)"type", (Object)"comment", (Object)"issue", (Object)issue.getId()));
                for (GenericValue comment : comments) {
                    String newComment;
                    String oldComment = comment.getString("body");
                    if (oldComment.equals(newComment = DefaultJiraDataImporter.rewriteStringWithIssueKeys(regex, issueKeyMappings, oldComment))) continue;
                    this.log.log("Rewritten comment for issue %s", issueKey);
                    comment.setString("body", newComment);
                    comment.store();
                }
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    void importIssueLinks(Map<String, String> issueKeyMappings, boolean shouldImportSubTasks, boolean shouldImportRegularLinks) {
        if (!shouldImportRegularLinks && !shouldImportSubTasks) {
            return;
        }
        StringBuilder info = this.getIssueLinkingInfoHeader(shouldImportSubTasks, shouldImportRegularLinks);
        this.log.beginImportSection("Issue " + info);
        Collection<ExternalLink> links = this.dataBean.getLinks(this.log);
        if (links != null) {
            for (ExternalLink externalLink : links) {
                if (StringUtils.isBlank((String)externalLink.getName()) || !shouldImportSubTasks && externalLink.isSubtask() || !shouldImportRegularLinks && !externalLink.isSubtask()) continue;
                try {
                    Issue sourceIssue = this.getIssueFromMapping(issueKeyMappings, externalLink.getSourceId());
                    if (sourceIssue == null) {
                        this.log.fail(null, this.formatLinkingFailureIssueNotFoundMessage(externalLink, externalLink.getSourceId()), new Object[0]);
                        continue;
                    }
                    Issue destinationIssue = this.getIssueFromMapping(issueKeyMappings, externalLink.getDestinationId());
                    if (destinationIssue == null) {
                        this.log.fail(null, this.formatLinkingFailureIssueNotFoundMessage(externalLink, externalLink.getDestinationId()), new Object[0]);
                        continue;
                    }
                    if (StringUtils.equals((String)sourceIssue.getKey(), (String)destinationIssue.getKey())) continue;
                    this.log.log("Linking '%s' and '%s' as %s", sourceIssue.getKey(), destinationIssue.getKey(), externalLink.getName());
                    this.utils.createIssueLink(sourceIssue, destinationIssue, externalLink.getName(), externalLink.getSequence(), externalLink.isSubtask(), this.log);
                }
                catch (ExternalException e) {
                    this.log.fail(null, "%s", this.formatLinkingFailureMessage(externalLink, e.getMessage()));
                }
            }
        }
        this.log.endImportSection("Issue " + info);
    }

    @Nullable
    private Issue getIssueFromMapping(Map<String, String> issueKeyMappings, String issueId) {
        if (issueKeyMappings.get(issueId) != null) {
            return this.utils.getIssueManager().getIssueObject(issueKeyMappings.get(issueId));
        }
        return this.utils.getIssueManager().getIssueObject(issueId);
    }

    private String formatLinkingFailureIssueNotFoundMessage(ExternalLink externalLink, String missingId) {
        String message = this.getI18nHelper().getText("jira-importer-plugin.import.importedIssueNotFound", missingId);
        return this.formatLinkingFailureMessage(externalLink, message);
    }

    private String formatLinkingFailureMessage(ExternalLink externalLink, String message) {
        return this.getI18nHelper().getText("jira-importer-plugin.import.linkingFailure", externalLink.getName(), externalLink.getSourceId(), externalLink.getDestinationId(), message);
    }

    private StringBuilder getIssueLinkingInfoHeader(boolean shouldImportSubTasks, boolean shouldImportRegularLinks) {
        StringBuilder info = new StringBuilder();
        if (shouldImportRegularLinks) {
            info.append("Links");
        }
        if (shouldImportSubTasks) {
            if (info.length() > 0) {
                info.append(" & ");
            }
            info.append("Subtasks");
        }
        return info;
    }

    @Override
    public Set<ApplicationUser> getCreatedActiveUsers() {
        return this.createdUsers;
    }

    private void reindexIssues() {
        try {
            this.log.log("Reindexing last %d issues imported ...", this.unindexedIssueGvs.size());
            long l = this.indexManager.reIndexIssues(this.unindexedIssueGvs);
            this.log.log("Reindexing took %d ms.", l);
            this.unindexedIssueGvs.clear();
        }
        catch (IndexException e) {
            this.log.fail(e, "Reindexing failed", new Object[0]);
        }
    }

    private boolean isShouldStopImport() {
        return this.isAborted();
    }

    public final boolean isExternalUserManagementEnabled() {
        return this.utils.getApplicationProperties().getOption("jira.option.user.externalmanagement");
    }

    private I18nHelper getI18nHelper() {
        return this.utils.getAuthenticationContext().getI18nHelper();
    }

    public Map<String, ProjectComponent> getProjectComponents(Long projectId) {
        return Maps.uniqueIndex((Iterable)this.componentManager.findAllForProject(projectId), (Function)new Function<ProjectComponent, String>(){

            public String apply(ProjectComponent input) {
                return input.getName().toUpperCase();
            }
        });
    }

    @Nullable
    public ProjectComponent createProjectComponent(ExternalProject externalProject, ExternalComponent externalComponent, ImportLogger log) {
        try {
            String componentName = externalComponent.getName();
            ProjectComponent projectComponent = this.componentManager.create(componentName, externalComponent.getDescription(), this.userKeyService.getKeyForUsername(externalComponent.getLead()), 0L, externalProject.getJiraId());
            return projectComponent;
        }
        catch (Exception e) {
            log.warn(e, "Problems encoutered while creating Component %s", externalComponent);
            return null;
        }
    }

    public class UserProvider
    implements com.atlassian.jira.plugins.importer.external.UserProvider {
        private final Map<String, String> aliasedByEmail = new CaseInsensitiveMap();

        @Nullable
        public ApplicationUser getUserByEmail(String email) {
            if (StringUtils.isNotEmpty((String)email) && !"noreplay@example.com".equals(email)) {
                return ApplicationUsers.from((User)((User)Iterables.getOnlyElement((Iterable)DefaultJiraDataImporter.this.crowdService.search((com.atlassian.crowd.embedded.api.Query)new UserQuery(User.class, (SearchRestriction)new TermRestriction(UserTermKeys.EMAIL, MatchMode.EXACTLY_MATCHES, (Object)StringUtils.stripToEmpty((String)email).toLowerCase()), 0, 1)), null)));
            }
            return null;
        }

        @Nullable
        public ApplicationUser getUser(ExternalUser externalUser) {
            ApplicationUser user = ApplicationUsers.from((User)DefaultJiraDataImporter.this.crowdService.getUser(externalUser.getName()));
            if (user == null && (user = this.getUserByEmail(externalUser.getEmail())) != null) {
                this.aliasedByEmail.put(externalUser.getName(), user.getName());
            }
            return user;
        }

        @Override
        public ApplicationUser getUser(@Nullable String username) {
            if (username != null) {
                ApplicationUser user = ApplicationUsers.from((User)DefaultJiraDataImporter.this.crowdService.getUser(username));
                if (user == null && this.aliasedByEmail.containsKey(username)) {
                    user = ApplicationUsers.from((User)DefaultJiraDataImporter.this.crowdService.getUser(this.aliasedByEmail.get(username)));
                }
                return user;
            }
            return null;
        }
    }

    private static class CreateLabelFromString
    implements LabelParser.CreateFromString<Label> {
        private CreateLabelFromString() {
        }

        public Label create(String stringIn) {
            return new Label(null, null, null, stringIn);
        }
    }
}

