/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer.impl;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.HttpDownloader;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.sample.AvatarsProvider;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class DefaultAvatarsProvider
implements AvatarsProvider {
    private final HttpDownloader downloader = new HttpDownloader();
    private final JiraHome jiraHome;

    public DefaultAvatarsProvider(JiraHome jiraHome) {
        this.jiraHome = jiraHome;
    }

    @Override
    @Nonnull
    public File getAvatarForProject(ExternalProject externalProject, ImportLogger log) {
        if (StringUtils.isBlank((String)externalProject.getAvatarUrl())) {
            return null;
        }
        try {
            URI avatarUri = new URI(externalProject.getAvatarUrl());
            if ("file".equals(avatarUri.getScheme())) {
                String filePart = avatarUri.getSchemeSpecificPart();
                File importAttachmentsDirectory = this.jiraHome.getImportAttachmentsDirectory();
                File sourceFile = new File(importAttachmentsDirectory, filePart).getCanonicalFile();
                if (!StringUtils.startsWith((String)sourceFile.getAbsolutePath(), (String)importAttachmentsDirectory.getCanonicalPath())) {
                    log.warn("Avatar file is outside of permitted base directory, skipping: %s", filePart);
                    return null;
                }
                if (!sourceFile.exists() || !sourceFile.canRead()) {
                    log.warn("Avatar file not found or not readable, skipping: %s", sourceFile.getAbsolutePath());
                    return null;
                }
                return sourceFile;
            }
            return this.downloader.getAttachmentFromUrl(null, externalProject.getName(), avatarUri.toString());
        }
        catch (IOException e) {
            log.warn(e, "An exception occurred dealing with attachment '%s'.", externalProject.getAvatarUrl());
        }
        catch (URISyntaxException e) {
            log.warn(e, "Invalid URI '%s'", externalProject.getAvatarUrl());
        }
        return null;
    }
}

