/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer.impl;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.plugins.importer.BackCompatibilityUtil;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.ImportStats;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.imports.importer.impl.FileImportLogger;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public abstract class AbstractDataImporter
implements JiraDataImporter {
    protected final TaskManager taskManager;
    protected final BackCompatibilityUtil backCompatibilityUtil;
    protected final JiraAuthenticationContext authenticationContext;
    protected Long taskId;
    protected ImportLogger log;
    protected ImportStats stats;
    private Set<ExternalProject> selectedProjects;
    protected ImportDataBean dataBean;
    protected volatile String abortedBy;
    protected final AtomicBoolean aborted = new AtomicBoolean(false);
    private File logFile;

    public AbstractDataImporter(TaskManager taskManager, BackCompatibilityUtil backCompatibilityUtil, JiraAuthenticationContext authenticationContext) {
        this.taskManager = taskManager;
        this.backCompatibilityUtil = backCompatibilityUtil;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    @Override
    public boolean isRunning() {
        TaskDescriptor task;
        TaskDescriptor taskDescriptor = task = this.taskId != null ? this.taskManager.getTask(this.taskId) : null;
        if (task == null || task.isFinished()) {
            if (task != null) {
                this.backCompatibilityUtil.removeTask(this.taskManager, this.taskId);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isAborted() {
        return this.aborted.get();
    }

    @Override
    public void abort(String username) {
        this.aborted.set(true);
        this.abortedBy = username;
    }

    @Override
    public String getAbortedBy() {
        return this.abortedBy;
    }

    public Set<ExternalUser> getNonExistentAssociatedUsers() {
        return ImmutableSet.of();
    }

    @Override
    @Nullable
    public ImportStats getStats() {
        if (this.stats != null) {
            this.stats.setRunning(this.isRunning());
            this.stats.setAborted(this.isAborted());
        }
        return this.stats;
    }

    @Override
    @Nullable
    public ImportLogger getLog() {
        return this.log;
    }

    @Override
    public void setDataBean(ImportDataBean dataBean) {
        this.dataBean = dataBean;
        this.selectedProjects = null;
    }

    @Override
    public ImportDataBean getDataBean() {
        return this.dataBean;
    }

    @Override
    public void initializeLog() {
        this.aborted.set(false);
        this.stats = new ImportStats(new DateUtils(this.authenticationContext.getI18nHelper().getDefaultResourceBundle()), this.authenticationContext.getI18nHelper());
        this.log = new FileImportLogger(this.getLogFile()){

            @Override
            public void fail(@Nullable Throwable e, String fmt, Object ... args) {
                super.fail(e, fmt, args);
                this.incrementFailures(fmt, args);
            }

            private void incrementFailures(String fmt, Object ... args) {
                if (AbstractDataImporter.this.stats != null) {
                    AbstractDataImporter.this.stats.incrementFailures(String.format(fmt, args));
                }
            }

            private void incrementWarnings(String fmt, Object ... args) {
                if (AbstractDataImporter.this.stats != null) {
                    AbstractDataImporter.this.stats.incrementWarnings(String.format(fmt, args));
                }
            }

            @Override
            public void warn(@Nullable Throwable e, String s, Object ... args) {
                super.warn(e, s, args);
                this.incrementWarnings(s, args);
            }
        };
    }

    protected File getLogFile() {
        if (this.logFile != null && this.logFile.exists()) {
            this.logFile.delete();
            this.logFile = null;
        }
        try {
            this.logFile = File.createTempFile("jiraImportersPlugin-", ".log");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.logFile;
    }

    @Override
    public synchronized Set<ExternalProject> getSelectedProjects() {
        if (this.selectedProjects == null) {
            if (this.dataBean == null) {
                return ImmutableSet.of();
            }
            this.selectedProjects = ImmutableSet.copyOf(this.dataBean.getSelectedProjects(this.log));
        }
        return this.selectedProjects;
    }

    @Override
    public Set<ApplicationUser> getCreatedActiveUsers() {
        return ImmutableSet.of();
    }
}

