/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.plugins.importer.imports.importer.ImportStageStats;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.time.StopWatch;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ImportStats {
    private final LinkedHashSet<String> failures = Sets.newLinkedHashSet();
    private final LinkedHashSet<String> warnings = Sets.newLinkedHashSet();
    boolean running;
    boolean aborted;
    @XmlTransient
    private final StopWatch timer = new StopWatch();
    @XmlTransient
    private Stage currentStep;
    private final Map<Stage, ImportStageStats> stages;

    public ImportStats(DateUtils dateUtils, I18nHelper i18nHelper) {
        this.stages = MapBuilder.newBuilder().add((Object)Stage.VALIDATE, (Object)new ImportStageStats(dateUtils, i18nHelper)).add((Object)Stage.USERS, (Object)new ImportStageStats(dateUtils, i18nHelper)).add((Object)Stage.CUSTOM_FIELDS, (Object)new ImportStageStats(dateUtils, i18nHelper)).add((Object)Stage.PROJECTS, (Object)new ImportStageStats(dateUtils, i18nHelper)).add((Object)Stage.ISSUES, (Object)new ImportStageStats(dateUtils, i18nHelper)).add((Object)Stage.LINKS, (Object)new ImportStageStats(dateUtils, i18nHelper)).toMap();
        this.currentStep = Stage.USERS;
    }

    public void incrementFailures(String format) {
        this.stages.get((Object)this.currentStep).incrementFailures();
        if (this.failures.size() < 100) {
            this.failures.add(format);
        }
    }

    public void incrementWarnings(String format) {
        this.stages.get((Object)this.currentStep).incrementWarnings();
        if (this.warnings.size() < 100) {
            this.warnings.add(format);
        }
    }

    public LinkedHashSet<String> getFailures() {
        return this.failures;
    }

    public LinkedHashSet<String> getWarnings() {
        return this.warnings;
    }

    public void setTotalItems(long total) {
        this.stages.get((Object)this.currentStep).setItemsToBeImported(total);
    }

    public long getTotalItems() {
        return this.stages.get((Object)this.currentStep).getItemsToBeImported();
    }

    public int incrementProgress() {
        return this.stages.get((Object)this.currentStep).incrementProgress();
    }

    public int incrementCreated() {
        return this.stages.get((Object)this.currentStep).incrementCreated();
    }

    public int incrementUpdated() {
        return this.stages.get((Object)this.currentStep).incrementUpdated();
    }

    public int incrementCreatedWithWarnings() {
        return this.stages.get((Object)this.currentStep).incrementCreatedWithWarnings();
    }

    public void start() {
        this.timer.reset();
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
    }

    public long getElapsedTime() {
        return this.timer.getTime();
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public void beginStep(Stage step) {
        this.currentStep = step;
        if (this.currentStep != null) {
            this.stages.get((Object)this.currentStep).start();
        }
    }

    public void endStep() {
        if (this.currentStep != null) {
            this.stages.get((Object)this.currentStep).stop();
        }
    }

    public ImportStageStats getStage(Stage stage) {
        return this.stages.get((Object)stage);
    }

    public ImportStageStats getProjectsStage() {
        return this.getStage(Stage.PROJECTS);
    }

    public ImportStageStats getIssuesStage() {
        return this.getStage(Stage.ISSUES);
    }

    public ImportStageStats getUsersStage() {
        return this.getStage(Stage.USERS);
    }

    public static enum State {
        RUNNING,
        SUCCESS,
        ERROR;

    }

    public static enum Stage {
        VALIDATE,
        USERS,
        CUSTOM_FIELDS,
        PROJECTS,
        ISSUES,
        LINKS;

    }
}

