/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.ExistingCustomFieldsPredicate;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ParameterUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class AbstractConfigBean2
extends AbstractConfigBean {
    public static final String PROJECT_SELECTION_PREFIX = "projectSelection";
    public static final String PROJECT_KEY_CONFIG_PREFIX = "projectKey";
    public static final String PROJECT_NAME_CONFIG_PREFIX = "projectName";
    public static final String PROJECT_LEAD_CONFIG_PREFIX = "projectLead";
    public static final String PROJECT_TYPE_CONFIG_PREFIX = "projectType";
    public static final String FIELD_CONFIG_PREFIX = "field";
    public static final String LINK_CONFIG_PREFIX = "link";
    public static final String ROLE_USERS = "Users";
    public static final String ROLE_DEVELOPERS = "Developers";
    public static final String ROLE_ADMINISTRATORS = "Administrators";
    protected final Map<String, String> projectKeyMapping = Maps.newLinkedHashMap();
    protected final Map<String, String> projectNameMapping = Maps.newLinkedHashMap();
    protected final Map<String, String> projectLeadMapping = Maps.newLinkedHashMap();
    protected final Map<String, String> projectTypeMapping = Maps.newLinkedHashMap();
    protected final Map<String, String> fieldMapping = Maps.newLinkedHashMap();
    protected final Map<String, String> linkMapping = Maps.newLinkedHashMap();
    private final Map<String, String> projectSelectionMapping = Maps.newHashMap();
    private ValueMappingHelper valueMappingHelper;
    private static final String ISSUE_FIELD_MAPPING = "issue-field:";
    private static final Predicate<CustomField> IS_GH_RANKING = new Predicate<CustomField>(){

        public boolean apply(CustomField input) {
            return "com.pyxis.greenhopper.jira:greenhopper-ranking".equals(input.getCustomFieldType().getKey());
        }
    };

    protected CustomFieldManager getCustomFieldManager() {
        return ComponentAccessor.getCustomFieldManager();
    }

    protected Map<String, String> getAvailableCustomFieldMappings(ExternalCustomField customField, Set<ExternalProject> projects) {
        CustomFieldManager customFieldManager = this.getCustomFieldManager();
        LinkedHashMap fieldMappings = Maps.newLinkedHashMap();
        ArrayList customFields = Lists.newArrayList((Iterable)Iterables.filter((Iterable)customFieldManager.getCustomFieldObjects(), (Predicate)new ExistingCustomFieldsPredicate(customField, projects, false)));
        for (CustomField cf : customFields) {
            fieldMappings.put(cf.getName(), cf.getName());
        }
        if (!fieldMappings.containsKey(customField.getName())) {
            fieldMappings.put(customField.getName(), customField.getName());
        }
        return fieldMappings;
    }

    public Map<String, Map<String, String>> getAvailableFieldMappings(ExternalCustomField customField, Set<ExternalProject> projects) {
        LinkedHashMap fieldMappings = Maps.newLinkedHashMap();
        fieldMappings.put(this.getI18nHelper().getText("admin.csv.import.mappings.custom.fields.header"), this.getAvailableCustomFieldMappings(customField, projects));
        return fieldMappings;
    }

    @Override
    @Nullable
    public String getProjectKey(String projectName) {
        return this.projectKeyMapping.get(projectName);
    }

    @Override
    public String getProjectName(String projectName) {
        return StringUtils.defaultIfEmpty((String)this.projectNameMapping.get(projectName), (String)projectName);
    }

    @Override
    @Nullable
    public String getProjectLead(String projectName) {
        return this.projectLeadMapping.get(projectName);
    }

    @Override
    @Nullable
    public String getProjectTypeKey(String projectName) {
        return this.projectTypeMapping.get(projectName);
    }

    protected void initializeProjectSelectionMapping() {
        List<String> projectNames = this.getExternalProjectNames();
        for (String projectName : projectNames) {
            this.projectSelectionMapping.put(projectName, Boolean.TRUE.toString());
        }
    }

    public boolean isProjectSelected(String projectName) {
        String res;
        if (this.projectSelectionMapping.isEmpty()) {
            this.initializeProjectSelectionMapping();
        }
        return (res = this.projectSelectionMapping.get(projectName)) != null ? Boolean.valueOf(res) : false;
    }

    public void populateFieldMappings(Map actionParams, ErrorCollection errors) {
        for (ExternalCustomField field : this.getCustomFields()) {
            String keyMapping = ParameterUtils.getStringParam((Map)actionParams, (String)field.getId());
            this.fieldMapping.put(field.getId(), keyMapping);
        }
    }

    public String getLinkMapping(String linkName) {
        return this.linkMapping.get(linkName);
    }

    public void populateLinkMappings(Map actionParams) {
        for (String linkName : this.getLinkNamesFromDb()) {
            String keyMapping = ParameterUtils.getStringParam((Map)actionParams, (String)linkName);
            this.linkMapping.put(linkName, keyMapping);
        }
    }

    public Map<String, String> getAvailableLinkMappings() {
        ArrayList list = new ArrayList(this.getIssueLinkTypeManager().getIssueLinkTypes());
        Collections.sort(list, new Comparator<IssueLinkType>(){

            @Override
            public int compare(IssueLinkType o1, IssueLinkType o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        HashMap<String, String> result = new HashMap<String, String>();
        for (IssueLinkType ilt : list) {
            result.put(ilt.getName(), ilt.getName());
        }
        return result;
    }

    public abstract List<String> getExternalProjectNames();

    public abstract List<ExternalCustomField> getCustomFields();

    public abstract List<String> getLinkNamesFromDb();

    public abstract ValueMappingHelper initializeValueMappingHelper();

    public ValueMappingHelper getValueMappingHelper() {
        if (this.valueMappingHelper == null) {
            this.valueMappingHelper = this.initializeValueMappingHelper();
        }
        return this.valueMappingHelper;
    }

    @Override
    public void validateJustBeforeImport(ErrorCollection errors) {
    }

    @Override
    public void copyFromProperties(InputStream is) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Map configCopy = (Map)mapper.readValue(is, Map.class);
        this.copyFromProperties(configCopy, PROJECT_SELECTION_PREFIX, this.projectSelectionMapping);
        this.copyFromProperties(configCopy, PROJECT_KEY_CONFIG_PREFIX, this.projectKeyMapping);
        this.copyFromProperties(configCopy, PROJECT_NAME_CONFIG_PREFIX, this.projectNameMapping);
        this.copyFromProperties(configCopy, FIELD_CONFIG_PREFIX, this.fieldMapping);
        this.copyFromProperties(configCopy, LINK_CONFIG_PREFIX, this.linkMapping);
        this.getValueMappingHelper().copyFromProperties(configCopy);
    }

    @Override
    public void copyToNewProperties(Map<String, Object> configFile) {
        configFile.put(PROJECT_SELECTION_PREFIX, ImmutableMap.copyOf(this.projectSelectionMapping));
        configFile.put(PROJECT_KEY_CONFIG_PREFIX, ImmutableMap.copyOf(this.projectKeyMapping));
        configFile.put(PROJECT_NAME_CONFIG_PREFIX, ImmutableMap.copyOf(this.projectNameMapping));
        configFile.put(FIELD_CONFIG_PREFIX, ImmutableMap.copyOf(this.fieldMapping));
        configFile.put(LINK_CONFIG_PREFIX, ImmutableMap.copyOf(this.linkMapping));
        this.getValueMappingHelper().copyToNewProperties(configFile);
    }

    private void copyFromProperties(Map<String, Object> configFile, String prefix, Map<String, String> mappings) {
        if (configFile.containsKey(prefix)) {
            mappings.putAll((Map)configFile.get(prefix));
        }
    }

    public boolean isSelectedFieldMapping(String fieldName, String mappedField) {
        String currentlySelected = this.getFieldMapping(fieldName);
        return currentlySelected != null && currentlySelected.equals(mappedField);
    }

    public String mapToIssueFieldValue(String mappedField) {
        return ISSUE_FIELD_MAPPING + mappedField;
    }

    public boolean isFieldMappedToIssueField(String fieldName) {
        return this.fieldMapping.containsKey(fieldName) ? StringUtils.defaultString((String)this.fieldMapping.get(fieldName), (String)"").startsWith(ISSUE_FIELD_MAPPING) : false;
    }

    @Nullable
    public String getIssueFieldMapping(String fieldName) {
        return this.isFieldMappedToIssueField(fieldName) ? this.fieldMapping.get(fieldName).substring(ISSUE_FIELD_MAPPING.length()) : null;
    }

    public String getFieldMapping(String fieldName) {
        return this.fieldMapping.get(fieldName);
    }

    public void populateProjectKeyMappings(Map<String, ExternalProject> projectKeyMappings) {
        this.projectLeadMapping.clear();
        this.projectKeyMapping.clear();
        this.projectSelectionMapping.clear();
        this.projectNameMapping.clear();
        this.projectTypeMapping.clear();
        for (String projectName : this.getExternalProjectNames()) {
            boolean isChecked = projectKeyMappings.containsKey(projectName);
            this.projectSelectionMapping.put(projectName, Boolean.toString(isChecked));
            if (!isChecked) continue;
            ExternalProject project = projectKeyMappings.get(projectName);
            this.projectKeyMapping.put(projectName, project.getKey());
            this.projectNameMapping.put(projectName, project.getName());
            this.projectLeadMapping.put(projectName, project.getLead());
            this.projectTypeMapping.put(projectName, project.getType());
        }
    }

    @Nullable
    public CustomField getCustomFieldNameForRanking() {
        CustomFieldManager customFieldManager = this.getCustomFieldManager();
        CustomField ranking = customFieldManager.getCustomFieldObjectByName("Rank");
        if (ranking != null && ranking.isGlobal() && IS_GH_RANKING.apply((Object)ranking)) {
            return ranking;
        }
        List globalCustomFields = customFieldManager.getGlobalCustomFieldObjects();
        return (CustomField)Iterables.find((Iterable)globalCustomFields, IS_GH_RANKING, null);
    }
}

