/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.web;

import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ConfigFileHandler;
import com.atlassian.jira.plugins.importer.web.RemoteSiteImporterSetupPage;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import org.apache.commons.lang.StringUtils;

public class FogBugzHostedSetupPage
extends AbstractSetupPage
implements RemoteSiteImporterSetupPage {
    private String siteUrl;
    private String siteUsername;
    private String sitePassword;
    private final ConfigFileHandler configFileHandler;

    public FogBugzHostedSetupPage(UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, ConfigFileHandler configFileHandler) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
        this.configFileHandler = configFileHandler;
    }

    @Override
    protected void doValidation() {
        if (this.isPreviousClicked()) {
            return;
        }
        super.doValidation();
        if (!this.configFileHandler.verifyConfigFileParam(this)) {
            return;
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ImporterController controller = this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        this.publishImporterWizardStartedEvent();
        if (!this.isPreviousClicked() && !controller.createImportProcessBean(this)) {
            return "input";
        }
        return super.doExecute();
    }

    @Override
    public String getSiteUrl() {
        return this.siteUrl;
    }

    @Override
    public void setSiteUrl(String siteUrl) {
        this.siteUrl = StringUtils.trim((String)siteUrl);
    }

    @Override
    public String getSiteUsername() {
        return this.siteUsername;
    }

    @Override
    public void setSiteUsername(String siteUsername) {
        this.siteUsername = StringUtils.trim((String)siteUsername);
    }

    @Override
    public String getSitePassword() {
        return this.sitePassword;
    }

    @Override
    public void setSitePassword(String sitePassword) {
        this.sitePassword = StringUtils.trim((String)sitePassword);
    }

    @Override
    public boolean getSiteCredentials() {
        return true;
    }

    public boolean getAttachmentsEnabled() {
        return this.getApplicationProperties().getOption("jira.option.allowattachments");
    }

    public boolean getIssueLinkingEnabled() {
        return this.getApplicationProperties().getOption("jira.option.issuelinking");
    }

    @Override
    public boolean isSubtasksEnabled() {
        return true;
    }

    @Override
    public boolean isSiteUrlRequired() {
        return true;
    }

    @Override
    public String getFormTitle() {
        return this.getText("jira-importer-plugin.wizard.step.FogBugzHostedSetupPage");
    }

    @Override
    public String getFormDescription() {
        return this.getText("jira-importer-plugin.wizard.connect.fogbugz.description");
    }

    @Override
    public String getLoginLabel() {
        return this.getText("jira-importer-plugin.wizard.connect.fogbugz.login.label");
    }

    @Override
    public String getPasswordLabel() {
        return this.getText("jira-importer-plugin.wizard.connect.fogbugz.password.label");
    }
}

