/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.transformer;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.customfields.converters.DateTimePickerConverter;
import com.atlassian.jira.plugins.importer.SQLRuntimeException;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.imports.AbstractResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.fogbugz.FogBugzConfigBean;
import com.atlassian.jira.plugins.importer.imports.fogbugz.config.PriorityValueMapper;
import com.atlassian.jira.plugins.importer.imports.fogbugz.config.ResolutionValueMapper;
import com.atlassian.jira.plugins.importer.imports.fogbugz.config.StatusValueMapper;
import com.atlassian.jira.plugins.importer.imports.fogbugz.transformer.BugEventsTransformer;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.SingleStringResultTransformer;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class IssueTransformer
extends AbstractResultSetTransformer<ExternalIssue> {
    private static final int SECONDS_IN_HOUR = 3600;
    private final JdbcConnection jdbcConnection;
    private final FogBugzConfigBean configBean;
    private final ExternalProject externalProject;
    private final DateTimePickerConverter dateTimePicker;
    private final Set<ExternalUser> allUsers;

    public IssueTransformer(FogBugzConfigBean configBean, ExternalProject externalProject, DateTimePickerConverter dateTimePicker, Set<ExternalUser> allUsers, ImportLogger importLogger) {
        super(importLogger);
        this.configBean = configBean;
        this.jdbcConnection = configBean.getJdbcConnection();
        this.externalProject = externalProject;
        this.dateTimePicker = dateTimePicker;
        this.allUsers = allUsers;
    }

    @Override
    public String getSqlQuery() {
        try {
            return String.format("SELECT b.ixBug, b.sTitle, issueType.sCategory, b.fOpen, s.sStatus, %s AS priority, p.sProject, a.sArea, b.sVersion, ff.sFixFor, reporter.sFullName AS Reporter, assignee.sFullName AS Assignee, b.sComputer, b.hrsOrigEst, b.hrsCurrEst, b.hrsElapsed, b.sCustomerEmail, b.sReleaseNotes, b.dtOpened, b.dtClosed, b.dtResolved, b.dtDue FROM Bug b, Project p, Area a, Priority pr, Person reporter, FixFor ff, Person assignee, Category issueType, Status s WHERE b.ixProject = " + this.externalProject.getId() + " AND b.ixProject = p.ixProject AND b.ixArea = a.ixArea AND b.ixPriority = pr.ixPriority AND b.ixFixFor = ff.ixFixFor AND b.ixPersonOpenedBy = reporter.ixPerson AND b.ixPersonAssignedTo = assignee.ixPerson AND b.ixCategory = issueType.ixCategory AND b.ixStatus = s.ixStatus ORDER BY b.ixBug", PriorityValueMapper.isSqlServer(this.jdbcConnection) ? "(CAST(pr.ixPriority AS VARCHAR(20)) + '-' + pr.sPriority)" : "CONCAT(pr.ixPriority,CONCAT('-',pr.sPriority))");
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    @Nullable
    public ExternalIssue transform(ResultSet rs) throws SQLException {
        String fixFor;
        String version;
        String summary = rs.getString("sTitle");
        if (StringUtils.isBlank((String)summary)) {
            this.log.warn("Issuename is blank and is not imported", new Object[0]);
            return null;
        }
        String oldId = rs.getString("ixBug");
        ExternalIssue externalIssue = new ExternalIssue();
        externalIssue.setExternalId(oldId);
        externalIssue.setSummary(summary);
        String issueType = rs.getString("sCategory");
        String translatedIssueType = this.configBean.getValueMappingHelper().getValueMappingForImport("sCategory", issueType);
        externalIssue.setIssueType(translatedIssueType);
        String priority = rs.getString("priority");
        String translatedPriority = this.configBean.getValueMappingHelper().getValueMappingForImport("sPriority", priority);
        externalIssue.setPriority(translatedPriority);
        String area = rs.getString("sArea");
        if (StringUtils.isNotBlank((String)area)) {
            externalIssue.setComponents(Collections.singletonList(area));
        }
        if (StringUtils.isNotBlank((String)(version = rs.getString("sVersion")))) {
            externalIssue.setAffectedVersions(Lists.newArrayList((Object[])new String[]{version}));
        }
        if (StringUtils.isNotBlank((String)(fixFor = rs.getString("sFixFor")))) {
            externalIssue.setFixedVersions(Collections.singleton(fixFor));
        }
        externalIssue.setReporter(this.configBean.getUsernameForFullName(rs.getString("Reporter")));
        externalIssue.setAssignee(this.configBean.getUsernameForFullName(rs.getString("Assignee")));
        externalIssue.setCreated(rs.getTimestamp("dtOpened"));
        externalIssue.setDuedate(rs.getTimestamp("dtDue"));
        externalIssue.setLabels(this.jdbcConnection.queryDb(new SingleStringResultTransformer("SELECT sTag FROM Tag t INNER JOIN TagAssociation ta ON t.ixTag = ta.ixTag WHERE ta.ixBug = " + oldId)));
        Timestamp closed = rs.getTimestamp("dtClosed");
        Timestamp resolved = rs.getTimestamp("dtResolved");
        externalIssue.setResolutionDate(resolved);
        if (closed != null && resolved == null) {
            externalIssue.setUpdated(closed);
        } else if (closed == null && resolved != null) {
            externalIssue.setUpdated(resolved);
        } else if (closed != null) {
            if (closed.after(resolved)) {
                externalIssue.setUpdated(closed);
            } else {
                externalIssue.setUpdated(resolved);
            }
        }
        externalIssue.setExternalCustomFieldValues(this.getCustomFieldValues(rs, oldId));
        String fogBugzStatus = rs.getString("sStatus");
        String cleanedResolution = ResolutionValueMapper.getCleanedResolution(fogBugzStatus);
        String cleanedStatus = StatusValueMapper.getCleanedStatus(fogBugzStatus);
        externalIssue.setStatus(this.configBean.getValueMappingHelper().getValueMappingForImport("sStatus", rs.getBoolean("fOpen") ? cleanedStatus : "Closed"));
        if (cleanedResolution != null) {
            externalIssue.setResolution(this.configBean.getValueMappingHelper().getValueMappingForImport("sStatus (Resolution)", cleanedResolution));
        }
        this.dealWithCommentsAndDescription(oldId, externalIssue);
        long originalEstimate = rs.getLong("hrsOrigEst") * 3600L;
        long timeSpent = rs.getLong("hrsElapsed") * 3600L;
        long currentEstimate = rs.getLong("hrsCurrEst") * 3600L - timeSpent;
        externalIssue.setOriginalEstimate(originalEstimate > 0L ? Long.valueOf(originalEstimate) : null);
        externalIssue.setEstimate(currentEstimate > 0L ? Long.valueOf(currentEstimate) : null);
        externalIssue.setTimeSpent(timeSpent > 0L ? Long.valueOf(timeSpent) : null);
        return externalIssue;
    }

    private void dealWithCommentsAndDescription(String oldId, ExternalIssue externalIssue) {
        BugEventsTransformer bugEventsTransformer = new BugEventsTransformer(oldId, this.configBean, this.allUsers, this.log);
        List<Either<ExternalComment, String>> eithers = this.configBean.getJdbcConnection().queryDb(bugEventsTransformer);
        Either description = (Either)Iterables.find(eithers, (Predicate)new Predicate<Either<ExternalComment, String>>(){

            public boolean apply(Either<ExternalComment, String> input) {
                return input.isRight();
            }
        }, null);
        if (description != null) {
            externalIssue.setDescription((String)description.right().get());
        }
        Iterable commentEithers = Iterables.filter(eithers, (Predicate)new Predicate<Either<ExternalComment, String>>(){

            public boolean apply(Either<ExternalComment, String> input) {
                return input.isLeft();
            }
        });
        Iterable comments = Iterables.transform((Iterable)commentEithers, (Function)new Function<Either<ExternalComment, String>, ExternalComment>(){

            public ExternalComment apply(Either<ExternalComment, String> input) {
                return (ExternalComment)input.left().get();
            }
        });
        externalIssue.setComments(Lists.newArrayList((Iterable)comments));
    }

    protected List<ExternalCustomFieldValue> getCustomFieldValues(ResultSet rs, String bugId) throws SQLException {
        ArrayList customFields = Lists.newArrayList();
        for (ExternalCustomField customField : this.configBean.getCustomFields()) {
            String value;
            value = "com.atlassian.jira.plugin.system.customfieldtypes:select".equals(customField.getTypeKey()) ? ("---".equals(value = this.configBean.getValueMappingHelper().getValueMappingForImport(customField.getId(), rs.getString(customField.getId()))) ? null : value) : ("com.atlassian.jira.plugin.system.customfieldtypes:datetime".equals(customField.getTypeKey()) ? this.dateTimePicker.getString((Date)rs.getTimestamp(customField.getId())) : this.configBean.getValueMappingHelper().getValueMappingForImport(customField.getId(), rs.getString(customField.getId())));
            if (StringUtils.isBlank((String)value)) continue;
            String mapping = this.configBean.getFieldMapping(customField.getId());
            String customFieldName = StringUtils.isNotEmpty((String)mapping) ? mapping : customField.getName();
            ExternalCustomFieldValue customFieldValue = new ExternalCustomFieldValue(customFieldName, customField.getTypeKey(), customField.getSearcherKey(), value);
            customFields.add(customFieldValue);
        }
        return customFields;
    }
}

