/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.AbstractResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import java.sql.ResultSet;
import java.sql.SQLException;

public class FixForVersionTransformer
extends AbstractResultSetTransformer<ExternalVersion> {
    private final ExternalProject externalProject;

    public FixForVersionTransformer(ExternalProject externalProject, ImportLogger importLogger) {
        super(importLogger);
        this.externalProject = externalProject;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT ixFixFor, sFixFor, fDeleted, fInactive, dt FROM FixFor WHERE ixProject = -1 OR ixProject = " + this.externalProject.getId() + " AND sFixFor IS NOT NULL AND sFixFor != '' ORDER BY dt DESC, sFixFor";
    }

    @Override
    public ExternalVersion transform(ResultSet rs) throws SQLException {
        ExternalVersion externalVersion = new ExternalVersion(rs.getString("sFixFor"));
        boolean isArchived = rs.getBoolean("fInactive") || rs.getBoolean("fDeleted");
        externalVersion.setArchived(isArchived);
        externalVersion.setReleaseDate(rs.getTimestamp("dt"));
        return externalVersion;
    }
}

