/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.hosted;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.plugins.importer.imports.AbstractResolutionValueMapper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.plugins.importer.imports.fogbugz.config.ResolutionValueMapper;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzHostedConfigBean;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzRemoteException;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

class ResolutionValueMappingDefinition
implements ValueMappingDefinition {
    private FogBugzHostedConfigBean configBean;
    private ConstantsManager constantsManager;

    public ResolutionValueMappingDefinition(FogBugzHostedConfigBean configBean, ConstantsManager constantsManager) {
        this.configBean = configBean;
        this.constantsManager = constantsManager;
    }

    @Override
    public String getExternalFieldId() {
        return "sStatus (Resolution)";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Set<String> getDistinctValues() {
        try {
            HashSet statuses = Sets.newHashSet((Iterable)Collections2.filter((Collection)Collections2.transform(this.configBean.getClient().getStatuses(), (Function)new Function<String, String>(){

                public String apply(@Nullable String input) {
                    return input != null ? ResolutionValueMapper.getCleanedResolution(input) : null;
                }
            }), (Predicate)new Predicate<String>(){

                public boolean apply(@Nullable String input) {
                    return StringUtils.isNotBlank((String)input);
                }
            }));
            statuses.add("Closed");
            return statuses;
        }
        catch (FogBugzRemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getJiraFieldId() {
        return "resolution";
    }

    @Override
    public Collection<ValueMappingEntry> getTargetValues() {
        return AbstractResolutionValueMapper.getAllResolutions(this.constantsManager);
    }

    @Override
    public Collection<ValueMappingEntry> getDefaultValues() {
        return new ImmutableList.Builder().add((Object[])new ValueMappingEntry[]{new ValueMappingEntry("Fixed", 1), new ValueMappingEntry("By Design", 2), new ValueMappingEntry("Duplicate", 3), new ValueMappingEntry("Completed", 1), new ValueMappingEntry("Already Exists", 3), new ValueMappingEntry("Won't Fix", 2), new ValueMappingEntry("Won't Implement", 2), new ValueMappingEntry("Won't Respond", 2), new ValueMappingEntry("Closed", 1), new ValueMappingEntry("Not Reproducible", 5), new ValueMappingEntry("Postponed", 2), new ValueMappingEntry("Waiting For Info", 4), new ValueMappingEntry("Implemented", 1)}).build();
    }

    @Override
    public boolean canBeBlank() {
        return false;
    }

    @Override
    public boolean canBeImportedAsIs() {
        return true;
    }

    @Override
    public boolean canBeCustom() {
        return true;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }
}

