/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.hosted;

import com.atlassian.jira.plugins.importer.XmlUtil;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.jdom.Element;

public class ProjectParser {
    public String getName(Element element) {
        return element.getChildText("sProject");
    }

    public Collection<String> getProjectNames(Element response) {
        return Lists.newArrayList((Iterable)Collections2.transform(XmlUtil.getChildren(response.getChild("projects"), "project"), (Function)new Function<Element, String>(){

            public String apply(Element from) {
                return ProjectParser.this.getName(from);
            }
        }));
    }

    public Collection<ExternalProject> getProjects(Element response) {
        return Lists.newArrayList((Iterable)Collections2.transform(XmlUtil.getChildren(response.getChild("projects"), "project"), (Function)new Function<Element, ExternalProject>(){

            public ExternalProject apply(Element from) {
                return ProjectParser.this.getProject(from);
            }
        }));
    }

    public ExternalProject getProject(Element element) {
        String id = element.getChildText("ixProject");
        String name = this.getName(element);
        ExternalProject project = new ExternalProject(name, null);
        project.setLead(element.getChildText("sEmail"));
        project.setId(id);
        return project;
    }
}

